/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.HashSet;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;

public class DictionaryDetokenizer
implements Detokenizer {
    private final DetokenizationDictionary dict;

    public DictionaryDetokenizer(DetokenizationDictionary dict) {
        this.dict = dict;
    }

    public Detokenizer.DetokenizationOperation[] detokenize(String[] tokens) {
        Detokenizer.DetokenizationOperation[] operations = new Detokenizer.DetokenizationOperation[tokens.length];
        HashSet<String> matchingTokens = new HashSet<String>();
        for (int i = 0; i < tokens.length; ++i) {
            DetokenizationDictionary.Operation dictOperation = this.dict.getOperation(tokens[i]);
            if (dictOperation == null) {
                operations[i] = Detokenizer.DetokenizationOperation.NO_OPERATION;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_LEFT.equals((Object)dictOperation)) {
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_RIGHT.equals((Object)dictOperation)) {
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_BOTH.equals((Object)dictOperation)) {
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_BOTH;
                continue;
            }
            if (DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING.equals((Object)dictOperation)) {
                if (matchingTokens.contains(tokens[i])) {
                    operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                    matchingTokens.remove(tokens[i]);
                    continue;
                }
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                matchingTokens.add(tokens[i]);
                continue;
            }
            throw new IllegalStateException("Unknown operation: " + (Object)((Object)dictOperation));
        }
        return operations;
    }

    public String detokenize(String[] tokens, String splitMarker) {
        Detokenizer.DetokenizationOperation[] operations = this.detokenize(tokens);
        if (tokens.length != operations.length) {
            throw new IllegalArgumentException("tokens and operations array must have same length: tokens=" + tokens.length + ", operations=" + operations.length + "!");
        }
        StringBuilder untokenizedString = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            boolean isAppendSplitMarker;
            boolean isAppendSpace;
            untokenizedString.append(tokens[i]);
            if (i + 1 == operations.length) {
                isAppendSpace = false;
                isAppendSplitMarker = false;
            } else if (operations[i + 1].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_LEFT) || operations[i + 1].equals((Object)Detokenizer.DetokenizationOperation.MERGE_BOTH)) {
                isAppendSpace = false;
                isAppendSplitMarker = true;
            } else if (operations[i].equals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT) || operations[i].equals((Object)Detokenizer.DetokenizationOperation.MERGE_BOTH)) {
                isAppendSpace = false;
                isAppendSplitMarker = true;
            } else {
                isAppendSpace = true;
                isAppendSplitMarker = false;
            }
            if (isAppendSpace) {
                untokenizedString.append(' ');
            }
            if (!isAppendSplitMarker || splitMarker == null) continue;
            untokenizedString.append(splitMarker);
        }
        return untokenizedString.toString();
    }
}

