/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.real;

import choco.kernel.memory.IStateDouble;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.real.RealDomain;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealVar;

public class RealDomainImpl
implements RealDomain {
    final PropagationEngine propagationEngine;
    protected double currentInfPropagated = Double.NEGATIVE_INFINITY;
    protected double currentSupPropagated = Double.POSITIVE_INFINITY;
    protected IStateDouble inf;
    protected IStateDouble sup;
    protected RealVar variable;
    private final Solver solver;

    public RealDomainImpl(RealVar v, double a, double b, Solver solver) {
        this.variable = v;
        this.solver = solver;
        this.propagationEngine = solver.getPropagationEngine();
        this.inf = solver.getEnvironment().makeFloat(a);
        this.sup = solver.getEnvironment().makeFloat(b);
    }

    public String toString() {
        return "[" + this.getInf() + ", " + this.getSup() + "]";
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public double getInf() {
        return this.inf.get();
    }

    @Override
    public double getSup() {
        return this.sup.get();
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        boolean toAwake;
        if (interval.getInf() > this.getSup() || interval.getSup() < this.getInf()) {
            this.propagationEngine.raiseContradiction(this);
        }
        double old_width = this.getSup() - this.getInf();
        double new_width = Math.min(interval.getSup(), this.getSup()) - Math.max(interval.getInf(), this.getInf());
        boolean bl = toAwake = this.solver.getPrecision() / 100.0 <= old_width && new_width < old_width * this.solver.getReduction();
        if (interval.getInf() > this.getInf()) {
            if (toAwake) {
                this.propagationEngine.postUpdateInf(this.variable, null, true);
            }
            this.inf.set(interval.getInf());
        }
        if (interval.getSup() < this.getSup()) {
            if (toAwake) {
                this.propagationEngine.postUpdateSup(this.variable, null, true);
            }
            this.sup.set(interval.getSup());
        }
    }

    @Override
    public void clearDeltaDomain() {
        this.currentInfPropagated = Double.NEGATIVE_INFINITY;
        this.currentSupPropagated = Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean releaseDeltaDomain() {
        boolean noNewUpdate = this.getInf() == this.currentInfPropagated && this.getSup() == this.currentSupPropagated;
        this.currentInfPropagated = Double.NEGATIVE_INFINITY;
        this.currentSupPropagated = Double.POSITIVE_INFINITY;
        return noNewUpdate;
    }

    @Override
    public void freezeDeltaDomain() {
        this.currentInfPropagated = this.getInf();
        this.currentSupPropagated = this.getSup();
    }

    @Override
    public boolean getReleasedDeltaDomain() {
        return true;
    }

    @Override
    public void silentlyAssign(RealInterval i) {
        this.inf.set(i.getInf());
        this.sup.set(i.getSup());
    }
}

