/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.DROP3LVQ3;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ3;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Algorithms.Preprocess.Basic.Referencia;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class DROP3LVQ3
extends Metodo {
    private int k;
    private double semilla;
    public String Script;
    private PrototypeSet trainingDataSet;
    private PrototypeGenerator generador;
    private int Maxiter;
    private double alpha0;
    private double windowW;
    private double epsilon;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;

    public DROP3LVQ3(String ficheroScript) {
        super(ficheroScript);
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public double classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = DROP3LVQ3._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return 100.0 * ((double)wellClassificated / (double)test.size());
    }

    public void ejecutar() {
        int m;
        int l;
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        double dist;
        int j;
        int claseObt;
        int i;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
        }
        int nSel = this.datosTrain.length;
        for (i = 0; i < this.datosTrain.length; ++i) {
            claseObt = KNN.evaluacionKNN2((int)this.k, (double[][])this.datosTrain, (double[][])this.realTrain, (int[][])this.nominalTrain, (boolean[][])this.nulosTrain, (int[])this.clasesTrain, (double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (int)nClases, (boolean)this.distanceEu);
            if (claseObt == this.clasesTrain[i]) continue;
            marcas[i] = false;
            --nSel;
        }
        Object[] orden = new Referencia[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            double bestD = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.datosTrain.length; ++j) {
                if (this.clasesTrain[i] == this.clasesTrain[j] || !((dist = KNN.distancia((double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (double[])this.datosTrain[j], (double[])this.realTrain[j], (int[])this.nominalTrain[j], (boolean[])this.nulosTrain[j], (boolean)this.distanceEu)) < bestD)) continue;
                bestD = dist;
            }
            orden[i] = new Referencia(i, bestD);
        }
        Arrays.sort(orden);
        double[] distTemp = new double[this.k + 1];
        int[] vecinosTemp = new int[this.k + 1];
        int[][] vecinos = new int[this.datosTrain.length][this.k + 1];
        Vector[] asociados = new Vector[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            asociados[i] = new Vector();
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            KNN.evaluacionKNN2((int)(this.k + 1), (double[][])this.datosTrain, (double[][])this.realTrain, (int[][])this.nominalTrain, (boolean[][])this.nulosTrain, (int[])this.clasesTrain, (double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (int)nClases, (boolean)this.distanceEu, (int[])vecinos[i]);
            for (j = 0; j < vecinos[i].length; ++j) {
                if (vecinos[i][j] < 0) continue;
                asociados[vecinos[i][j]].addElement(new Referencia(i, 0.0));
            }
        }
        for (int o = 0; o < this.datosTrain.length; ++o) {
            i = ((Referencia)orden[o]).entero;
            if (!marcas[i]) continue;
            int aciertosSin = 0;
            marcas[i] = false;
            conjS = new double[--nSel][this.datosTrain[0].length];
            conjR = new double[nSel][this.datosTrain[0].length];
            conjN = new int[nSel][this.datosTrain[0].length];
            conjM = new boolean[nSel][this.datosTrain[0].length];
            clasesS = new int[nSel];
            l = 0;
            for (m = 0; m < this.datosTrain.length; ++m) {
                if (!marcas[m]) continue;
                for (j = 0; j < this.datosTrain[0].length; ++j) {
                    conjS[l][j] = this.datosTrain[m][j];
                    conjR[l][j] = this.realTrain[m][j];
                    conjN[l][j] = this.nominalTrain[m][j];
                    conjM[l][j] = this.nulosTrain[m][j];
                }
                clasesS[l] = this.clasesTrain[m];
                ++l;
            }
            marcas[i] = true;
            ++nSel;
            for (j = 0; j < this.k + 1; ++j) {
                if (vecinos[i][j] < 0 || (claseObt = KNN.evaluacionKNN2((int)this.k, (double[][])conjS, (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (double[])this.datosTrain[vecinos[i][j]], (double[])this.realTrain[vecinos[i][j]], (int[])this.nominalTrain[vecinos[i][j]], (boolean[])this.nulosTrain[vecinos[i][j]], (int)nClases, (boolean)this.distanceEu)) != this.clasesTrain[vecinos[i][j]]) continue;
                ++aciertosSin;
            }
            int mayoria = (this.k + 1) / 2;
            if (aciertosSin <= mayoria) continue;
            marcas[i] = false;
            --nSel;
            for (j = 0; j < asociados[i].size(); ++j) {
                boolean parar;
                for (l = 0; l < this.k + 1; ++l) {
                    vecinosTemp[l] = vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l];
                    vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l] = -1;
                    distTemp[l] = Double.POSITIVE_INFINITY;
                }
                for (l = 0; l < this.datosTrain.length; ++l) {
                    if (!marcas[l]) continue;
                    dist = KNN.distancia((double[])this.datosTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (double[])this.realTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (int[])this.nominalTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (boolean[])this.nulosTrain[((Referencia)asociados[i].elementAt((int)j)).entero], (double[])this.datosTrain[l], (double[])this.realTrain[l], (int[])this.nominalTrain[l], (boolean[])this.nulosTrain[l], (boolean)this.distanceEu);
                    parar = false;
                    for (m = 0; m < this.k + 1 && !parar; ++m) {
                        if (!(dist < distTemp[m])) continue;
                        parar = true;
                        for (int n = m + 1; n < this.k + 1; ++n) {
                            distTemp[n] = distTemp[n - 1];
                            vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][n] = vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][n - 1];
                        }
                        distTemp[m] = dist;
                        vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][m] = l;
                    }
                }
                for (l = 0; l < this.k + 1; ++l) {
                    parar = false;
                    for (m = 0; m < asociados[vecinosTemp[l]].size() && !parar; ++m) {
                        if (((Referencia)asociados[vecinosTemp[l]].elementAt((int)m)).entero != ((Referencia)asociados[i].elementAt((int)j)).entero || vecinosTemp[l] == i) continue;
                        asociados[vecinosTemp[l]].removeElementAt(m);
                        parar = true;
                    }
                }
                for (l = 0; l < this.k + 1; ++l) {
                    asociados[vecinos[((Referencia)asociados[i].elementAt((int)j)).entero][l]].addElement(new Referencia(((Referencia)asociados[i].elementAt((int)j)).entero, 0.0));
                }
            }
        }
        conjS = new double[nSel][this.datosTrain[0].length];
        conjR = new double[nSel][this.datosTrain[0].length];
        conjN = new int[nSel][this.datosTrain[0].length];
        conjM = new boolean[nSel][this.datosTrain[0].length];
        clasesS = new int[nSel];
        l = 0;
        for (m = 0; m < this.datosTrain.length; ++m) {
            if (!marcas[m]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[m][j];
                conjR[l][j] = this.realTrain[m][j];
                conjN[l][j] = this.nominalTrain[m][j];
                conjM[l][j] = this.nulosTrain[m][j];
            }
            clasesS[l] = this.clasesTrain[m];
            ++l;
        }
        System.out.println("DROP3 " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida((String)this.ficheroSalida[0], (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        OutputIS.escribeSalida((String)this.ficheroSalida[1], (InstanceSet)this.test, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        Parameters.assertBasicArgs(this.ficheroSalida);
        PrototypeGenerationAlgorithm.readParametersFile(this.Script);
        PrototypeGenerationAlgorithm.printParameters();
        PrototypeSet training = DROP3LVQ3.readPrototypeSet(this.ficheroSalida[0]);
        this.trainingDataSet = DROP3LVQ3.readPrototypeSet(this.ficheroTraining);
        this.generador = new PrototypeGenerator(this.trainingDataSet);
        double initialAcc = this.classficationAccuracy1NN(training, this.trainingDataSet);
        System.out.println("Initial Acc = " + initialAcc);
        PrototypeSet LVQ32 = this.makeLVQ3Reduction(training, this.trainingDataSet);
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(LVQ32);
        initialAcc = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        System.out.println("Final Acc = " + initialAcc);
        LVQ32.save(this.ficheroSalida[0]);
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate((double[])this.datosTrain[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[0], (int[][])trainRealClass, (int[][])trainPrediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate((double[])this.datosTest[i], (double[][])LVQ32.prototypeSetTodouble(), (int)nClases, (int[])LVQ32.getClases(), (int)1);
        }
        KNN.writeOutput((String)this.ficheroSalida[1], (int[][])realClass, (int[][])prediction, (Attribute[])this.entradas, (Attribute)this.salida, (String)this.relation);
    }

    private PrototypeSet makeLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training) {
        int size = InitialSet.size();
        LVQ3 lvq3 = new LVQ3(InitialSet, training, this.Maxiter, size, this.alpha0, this.windowW, this.epsilon);
        PrototypeSet reducedByLVQ3 = lvq3.reduceSet();
        return reducedByLVQ3;
    }

    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.Maxiter = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.alpha0 = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.windowW = Double.parseDouble(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.epsilon = Double.parseDouble(tokens.nextToken().substring(1));
        System.out.print("\nIsaac dice:   alpha0= " + this.alpha0 + " Maxiter= " + this.Maxiter + " epsilon=  " + this.epsilon + "\n");
    }
}

