/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.myDataset;

public class AssocRuleMining {
    protected RuleNode startRulelist = null;
    protected short[][] dataArray = null;
    protected int[][] conversionArray = null;
    protected short[] reconversionArray = null;
    protected int numCols = 0;
    protected int numRows = 0;
    protected double support = 0.0;
    protected double minSupport = 0.0;
    protected double confidence = 0.0;
    protected int numOneItemSets = 0;
    protected myDataset dataset;
    protected boolean isOrderedFlag;
    protected boolean isPrunedFlag;

    public AssocRuleMining(myDataset ds, double sup, double conf) {
        int[][] trans = ds.getFakeTransactions();
        int nTrans = ds.getnTrans();
        int nAttr = ds.getnVars();
        this.support = sup * 100.0;
        this.confidence = conf * 100.0;
        this.numRows = nTrans;
        this.minSupport = (double)this.numRows * this.support / 100.0;
        this.dataArray = new short[this.numRows][nAttr];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < nAttr; ++j) {
                this.dataArray[i][j] = (short)trans[i][j];
            }
        }
        this.numCols = this.numOneItemSets = ds.getIDsOfAllAttributeValues().size();
        this.dataset = ds;
    }

    public void idInputDataOrdering() {
        int[][] countArray = this.countSingles();
        this.orderCountArray(countArray);
        this.defConvertArrays(countArray);
        this.isOrderedFlag = true;
    }

    protected int[][] countSingles() {
        int[][] countArray = new int[this.numCols + 1][2];
        for (int index = 0; index < countArray.length; ++index) {
            countArray[index][0] = index;
            countArray[index][1] = 0;
        }
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            if (this.dataArray[rowIndex] == null) continue;
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                int[] nArray = countArray[this.dataArray[rowIndex][colIndex]];
                nArray[1] = nArray[1] + 1;
            }
        }
        return countArray;
    }

    private void orderCountArray(int[][] countArray) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 1;
            while (index < countArray.length - 1) {
                if (countArray[index][1] >= countArray[index + 1][1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                int attribute = countArray[index][0];
                int quantity = countArray[index][1];
                countArray[index][0] = countArray[index + 1][0];
                countArray[index][1] = countArray[index + 1][1];
                countArray[index + 1][0] = attribute;
                countArray[index + 1][1] = quantity;
                ++index;
            }
        } while (!isOrdered);
    }

    protected void orderFirstNofCountArray(int[][] countArray, int endIndex) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 1;
            while (index < endIndex) {
                if (countArray[index][1] >= countArray[index + 1][1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                int attribute = countArray[index][0];
                int quantity = countArray[index][1];
                countArray[index][0] = countArray[index + 1][0];
                countArray[index][1] = countArray[index + 1][1];
                countArray[index + 1][0] = attribute;
                countArray[index + 1][1] = quantity;
                ++index;
            }
        } while (!isOrdered);
    }

    protected void defConvertArrays(int[][] countArray) {
        this.conversionArray = new int[this.numCols + 1][2];
        this.reconversionArray = new short[this.numCols + 1];
        for (int index = 1; index < countArray.length; ++index) {
            this.conversionArray[countArray[index][0]][0] = index;
            this.conversionArray[countArray[index][0]][1] = countArray[index][1];
            this.reconversionArray[index] = (short)countArray[index][0];
        }
    }

    public void recastInputData() {
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            short[] itemSet = new short[this.dataArray[rowIndex].length];
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                short attribute = this.dataArray[rowIndex][colIndex];
                itemSet[colIndex] = (short)this.conversionArray[attribute][0];
            }
            this.sortItemSet(itemSet);
            this.dataArray[rowIndex] = itemSet;
        }
    }

    public void recastInputDataAndPruneUnsupportedAtts() {
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            if (this.dataArray[rowIndex] == null) continue;
            short[] itemSet = null;
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                short attribute = this.dataArray[rowIndex][colIndex];
                if (!((double)this.conversionArray[attribute][1] >= this.minSupport)) continue;
                itemSet = this.reallocInsert(itemSet, (short)this.conversionArray[attribute][0]);
            }
            this.dataArray[rowIndex] = itemSet;
        }
        this.isPrunedFlag = true;
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    protected int getNumSupOneItemSets() {
        int counter = 0;
        for (int index = 1; index < this.conversionArray.length; ++index) {
            if (!((double)this.conversionArray[index][1] >= this.minSupport)) continue;
            ++counter;
        }
        return counter;
    }

    protected short[] reconvertItemSet(short[] itemSet) {
        if (this.reconversionArray == null) {
            return itemSet;
        }
        if (itemSet == null) {
            return null;
        }
        short[] newItemSet = new short[itemSet.length];
        for (int index = 0; index < newItemSet.length; ++index) {
            newItemSet[index] = this.reconversionArray[itemSet[index]];
        }
        return newItemSet;
    }

    protected short reconvertItem(short item) {
        if (this.reconversionArray == null) {
            return item;
        }
        return this.reconversionArray[item];
    }

    protected void insertRuleintoRulelist(short[] antecedent, short[] consequent, double confidenceForRule, double supportForRule, double supportForAntecedent, double supportForConsequent) {
        RuleNode newNode = new RuleNode(antecedent, consequent, confidenceForRule, supportForRule, supportForAntecedent, supportForConsequent);
        if (this.startRulelist == null) {
            this.startRulelist = newNode;
            return;
        }
        if (confidenceForRule > this.startRulelist.confidenceForRule) {
            newNode.next = this.startRulelist;
            this.startRulelist = newNode;
            return;
        }
        RuleNode markerNode = this.startRulelist;
        RuleNode linkRuleNode = this.startRulelist.next;
        while (linkRuleNode != null) {
            if (confidenceForRule > linkRuleNode.confidenceForRule) {
                markerNode.next = newNode;
                newNode.next = linkRuleNode;
                return;
            }
            markerNode = linkRuleNode;
            linkRuleNode = linkRuleNode.next;
        }
        markerNode.next = newNode;
    }

    protected short[] reallocInsert(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        for (int index1 = 0; index1 < oldItemSetLength; ++index1) {
            if (newElement < oldItemSet[index1]) {
                newItemSet[index1] = newElement;
                for (int index2 = index1 + 1; index2 < newItemSet.length; ++index2) {
                    newItemSet[index2] = oldItemSet[index2 - 1];
                }
                return newItemSet;
            }
            newItemSet[index1] = oldItemSet[index1];
        }
        newItemSet[newItemSet.length - 1] = newElement;
        return newItemSet;
    }

    protected short[] realloc1(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        for (int index = 0; index < oldItemSetLength; ++index) {
            newItemSet[index] = oldItemSet[index];
        }
        newItemSet[index] = newElement;
        return newItemSet;
    }

    protected short[] realloc2(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        newItemSet[0] = newElement;
        for (int index = 0; index < oldItemSetLength; ++index) {
            newItemSet[index + 1] = oldItemSet[index];
        }
        return newItemSet;
    }

    protected short[] removeElementN(short[] oldItemSet, int n) {
        int index;
        if (oldItemSet.length <= n) {
            return oldItemSet;
        }
        short[] newItemSet = new short[oldItemSet.length - 1];
        for (index = 0; index < n; ++index) {
            newItemSet[index] = oldItemSet[index];
        }
        for (index = n + 1; index < oldItemSet.length; ++index) {
            newItemSet[index - 1] = oldItemSet[index];
        }
        return newItemSet;
    }

    protected short[] complement(short[] itemSet1, short[] itemSet2) {
        int lengthOfComp = itemSet2.length - itemSet1.length;
        if (lengthOfComp < 1) {
            return null;
        }
        short[] complement = new short[lengthOfComp];
        int complementIndex = 0;
        for (int index = 0; index < itemSet2.length; ++index) {
            if (!this.notMemberOf(itemSet2[index], itemSet1)) continue;
            complement[complementIndex] = itemSet2[index];
            ++complementIndex;
        }
        return complement;
    }

    protected void sortItemSet(short[] itemSet) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 0;
            while (index < itemSet.length - 1) {
                if (itemSet[index] <= itemSet[index + 1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                short temp = itemSet[index];
                itemSet[index] = itemSet[index + 1];
                itemSet[index + 1] = temp;
                ++index;
            }
        } while (!isOrdered);
    }

    protected boolean notMemberOf(short number, short[] itemSet) {
        for (int index = 0; index < itemSet.length; ++index) {
            if (number < itemSet[index]) {
                return true;
            }
            if (number != itemSet[index]) continue;
            return false;
        }
        return true;
    }

    protected short[] copyItemSet(short[] itemSet) {
        if (itemSet == null) {
            return null;
        }
        short[] newItemSet = new short[itemSet.length];
        for (int index = 0; index < itemSet.length; ++index) {
            newItemSet[index] = itemSet[index];
        }
        return newItemSet;
    }

    public void outputDataArray() {
        if (this.isPrunedFlag) {
            System.out.println("DATA SET (Ordered and Pruned)\n-----------------------------");
        } else if (this.isOrderedFlag) {
            System.out.println("DATA SET (Ordered)\n------------------");
        } else {
            System.out.println("DATA SET\n--------");
        }
        for (int index = 0; index < this.dataArray.length; ++index) {
            this.outputItemSet(this.dataArray[index]);
            System.out.println();
        }
    }

    protected void outputItemSet(short[] itemSet) {
        if (itemSet == null) {
            System.out.print(" null ");
        } else {
            short[] tempItemSet = this.reconvertItemSet(itemSet);
            int counter = 0;
            for (int index = 0; index < tempItemSet.length; ++index) {
                if (counter == 0) {
                    ++counter;
                    System.out.print(" {");
                } else {
                    System.out.print(" ");
                }
                System.out.print(tempItemSet[index]);
            }
            System.out.print("} ");
        }
    }

    public void outputRules() {
        System.out.println("\nASSOCIATION RULES\n=================");
        this.outputRules(this.startRulelist);
    }

    public void outputRules(RuleNode ruleList) {
        if (ruleList == null) {
            System.out.println("No rules generated!");
        }
        int number = 1;
        RuleNode linkRuleNode = ruleList;
        while (linkRuleNode != null) {
            System.out.print("(" + number + ") ");
            this.outputRule(linkRuleNode);
            System.out.println(" " + this.twoDecPlaces(linkRuleNode.confidenceForRule) + "%");
            ++number;
            linkRuleNode = linkRuleNode.next;
        }
    }

    private void outputRule(RuleNode rule) {
        this.outputItemSet(rule.antecedent);
        System.out.print(" -> ");
        this.outputItemSet(rule.consequent);
    }

    protected double twoDecPlaces(double number) {
        int numInt = (int)((number + 0.005) * 100.0);
        number = (double)numInt / 100.0;
        return number;
    }

    public ArrayList<AssociationRule> getRulesSet() {
        RuleNode linkRuleNode = this.startRulelist;
        ArrayList<AssociationRule> rules = new ArrayList<AssociationRule>();
        while (linkRuleNode != null) {
            rules.add(new AssociationRule(this.reconvertItemSet(linkRuleNode.antecedent), this.reconvertItemSet(linkRuleNode.consequent), linkRuleNode.supportForRule / (double)this.numRows, linkRuleNode.supportForAntecedent / (double)this.numRows, linkRuleNode.supportForConsequent / (double)this.numRows, linkRuleNode.confidenceForRule / 100.0));
            linkRuleNode = linkRuleNode.next;
        }
        return rules;
    }

    protected class RuleNode {
        protected short[] antecedent;
        protected short[] consequent;
        double confidenceForRule = 0.0;
        double supportForRule = 0.0;
        double supportForAntecedent = 0.0;
        double supportForConsequent = 0.0;
        RuleNode next = null;

        protected RuleNode(short[] ante, short[] cons, double confValue, double ruleSupValue, double antSupValue) {
            this.antecedent = ante;
            this.consequent = cons;
            this.confidenceForRule = confValue;
            this.supportForRule = ruleSupValue;
            this.supportForAntecedent = antSupValue;
        }

        protected RuleNode(short[] ante, short[] cons, double confValue, double ruleSupValue, double antSupValue, double conSupValue) {
            this.antecedent = ante;
            this.consequent = cons;
            this.confidenceForRule = confValue;
            this.supportForRule = ruleSupValue;
            this.supportForAntecedent = antSupValue;
            this.supportForConsequent = conSupValue;
        }
    }
}

