/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.Month;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.IntList;
import ec.tstoolkit.utilities.Jdk6;
import ec.tstoolkit.utilities.Tokenizer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public final class StringFormatter {
    private static final NumberFormat fmt = NumberFormat.getNumberInstance(Locale.ROOT);

    public static Day convertDay(String str) {
        return StringFormatter.convertDay(str, new Day(new Date()));
    }

    public static Day convertDay(String str, Day defaultDay) {
        try {
            return Day.fromString(str);
        }
        catch (ParseException err) {
            return defaultDay;
        }
    }

    public static String convert(Day day) {
        return day.toString();
    }

    public static String convert(Day day, Day defaultDay) {
        if (day == defaultDay) {
            return null;
        }
        return day.toString();
    }

    public static Day yearMonth(String str) {
        String[] split;
        if (str != null && str.length() == 7 && (split = str.split("-")).length == 2) {
            return new Day(Integer.getInteger(split[0]), Month.valueOf(Integer.getInteger(split[1]) - 1), 0);
        }
        return null;
    }

    public static String yearMonth(Day day) {
        return day.getYear() + "-" + (1 + day.getMonth());
    }

    public static boolean read(IntList c, String str) {
        Tokenizer tokens = new Tokenizer(str);
        while (tokens.hasNextToken()) {
            int val;
            String next = tokens.nextToken();
            try {
                val = Integer.parseInt(next);
            }
            catch (Exception ex) {
                return false;
            }
            c.add(val);
        }
        return true;
    }

    private StringFormatter() {
    }

    public static String write(TsPeriod period) {
        if (period == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(period.getYear());
        switch (period.getFrequency()) {
            case Yearly: {
                return builder.toString();
            }
            case HalfYearly: {
                builder.append('H');
                break;
            }
            case QuadriMonthly: {
                builder.append('T');
                break;
            }
            case Quarterly: {
                builder.append('Q');
                break;
            }
            case BiMonthly: {
                builder.append('B');
                break;
            }
            case Monthly: {
                builder.append('M');
            }
        }
        builder.append(period.getPosition() + 1);
        return builder.toString();
    }

    public static TsPeriod readPeriod(String s) {
        int freq;
        if (s == null) {
            return null;
        }
        int pos = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetter(s.charAt(i))) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            try {
                int year = Integer.parseInt(s);
                return new TsPeriod(TsFrequency.Yearly, year, 0);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        switch (s.charAt(pos)) {
            case 'H': {
                freq = 2;
                break;
            }
            case 'T': {
                freq = 3;
                break;
            }
            case 'Q': {
                freq = 4;
                break;
            }
            case 'B': {
                freq = 6;
                break;
            }
            case 'M': {
                freq = 12;
                break;
            }
            case 'h': {
                freq = 2;
                break;
            }
            case 't': {
                freq = 3;
                break;
            }
            case 'q': {
                freq = 4;
                break;
            }
            case 'b': {
                freq = 6;
                break;
            }
            case 'm': {
                freq = 12;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            int year = Integer.parseInt(s.substring(0, pos));
            int period = Integer.parseInt(s.substring(pos + 1));
            if (period <= 0 || period > freq) {
                return null;
            }
            return new TsPeriod(TsFrequency.valueOf(freq), year, period - 1);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String write(Parameter[] p) {
        if (p == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null) {
                builder.append(fmt.format(p[i].getValue()));
                if (p[i].getType() == ParameterType.Fixed) {
                    builder.append('f');
                }
            } else {
                builder.append(0);
            }
            if (i >= p.length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static Parameter[] readParameters(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<Parameter> p = new ArrayList<Parameter>();
        Tokenizer tokenizer = new Tokenizer(s);
        while (tokenizer.hasNextToken()) {
            Number val;
            boolean f;
            String token = tokenizer.nextToken();
            boolean bl = f = token.charAt(token.length() - 1) == 'f';
            if (f) {
                token = token.substring(0, token.length() - 1);
            }
            try {
                val = fmt.parse(token);
            }
            catch (ParseException ex) {
                return null;
            }
            p.add(new Parameter(val.doubleValue(), f ? ParameterType.Fixed : ParameterType.Estimated));
        }
        if (p.isEmpty()) {
            return null;
        }
        return Jdk6.Collections.toArray(p, Parameter.class);
    }

    static {
        fmt.setMaximumFractionDigits(9);
    }
}

