/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.benchmarking.simplets.TsCholette;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.GenericSaDiagnostics;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.SaException;
import ec.satoolkit.benchmarking.SaBenchmarkingResults;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.DefaultProcessingFactory;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.algorithm.SingleTsDataProcessing;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Map;

public class GenericSaProcessingFactory {
    public static final String FAMILY = "Seasonal adjustment";
    public static final String PREPROCESSING = "preprocessing";
    public static final String DECOMPOSITION = "decomposition";
    public static final String FINAL = "final";
    public static final String BENCHMARKING = "benchmarking";
    public static final String DIAGNOSTICS = "diagnostics";
    public static final String GENERAL = "general";
    public static final int MAX_REPEAT_COUNT = 80;
    public static final int MAX_MISSING_COUNT = 33;

    public static void testSeries(TsData y) {
        int ifreq;
        if (y == null) {
            throw new SaException("Missing series");
        }
        int nz = y.getObsCount();
        if (nz < Math.max(8, 3 * (ifreq = y.getFrequency().intValue()))) {
            throw new SaException("Not enough data");
        }
        int nrepeat = y.getRepeatCount();
        if (nrepeat > 80 * nz / 100) {
            throw new SaException("Too many identical values");
        }
        int nm = y.getMissingValuesCount();
        if (nm > 33 * nz / 100) {
            throw new SaException("Too many missing values");
        }
    }

    protected static <S extends IProcSpecification> IProcessingNode<TsData> createPreprocessingStep(final IPreprocessor preprocessor, final int ncasts, final String name, final String prefix) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getPrefix() {
                return prefix;
            }

            @Override
            public IProcessing.Status process(TsData ts, Map<String, IProcResults> results) {
                ModellingContext context = new ModellingContext();
                TsData s = GenericSaProcessingFactory.series(ts, results);
                if (s == null) {
                    s = ts;
                }
                if (s == null) {
                    return IProcessing.Status.Invalid;
                }
                PreprocessingModel model = preprocessor.process(s, context);
                if (model == null) {
                    return IProcessing.Status.Invalid;
                }
                model.setNcasts(ncasts);
                results.put(name, model);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static IProcessingNode<TsData> createInitialStep(TsPeriodSelector selector, boolean validate) {
        return !validate ? DefaultProcessingFactory.createInitialStep(selector) : DefaultProcessingFactory.createInitialStep(selector, new SingleTsDataProcessing.Validation(){

            @Override
            public boolean validate(TsData s) {
                GenericSaProcessingFactory.testSeries(s);
                return true;
            }
        });
    }

    protected static TsData series(TsData ts, Map<String, IProcResults> results) {
        TsData yc;
        IProcResults preprocessing = results.get(PREPROCESSING);
        if (preprocessing != null && preprocessing instanceof PreprocessingModel && (yc = preprocessing.getData("yc", TsData.class)) != null) {
            return yc;
        }
        IProcResults input = results.get("input");
        if (input == null || !(input instanceof SingleTsData)) {
            return ts;
        }
        SingleTsData sdata = (SingleTsData)input;
        return sdata.getSeries();
    }

    protected static PreprocessingModel model(Map<String, IProcResults> results) {
        IProcResults imodel = results.get(PREPROCESSING);
        if (imodel == null || !(imodel instanceof PreprocessingModel)) {
            return null;
        }
        return (PreprocessingModel)imodel;
    }

    protected static ISaResults decomposition(Map<String, IProcResults> results) {
        IProcResults decomp = results.get(DECOMPOSITION);
        if (decomp == null || !(decomp instanceof ISaResults)) {
            return null;
        }
        return (ISaResults)decomp;
    }

    protected static void addInitialStep(TsPeriodSelector sel, boolean validation, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createInitialStep(sel, validation));
    }

    protected static void addInitialStep(TsPeriodSelector sel, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createInitialStep(sel, true));
    }

    protected static void addPreprocessingStep(IPreprocessor preprocessor, int ncasts, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createPreprocessingStep(preprocessor, ncasts, PREPROCESSING, PREPROCESSING));
    }

    protected static <R extends ISaResults> IProcessingNode<TsData> createDecompositionStep(final IDefaultSeriesDecomposer<R> decomposer, final IPreprocessingFilter filter) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return GenericSaProcessingFactory.DECOMPOSITION;
            }

            @Override
            public String getPrefix() {
                return GenericSaProcessingFactory.DECOMPOSITION;
            }

            @Override
            public IProcessing.Status process(TsData ts, Map<String, IProcResults> results) {
                PreprocessingModel m = GenericSaProcessingFactory.model(results);
                TsData s = GenericSaProcessingFactory.series(ts, results);
                if (s == null) {
                    s = ts;
                }
                if (m == null) {
                    if (!decomposer.decompose(s)) {
                        return IProcessing.Status.Invalid;
                    }
                    Object decomp = decomposer.getDecomposition();
                    results.put(GenericSaProcessingFactory.DECOMPOSITION, (IProcResults)decomp);
                    return IProcessing.Status.Valid;
                }
                if (!filter.process(m)) {
                    return IProcessing.Status.Invalid;
                }
                if (!decomposer.decompose(m, filter)) {
                    return IProcessing.Status.Invalid;
                }
                Object decomp = decomposer.getDecomposition();
                results.put(GenericSaProcessingFactory.DECOMPOSITION, (IProcResults)decomp);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static <R extends ISaResults> void addDecompositionStep(IDefaultSeriesDecomposer decomposer, IPreprocessingFilter filter, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createDecompositionStep(decomposer, filter));
    }

    protected static IProcessingNode<TsData> createFinalStep(final IPreprocessingFilter filter) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return GenericSaProcessingFactory.FINAL;
            }

            @Override
            public String getPrefix() {
                return GenericSaProcessingFactory.FINAL;
            }

            @Override
            public IProcessing.Status process(TsData ts, Map<String, IProcResults> results) {
                TsData orig = GenericSaProcessingFactory.series(ts, results);
                if (orig == null) {
                    orig = ts;
                }
                ISaResults decomp = GenericSaProcessingFactory.decomposition(results);
                ISeriesDecomposition ldecomp = decomp.getSeriesDecomposition();
                PreprocessingModel pm = GenericSaProcessingFactory.model(results);
                if (pm == null) {
                    DefaultSeriesDecomposition finals = new DefaultSeriesDecomposition(decomp.getSeriesDecomposition().getMode());
                    TsDomain domain = orig.getDomain();
                    TsData fy = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
                    TsDomain fdomain = fy == null ? null : fy.getDomain();
                    finals.add(orig, ComponentType.Series);
                    TsData t = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Value);
                    if (t != null && !domain.equals(t.getDomain())) {
                        t = t.fittoDomain(domain);
                    }
                    finals.add(t, ComponentType.Trend);
                    TsData s = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
                    if (s != null && !domain.equals(s.getDomain())) {
                        s = s.fittoDomain(domain);
                    }
                    finals.add(s, ComponentType.Seasonal);
                    TsData i = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value);
                    if (i != null && !domain.equals(i.getDomain())) {
                        i = i.fittoDomain(domain);
                    }
                    finals.add(i, ComponentType.Irregular);
                    TsData sa = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
                    if (sa != null && !domain.equals(sa.getDomain())) {
                        sa = sa.fittoDomain(domain);
                    }
                    finals.add(sa, ComponentType.SeasonallyAdjusted);
                    if (fdomain != null) {
                        TsData fsa;
                        TsData fs;
                        finals.add(fy, ComponentType.Series, ComponentInformation.Forecast);
                        TsData ft = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
                        if (ft != null) {
                            if (!fdomain.equals(ft.getDomain())) {
                                ft = ft.fittoDomain(fdomain);
                            }
                            finals.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
                        }
                        if ((fs = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast)) != null) {
                            if (!fdomain.equals(fs.getDomain())) {
                                fs = fs.fittoDomain(fdomain);
                            }
                            finals.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
                        }
                        if ((fsa = ldecomp.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast)) != null) {
                            if (!fdomain.equals(fsa.getDomain())) {
                                fsa = fsa.fittoDomain(fdomain);
                            }
                            finals.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                        }
                    }
                    results.put(GenericSaProcessingFactory.FINAL, finals);
                    return IProcessing.Status.Valid;
                }
                if (!filter.isInitialized()) {
                    return IProcessing.Status.Invalid;
                }
                boolean mul = ldecomp.getMode() != DecompositionMode.Additive;
                TsDomain domain = orig.getDomain();
                TsData fdata = ldecomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
                TsDomain fdomain = fdata == null ? null : fdata.getDomain();
                TsDomain cdomain = fdomain == null ? domain : domain.union(fdomain);
                TsData detT = filter.getCorrection(cdomain, ComponentType.Trend, false);
                TsData detS = filter.getCorrection(cdomain, ComponentType.Seasonal, false);
                TsData detI = filter.getCorrection(cdomain, ComponentType.Irregular, false);
                TsData detY = filter.getCorrection(cdomain, ComponentType.Series, false);
                TsData detSA = filter.getCorrection(cdomain, ComponentType.SeasonallyAdjusted, false);
                DefaultSeriesDecomposition finals = new DefaultSeriesDecomposition(ldecomp.getMode());
                TsData y = GenericSaProcessingFactory.inv_op(mul, orig, detY);
                finals.add(orig, ComponentType.Series);
                TsData t = GenericSaProcessingFactory.op(mul, detT, ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Value));
                if (t != null && !domain.equals(t.getDomain())) {
                    t = t.fittoDomain(domain);
                }
                finals.add(t, ComponentType.Trend);
                TsData s = GenericSaProcessingFactory.op(mul, detS, ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
                if (s != null && !domain.equals(s.getDomain())) {
                    s = s.fittoDomain(domain);
                }
                finals.add(s, ComponentType.Seasonal);
                TsData i = GenericSaProcessingFactory.op(mul, detI, ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Value));
                if (i != null && !domain.equals(i.getDomain())) {
                    i = i.fittoDomain(domain);
                }
                finals.add(i, ComponentType.Irregular);
                if (ldecomp.getMode() == DecompositionMode.PseudoAdditive) {
                    finals.add(GenericSaProcessingFactory.op(mul, t, i), ComponentType.SeasonallyAdjusted);
                } else {
                    finals.add(GenericSaProcessingFactory.inv_op(mul, y, s), ComponentType.SeasonallyAdjusted);
                }
                if (fdomain != null) {
                    TsData fil;
                    TsData fi;
                    TsData fsl;
                    TsData fs;
                    TsData ftl = ldecomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
                    TsData ft = GenericSaProcessingFactory.op(mul, detT, ftl);
                    if (ft != null) {
                        if (!fdomain.equals(ft.getDomain())) {
                            ft = ft.fittoDomain(fdomain);
                        }
                        finals.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
                    }
                    if ((fs = GenericSaProcessingFactory.op(mul, detS, fsl = ldecomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast))) != null) {
                        if (!fdomain.equals(fs.getDomain())) {
                            fs = fs.fittoDomain(fdomain);
                        }
                        finals.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
                    }
                    if ((fi = GenericSaProcessingFactory.op(mul, detI, fil = ldecomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast))) != null) {
                        if (!fdomain.equals(fi.getDomain())) {
                            fi = fi.fittoDomain(fdomain);
                        }
                        finals.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
                    }
                    TsData fy = pm.forecast(fdomain.getLength(), false);
                    finals.add(fy, ComponentType.Series, ComponentInformation.Forecast);
                    TsData fsa = GenericSaProcessingFactory.op(mul, ft, fi);
                    fsa = GenericSaProcessingFactory.op(mul, fsa, detSA);
                    if (fsa != null) {
                        if (!fdomain.equals(fsa.getDomain())) {
                            fsa = fsa.fittoDomain(fdomain);
                        }
                        finals.add(fsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                    }
                }
                results.put(GenericSaProcessingFactory.FINAL, finals);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static void addFinalStep(IPreprocessingFilter filter, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createFinalStep(filter));
    }

    protected static void addGeneralStep(SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createGeneralStep());
    }

    protected static IProcessingNode<TsData> createGeneralStep() {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return GenericSaProcessingFactory.GENERAL;
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData s, Map<String, IProcResults> results) {
                ISeriesDecomposition finals;
                ISaResults decomp;
                PreprocessingModel pm = (PreprocessingModel)results.get(GenericSaProcessingFactory.PREPROCESSING);
                GenericSaResults sa = GenericSaResults.of(pm, decomp = (ISaResults)results.get(GenericSaProcessingFactory.DECOMPOSITION), finals = (ISeriesDecomposition)results.get(GenericSaProcessingFactory.FINAL));
                if (sa == null) {
                    return IProcessing.Status.Unprocessed;
                }
                results.put(GenericSaProcessingFactory.GENERAL, sa);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static void addDiagnosticsStep(SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createDiagnosticsStep());
    }

    protected static IProcessingNode<TsData> createDiagnosticsStep() {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return GenericSaProcessingFactory.DIAGNOSTICS;
            }

            @Override
            public String getPrefix() {
                return GenericSaProcessingFactory.DIAGNOSTICS;
            }

            @Override
            public IProcessing.Status process(TsData s, Map<String, IProcResults> results) {
                ISeriesDecomposition finals;
                ISaResults decomp;
                PreprocessingModel pm = (PreprocessingModel)results.get(GenericSaProcessingFactory.PREPROCESSING);
                GenericSaDiagnostics sa = GenericSaDiagnostics.of(pm, decomp = (ISaResults)results.get(GenericSaProcessingFactory.DECOMPOSITION), finals = (ISeriesDecomposition)results.get(GenericSaProcessingFactory.FINAL));
                if (sa == null) {
                    return IProcessing.Status.Unprocessed;
                }
                results.put(GenericSaProcessingFactory.DIAGNOSTICS, sa);
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static IProcessingNode<TsData> createBenchmarkingStep(final SaBenchmarkingSpec spec) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return GenericSaProcessingFactory.BENCHMARKING;
            }

            @Override
            public String getPrefix() {
                return GenericSaProcessingFactory.BENCHMARKING;
            }

            @Override
            public IProcessing.Status process(TsData s, Map<String, IProcResults> results) {
                TsData target;
                if (!spec.isEnabled()) {
                    return IProcessing.Status.Unprocessed;
                }
                TsData orig = CompositeResults.searchData(results, "yc", TsData.class);
                TsData cal = CompositeResults.searchData(results, "ycal", TsData.class);
                TsData sa = CompositeResults.searchData(results, "sa", TsData.class);
                if (spec.isUsingForecast()) {
                    TsData origf = CompositeResults.searchData(results, "y_f", TsData.class);
                    TsData calf = CompositeResults.searchData(results, "ycal_f", TsData.class);
                    TsData saf = CompositeResults.searchData(results, "sa_f", TsData.class);
                    orig = orig.update(origf);
                    cal = cal.update(calf);
                    sa = sa.update(saf);
                }
                TsData tsData = target = spec.getTarget() == SaBenchmarkingSpec.Target.Original ? orig : cal;
                if (target == null) {
                    target = GenericSaProcessingFactory.series(s, results);
                }
                TsCholette cholette = new TsCholette();
                cholette.setAggregationType(TsAggregationType.Sum);
                cholette.setLambda(spec.getLambda());
                cholette.setRho(spec.getRho());
                cholette.setBiasCorrection(spec.getBias());
                target = target.changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true);
                TsData benchSa = cholette.process(sa, target);
                if (benchSa == null) {
                    return IProcessing.Status.Invalid;
                }
                results.put(GenericSaProcessingFactory.BENCHMARKING, new SaBenchmarkingResults(sa, target, benchSa));
                return IProcessing.Status.Valid;
            }
        };
    }

    protected static void addBenchmarkingStep(SaBenchmarkingSpec spec, SequentialProcessing sproc) {
        sproc.add(GenericSaProcessingFactory.createBenchmarkingStep(spec));
    }

    protected static TsData op(boolean mul, TsData l, TsData r) {
        if (mul) {
            return TsData.multiply(l, r);
        }
        return TsData.add(l, r);
    }

    protected static TsData inv_op(boolean mul, TsData l, TsData r) {
        if (mul) {
            return TsData.divide(l, r);
        }
        return TsData.subtract(l, r);
    }
}

