/*
 * Decompiled with CFR 0.152.
 */
package ec.businesscycle.impl;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfRefData;
import ec.tstoolkit.ssf.ucarima.SsfUcarima;
import ec.tstoolkit.ucarima.UcarimaModel;

public class HodrickPrescott {
    private double lambda_ = 1600.0;
    private UcarimaModel ucm_;
    private double[] s_;
    private double[] n_;

    public boolean process(double[] x) {
        return this.process(new ReadDataBlock(x));
    }

    public boolean process(IReadDataBlock x) {
        if (this.ucm_ == null) {
            this.initModel();
        }
        SsfUcarima ssf = new SsfUcarima(this.ucm_);
        Smoother smoother = new Smoother();
        smoother.setSsf(ssf);
        SmoothingResults srslts = new SmoothingResults();
        if (!smoother.process(new SsfRefData(x, null), srslts)) {
            return false;
        }
        this.s_ = srslts.component(ssf.cmpPos(0));
        this.n_ = srslts.component(ssf.cmpPos(1));
        return true;
    }

    public double[] getSignal() {
        return this.s_;
    }

    public double[] getNoise() {
        return this.n_;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double value) {
        if (this.lambda_ != value) {
            this.lambda_ = value;
            this.ucm_ = null;
        }
    }

    private void initModel() {
        Polynomial D = UnitRoots.D(1);
        Polynomial D2 = D.times(D);
        ArimaModel i2 = new ArimaModel(null, new BackFilter(D2), null, 1.0);
        ArimaModel wn = new ArimaModel(this.lambda_);
        this.ucm_ = new UcarimaModel();
        this.ucm_.addComponent(i2);
        this.ucm_.addComponent(wn);
    }
}

