/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util;

import java.lang.reflect.Array;

public abstract class PrimitiveHashBase {
    protected static final double DEFAULT_FILL = 0.3;
    protected static final int MINIMUM_SIZE = 31;
    protected static final int KEY_MULTIPLIER = 517;
    protected double m_fillFraction;
    protected int m_entryCount;
    protected int m_entryLimit;
    protected int m_hitOffset;
    protected boolean[] m_flagTable;

    public PrimitiveHashBase(int n, double d, Class clazz) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("fill value out of range");
        }
        this.m_fillFraction = d;
        int n2 = Math.max((int)((double)n / this.m_fillFraction), 31);
        n2 += (n2 + 1) % 2;
        this.m_entryLimit = (int)((double)n2 * this.m_fillFraction);
        this.m_hitOffset = n2 / 2;
        this.m_flagTable = new boolean[n2];
        this.setKeyArray(Array.newInstance(clazz, n2));
    }

    public PrimitiveHashBase(PrimitiveHashBase primitiveHashBase) {
        this.m_fillFraction = primitiveHashBase.m_fillFraction;
        this.m_entryCount = primitiveHashBase.m_entryCount;
        this.m_entryLimit = primitiveHashBase.m_entryLimit;
        this.m_hitOffset = primitiveHashBase.m_hitOffset;
        int n = primitiveHashBase.m_flagTable.length;
        this.m_flagTable = new boolean[n];
        System.arraycopy(primitiveHashBase.m_flagTable, 0, this.m_flagTable, 0, this.m_flagTable.length);
        Class<?> clazz = primitiveHashBase.getKeyArray().getClass().getComponentType();
        Object object = Array.newInstance(clazz, n);
        System.arraycopy(primitiveHashBase.getKeyArray(), 0, object, 0, n);
        this.setKeyArray(object);
    }

    public final int size() {
        return this.m_entryCount;
    }

    protected abstract Object getKeyArray();

    protected abstract void setKeyArray(Object var1);

    protected abstract void reallocate(int var1);

    protected void growCapacity(int n) {
        int n2 = this.m_flagTable.length;
        int n3 = this.m_entryLimit;
        while (n3 < n) {
            n2 = n2 * 2 + 1;
            n3 = (int)((double)n2 * this.m_fillFraction);
        }
        this.m_entryLimit = n3;
        this.m_hitOffset = n2 / 2;
        this.reallocate(n2);
    }

    public final void ensureCapacity(int n) {
        if (n > this.m_entryLimit) {
            this.growCapacity(n);
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.m_flagTable.length) {
            this.m_flagTable[n] = false;
            ++n;
        }
        this.m_entryCount = 0;
    }

    protected final int stepSlot(int n) {
        return (n + this.m_hitOffset) % this.m_flagTable.length;
    }

    protected final int freeSlot(int n) {
        while (this.m_flagTable[n]) {
            n = this.stepSlot(n);
        }
        return n;
    }
}

