/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

public class TwoStates
extends DataType {
    public static final String DESCRIPTION = "binary";
    public static final int TYPE = 3;
    public static final TwoStates INSTANCE = new TwoStates();
    public static final int ZERO_STATE = 0;
    public static final int ONE_STATE = 1;
    public static final int UNKNOWN_STATE = 2;
    public static final int GAP_STATE = 3;
    public static final char[] TWOSTATE_CHARS = new char[]{'0', '1', '?', '-'};
    public static final String[] TWOSTATE_AMBIGUITIES = new String[]{"0", "1", "01", "01"};

    private TwoStates() {
        this.stateCount = 2;
        this.ambiguousStateCount = 4;
    }

    @Override
    public char[] getValidChars() {
        return TWOSTATE_CHARS;
    }

    @Override
    public int getState(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '?': {
                return 2;
            }
            case '-': {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public char getChar(int n) {
        return TWOSTATE_CHARS[n];
    }

    @Override
    public int[] getStates(int n) {
        String string = TWOSTATE_AMBIGUITIES[n];
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = this.getState(string.charAt(i));
        }
        return nArray;
    }

    @Override
    public boolean[] getStateSet(int n) {
        boolean[] blArray = new boolean[this.stateCount];
        if (n < 2) {
            blArray[1 - n] = false;
            blArray[n] = true;
        } else {
            blArray[0] = true;
            blArray[1] = true;
        }
        return blArray;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 3;
    }
}

