/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import java.util.Iterator;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.rules.core.Rule;
import moa.classifiers.rules.core.RuleActiveLearningNode;
import moa.classifiers.rules.core.RuleSet;
import moa.classifiers.rules.core.attributeclassobservers.FIMTDDNumericAttributeClassLimitObserver;
import moa.classifiers.rules.core.voting.ErrorWeightedVote;
import moa.classifiers.rules.core.voting.Vote;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.ClassOption;

public abstract class AbstractAMRules
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    protected RuleSet ruleSet = new RuleSet();
    protected Rule defaultRule;
    protected int ruleNumberID;
    protected double[] statistics;
    public static final double NORMAL_CONSTANT = Math.sqrt(Math.PI * 2);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "Hoeffding Bound Parameter. The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Hoeffding Bound Parameter. Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "Hoeffding Bound Parameter. The number of instances a leaf should observe between split attempts.", 200, 1, Integer.MAX_VALUE);
    public FlagOption DriftDetectionOption = new FlagOption("DoNotDetectChanges", 'H', "Drift Detection. Page-Hinkley.");
    public FloatOption pageHinckleyAlphaOption = new FloatOption("pageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption pageHinckleyThresholdOption = new IntOption("pageHinckleyThreshold", 'l', "The threshold value (Lambda) to be used in the Page Hinckley change detection tests.", 35, 0, Integer.MAX_VALUE);
    public FlagOption noAnomalyDetectionOption = new FlagOption("noAnomalyDetection", 'A', "Disable anomaly Detection.");
    public FloatOption multivariateAnomalyProbabilityThresholdOption = new FloatOption("multivariateAnomalyProbabilityThresholdd", 'm', "Multivariate anomaly threshold value.", 0.99, 0.0, 1.0);
    public FloatOption univariateAnomalyprobabilityThresholdOption = new FloatOption("univariateAnomalyprobabilityThreshold", 'u', "Univariate anomaly threshold value.", 0.1, 0.0, 1.0);
    public IntOption anomalyNumInstThresholdOption = new IntOption("anomalyThreshold", 'n', "The threshold value of anomalies to be used in the anomaly detection.", 30, 0, Integer.MAX_VALUE);
    public FlagOption unorderedRulesOption = new FlagOption("setUnorderedRulesOn", 'U', "unorderedRules.");
    public IntOption VerbosityOption = new IntOption("verbosity", 'v', "Output Verbosity Control Level. 1 (Less) to 5 (More)", 1, 1, 5);
    public ClassOption numericObserverOption = new ClassOption("numericObserver", 'z', "Numeric observer.", FIMTDDNumericAttributeClassLimitObserver.class, "FIMTDDNumericAttributeClassLimitObserver");
    protected double attributesPercentage = 100.0;
    private double numChangesDetected;
    private double numAnomaliesDetected;
    private double numInstances;

    public double getAttributesPercentage() {
        return this.attributesPercentage;
    }

    public void setAttributesPercentage(double attributesPercentage) {
        this.attributesPercentage = attributesPercentage;
    }

    public AbstractAMRules() {
    }

    public AbstractAMRules(double attributesPercentage) {
        this();
        this.attributesPercentage = attributesPercentage;
    }

    @Override
    public abstract boolean isRandomizable();

    protected abstract Rule newRule(int var1, RuleActiveLearningNode var2, double[] var3);

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        this.numInstances += instance.weight();
        this.debug("Train", 3);
        this.debug("N\u00ba instance " + this.numInstances + " - " + instance.toString(), 3);
        boolean rulesCoveringInstance = false;
        Iterator ruleIterator = this.ruleSet.iterator();
        while (ruleIterator.hasNext()) {
            Rule rule = (Rule)ruleIterator.next();
            if (!rule.isCovering(instance)) continue;
            rulesCoveringInstance = true;
            if (!this.isAnomaly(instance, rule)) {
                double error = rule.computeError(instance);
                boolean changeDetected = rule.getLearningNode().updateChangeDetection(error);
                if (changeDetected) {
                    this.debug("I) Drift Detected. Exa. : " + this.numInstances + " (" + rule.getInstancesSeen() + ") Remove Rule: " + rule.getRuleNumberID(), 1);
                    ruleIterator.remove();
                    this.numChangesDetected += instance.weight();
                } else {
                    rule.updateStatistics(instance);
                    if ((double)(rule.getInstancesSeen() % (long)this.gracePeriodOption.getValue()) == 0.0 && rule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                        rule.split();
                        this.debug("Rule Expanded:", 2);
                        this.debug(rule.printRule(), 2);
                    }
                }
            } else {
                this.debug("Anomaly Detected: " + this.numInstances + " Rule: " + rule.getRuleNumberID(), 1);
                this.numAnomaliesDetected += instance.weight();
            }
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (!rulesCoveringInstance) {
            this.defaultRule.updateStatistics(instance);
            if ((double)(this.defaultRule.getInstancesSeen() % (long)this.gracePeriodOption.getValue()) == 0.0) {
                this.debug("Nr. examples " + this.defaultRule.getInstancesSeen(), 4);
                if (this.defaultRule.tryToExpand(this.splitConfidenceOption.getValue(), this.tieThresholdOption.getValue())) {
                    Rule newDefaultRule = this.newRule(this.defaultRule.getRuleNumberID(), this.defaultRule.getLearningNode(), this.defaultRule.getLearningNode().getStatisticsOtherBranchSplit());
                    this.defaultRule.split();
                    this.defaultRule.setRuleNumberID(++this.ruleNumberID);
                    this.ruleSet.add(this.defaultRule);
                    this.debug("Default rule expanded! New Rule:", 2);
                    this.debug(this.defaultRule.printRule(), 2);
                    this.debug("New default rule:", 3);
                    this.debug(newDefaultRule.printRule(), 3);
                    this.defaultRule = newDefaultRule;
                }
            }
        }
    }

    private boolean isAnomaly(Instance instance, Rule rule) {
        boolean isAnomaly = false;
        if (!this.noAnomalyDetectionOption.isSet() && rule.getInstancesSeen() >= (long)this.anomalyNumInstThresholdOption.getValue()) {
            isAnomaly = rule.isAnomaly(instance, this.univariateAnomalyprobabilityThresholdOption.getValue(), this.multivariateAnomalyProbabilityThresholdOption.getValue(), this.anomalyNumInstThresholdOption.getValue());
        }
        return isAnomaly;
    }

    @Override
    public double[] getVotesForInstance(Instance instance) {
        return this.getVotes(instance).getVote();
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("anomaly detections", this.numAnomaliesDetected), new Measurement("change detections", this.numChangesDetected), new Measurement("rules (number)", this.ruleSet.size() + 1)};
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        indent = 0;
        if (!this.unorderedRulesOption.isSet()) {
            StringUtils.appendIndented(out, indent, "Method Ordered");
            StringUtils.appendNewline(out);
        } else {
            StringUtils.appendIndented(out, indent, "Method Unordered");
            StringUtils.appendNewline(out);
        }
        if (this.DriftDetectionOption.isSet()) {
            StringUtils.appendIndented(out, indent, "Change Detection OFF");
            StringUtils.appendNewline(out);
        } else {
            StringUtils.appendIndented(out, indent, "Change Detection ON");
            StringUtils.appendNewline(out);
        }
        if (this.noAnomalyDetectionOption.isSet()) {
            StringUtils.appendIndented(out, indent, "Anomaly Detection OFF");
            StringUtils.appendNewline(out);
        } else {
            StringUtils.appendIndented(out, indent, "Anomaly Detection ON");
            StringUtils.appendNewline(out);
        }
        StringUtils.appendIndented(out, indent, "Number of Rules: " + (this.ruleSet.size() + 1));
        StringUtils.appendNewline(out);
    }

    protected void debug(String string, int level) {
        if (this.VerbosityOption.getValue() >= level) {
            System.out.println(string);
        }
    }

    protected void VerboseToConsole(Instance inst) {
        if (this.VerbosityOption.getValue() >= 5) {
            System.out.println();
            System.out.println("I) Dataset: " + inst.dataset().getRelationName());
            if (!this.unorderedRulesOption.isSet()) {
                System.out.println("I) Method Ordered");
            } else {
                System.out.println("I) Method Unordered");
            }
        }
    }

    public void PrintRuleSet() {
        this.debug("Rule in RuleSet:", 2);
        for (Rule rule : this.ruleSet) {
            this.debug(rule.printRule(), 2);
        }
        this.debug("Default rule :", 2);
        this.debug(this.defaultRule.printRule(), 2);
    }

    public abstract RuleActiveLearningNode newRuleActiveLearningNode(Rule.Builder var1);

    public abstract RuleActiveLearningNode newRuleActiveLearningNode(double[] var1);

    public int getModelAttIndexToInstanceAttIndex(int index, Instance inst) {
        return AbstractAMRules.modelAttIndexToInstanceAttIndex(index, inst);
    }

    @Override
    public void resetLearningImpl() {
    }

    public static int modelAttIndexToInstanceAttIndex(int index, Instance inst) {
        return index <= inst.classIndex() ? index : index + 1;
    }

    public abstract ErrorWeightedVote newErrorWeightedVote();

    public Vote getVotes(Instance instance) {
        ErrorWeightedVote errorWeightedVote = this.newErrorWeightedVote();
        this.debug("Test", 3);
        int numberOfRulesCovering = 0;
        this.VerboseToConsole(instance);
        for (Rule rule : this.ruleSet) {
            if (!rule.isCovering(instance)) continue;
            ++numberOfRulesCovering;
            double[] vote = rule.getPrediction(instance);
            double error = rule.getCurrentError();
            this.debug("Rule No" + rule.getRuleNumberID() + " Vote: " + Arrays.toString(vote) + " Error: " + error + " Y: " + instance.classValue(), 3);
            errorWeightedVote.addVote(vote, error);
            if (this.unorderedRulesOption.isSet()) continue;
            break;
        }
        if (numberOfRulesCovering == 0) {
            double[] vote = this.defaultRule.getPrediction(instance);
            double error = this.defaultRule.getCurrentError();
            errorWeightedVote.addVote(vote, error);
            this.debug("Default Rule Vote " + Arrays.toString(vote) + " Error " + error + "  Y: " + instance.classValue(), 3);
        }
        double[] weightedVote = errorWeightedVote.computeWeightedVote();
        double weightedError = errorWeightedVote.getWeightedError();
        this.debug("Weighted Rule - Vote: " + Arrays.toString(weightedVote) + " Weighted Error: " + weightedError + " Y:" + instance.classValue(), 3);
        return new Vote(weightedVote, weightedError);
    }

    @Override
    public void setRandomSeed(int randomSeed) {
        this.classifierRandom.setSeed(randomSeed);
    }
}

