## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
options(rmarkdown.html_vignette.check_title = FALSE)
library("stokes")
library("emulator")
set.seed(1)

## -----------------------------------------------------------------------------
vector_cross_product

## -----------------------------------------------------------------------------
(M <- cbind(c(5,-2,1),c(1,2,0)))
vector_cross_product(M)

## -----------------------------------------------------------------------------
vector_cross_product(matrix(rnorm(30),6,5))

## -----------------------------------------------------------------------------
det(cbind(M,vector_cross_product(M)))>0

## -----------------------------------------------------------------------------
f <- function(n){
  M <- matrix(rnorm(n^2+n),n+1,n)
  det(cbind(M,vector_cross_product(M)))>0
}

all(sapply(sample(3:10,100,replace=TRUE),f))

## -----------------------------------------------------------------------------
set.seed(2)
M <- matrix(rnorm(30),6,5)
(ans1 <- vector_cross_product(M))

## -----------------------------------------------------------------------------
hodge(as.1form(M[,1]) ^ as.1form(M[,2]) ^ as.1form(M[,3]) ^ as.1form(M[,4]) ^ as.1form(M[,5]))

## -----------------------------------------------------------------------------
(ans2 <- hodge(Reduce(`^`,lapply(1:5,function(i){as.1form(M[,i])}))))

## -----------------------------------------------------------------------------
(diff <- as.1form(ans1) - ans2)
coeffs(diff)

## ----label=definevcp----------------------------------------------------------
u <- c(1,4,2)
v <- c(2,1,5)
(vcp <- contract(volume(3),cbind(u,v)))
dovs(vcp)

## -----------------------------------------------------------------------------
ucv  <- as.function(vcp)

## ----label=faila--------------------------------------------------------------
c(i=ucv(ex), j=ucv(ey), k=ucv(ez))

## -----------------------------------------------------------------------------
hodge(as.1form(c(1,4,2)) ^ as.1form(c(2,1,5)))

