/*
 * Decompiled with CFR 0.152.
 */
package vcf;

public final class R2Estimator {
    private static final double MIN_R2_DEN = 1.0E-8;
    private int nGenotypes = 0;
    private double sumCall = 0.0;
    private double sumSquareCall = 0.0;
    private double sumExpected = 0.0;
    private double sumExpectedSquare = 0.0;
    private double sumSquareExpected = 0.0;
    private double sumCallExpected = 0.0;

    public void clear() {
        this.nGenotypes = 0;
        this.sumCall = 0.0;
        this.sumSquareCall = 0.0;
        this.sumExpected = 0.0;
        this.sumExpectedSquare = 0.0;
        this.sumSquareExpected = 0.0;
        this.sumCallExpected = 0.0;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public void addSampleData(double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException(String.valueOf(dArray));
        }
        ++this.nGenotypes;
        int n = R2Estimator.checkDataAndReturnMaxIndex(dArray);
        double d = dArray[1] + 2.0 * dArray[2];
        double d2 = dArray[1] + 4.0 * dArray[2];
        this.sumCall += (double)n;
        this.sumSquareCall += (double)(n * n);
        this.sumExpected += d;
        this.sumExpectedSquare += d2;
        this.sumSquareExpected += d * d;
        this.sumCallExpected += (double)n * d;
    }

    private static int checkDataAndReturnMaxIndex(double[] dArray) {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException(String.valueOf(dArray[i]));
            }
            d += dArray[i];
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        if (Math.abs(d - 1.0) > 1.0E-5) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        return n;
    }

    public double allelicR2() {
        double d = 1.0 / (double)this.nGenotypes;
        double d2 = this.sumCallExpected - this.sumCall * this.sumExpected * d;
        double d3 = this.sumSquareCall - this.sumCall * this.sumCall * d;
        double d4 = this.sumExpectedSquare - this.sumExpected * this.sumExpected * d;
        double d5 = d3 * d4;
        return d5 < 1.0E-8 ? 0.0 : d2 * d2 / d5;
    }

    public double doseR2() {
        double d = 1.0 / (double)this.nGenotypes;
        double d2 = this.sumSquareExpected - this.sumExpected * this.sumExpected * d;
        double d3 = this.sumExpectedSquare - this.sumExpected * this.sumExpected * d;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d3 < 1.0E-8 ? 0.0 : d2 / d3;
    }
}

