/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array;

import dmLab.array.Array;
import dmLab.array.domain.SDomain;
import dmLab.array.meta.Attribute;
import dmLab.utils.ArrayUtils;
import java.util.Arrays;

public final class SArray
extends Array {
    private String[][] valuesArray;
    private String[] decisionValues;
    public SDomain[] domains = null;

    public SArray() {
    }

    /*
     * WARNING - void declaration
     */
    public SArray(int columns, int rows) {
        this();
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (int)var2_2);
    }

    @Override
    private SArray clone(boolean[] colMask, boolean[] rowMask) {
        SArray sArray = this;
        int srcColumns = sArray.attributes.length;
        sArray = this;
        int srcRows = sArray.valuesArray[0].length;
        if (colMask == null) {
            colMask = new boolean[srcColumns];
            Arrays.fill(colMask, true);
        }
        if (rowMask == null) {
            rowMask = new boolean[srcRows];
            Arrays.fill(rowMask, true);
        }
        int destColumns = ArrayUtils.count(colMask, true);
        int destRows = ArrayUtils.count(rowMask, true);
        SArray dstArray = null;
        if (srcColumns != colMask.length) {
            System.err.println("Incorrect length of colMask: " + colMask.length);
        } else if (srcRows != rowMask.length) {
            System.err.println("Incorrect length of eventIgnoreMask: " + rowMask.length);
        } else {
            int currentColumn = 0;
            dstArray = new SArray(destColumns, destRows);
            if (this.domains != null) {
                dstArray.domains = new SDomain[destColumns];
            }
            int i = 0;
            while (i < srcColumns) {
                if (colMask[i]) {
                    dstArray.attributes[currentColumn] = this.attributes[i].clone();
                    if (i == this.decAttrIdx) {
                        dstArray.decAttrIdx = currentColumn;
                        dstArray.decisionValues = (String[])this.decisionValues.clone();
                    }
                    if (this.domains != null && this.domains[i] != null) {
                        dstArray.domains[currentColumn] = this.domains[i].clone();
                    }
                    ++currentColumn;
                }
                ++i;
            }
            int currentRow = 0;
            int j = 0;
            while (j < srcRows) {
                currentColumn = 0;
                if (rowMask[j]) {
                    int i2 = 0;
                    while (i2 < srcColumns) {
                        if (colMask[i2]) {
                            dstArray.valuesArray[currentColumn][currentRow] = this.valuesArray[i2][j];
                            ++currentColumn;
                        }
                        ++i2;
                    }
                    ++currentRow;
                }
                ++j;
            }
            if (dstArray.decAttrIdx == -1) {
                SArray sArray2 = dstArray;
                sArray2.decAttrIdx = sArray2.attributes.length - 1;
                dstArray.setAllDecValues();
            }
        }
        return dstArray;
    }

    @Override
    public final void cbind(Array array) {
        SArray sArray = this;
        if (sArray.valuesArray[0].length != array.rowsNumber()) {
            System.err.println("Function cbind cannot be used. Arrays have different numbers of rows.");
            return;
        }
        this.bindAttributes(array.attributes);
        SArray srcArray = (SArray)array;
        if (this.domainsCreated()) {
            this.domains = new SDomain[this.attributes.length];
        }
        sArray = this;
        int rows = sArray.valuesArray[0].length;
        String[][] valuesArrayTMP = this.valuesArray;
        this.valuesArray = new String[this.attributes.length][rows];
        int j = 0;
        int i = 0;
        while (i < this.valuesArray.length) {
            this.valuesArray[i] = i < valuesArrayTMP.length ? valuesArrayTMP[i] : (String[])srcArray.valuesArray[j++].clone();
            ++i;
        }
        if (this.domains != null) {
            this.findDomains();
        }
    }

    @Override
    public final int colsNumber() {
        return this.attributes.length;
    }

    @Override
    public final int rowsNumber() {
        return this.valuesArray[0].length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getColumnStr(int attributeIndex) {
        void var1_1;
        return this.valuesArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void init(int columns, int rows) {
        void var1_1;
        void var2_2;
        this.initAttributes$255f295(columns);
        this.valuesArray = new String[columns][var2_2];
        this.domains = new SDomain[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readValueStr(int column, int row) {
        void var2_2;
        void var1_1;
        return this.valuesArray[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean writeValueStr(int column, int row, String value) {
        void var3_3;
        this.valuesArray[var1_1][var2_2] = var3_3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setDecValues(String[] decisionValues) {
        void var1_1;
        this.decisionValues = (String[])var1_1.clone();
        return true;
    }

    @Override
    public final String[] getDecValuesStr() {
        return this.decisionValues;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setAllDecValues() {
        void var1_1;
        SDomain domain = new SDomain(this.valuesArray[this.decAttrIdx]);
        this.setDecValues(var1_1.getDomain()[0]);
        return true;
    }

    @Override
    public final boolean findDomains() {
        SArray sArray = this;
        sArray.domains = new SDomain[sArray.attributes.length];
        int i = 0;
        while (i < this.domains.length) {
            this.domains[i] = new SDomain(this.valuesArray[i]);
            this.domains[i].sort();
            ++i;
        }
        return true;
    }

    @Override
    public final boolean domainsCreated() {
        return this.domains != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDomainStr(int column) {
        void var1_1;
        if (this.domains[column] == null) {
            this.domains[column] = new SDomain(this.valuesArray[column]);
        }
        return this.domains[var1_1].getDomain()[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void swapColumns(int srcColumn, int dstColumn) {
        void var3_3;
        String[] eventsArrayTmp = this.valuesArray[srcColumn];
        SDomain domainTmp = this.domains[srcColumn].clone();
        Attribute attributeTmp = this.attributes[srcColumn].clone();
        this.valuesArray[srcColumn] = this.valuesArray[dstColumn];
        this.domains[srcColumn] = this.domains[dstColumn];
        this.attributes[var1_1] = this.attributes[dstColumn];
        this.valuesArray[dstColumn] = var3_3;
        this.domains[dstColumn] = domainTmp;
        this.attributes[var2_2] = attributeTmp;
    }
}

