/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropAllEqual
extends Propagator<SetVar> {
    private final int n;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure elementForced;
    private final IntProcedure elementRemoved;

    public PropAllEqual(SetVar[] sets) {
        super((Variable[])sets, (Priority)PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> {
            for (int i = 0; i < this.n; ++i) {
                ((SetVar[])this.vars)[i].force(element, this);
            }
        };
        this.elementRemoved = element -> {
            for (int i = 0; i < this.n; ++i) {
                ((SetVar[])this.vars)[i].remove(element, this);
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            TIntArrayList toRemove = new TIntArrayList();
            ISetIterator iter = ((SetVar[])this.vars)[0].getUB().iterator();
            block0: while (iter.hasNext()) {
                int j = iter.nextInt();
                for (int i2 = 1; i2 < this.n; ++i2) {
                    if (((SetVar[])this.vars)[i2].getUB().contains(j)) continue;
                    toRemove.add(j);
                    continue block0;
                }
            }
            for (i = 0; i < this.n; ++i) {
                int j;
                iter = ((SetVar[])this.vars)[i].getUB().iterator();
                while (iter.hasNext()) {
                    j = iter.nextInt();
                    if ((i <= 0 || ((SetVar[])this.vars)[0].getUB().contains(j)) && !toRemove.contains(j)) continue;
                    ((SetVar[])this.vars)[i].remove(j, this);
                }
                iter = ((SetVar[])this.vars)[i].getLB().iterator();
                while (iter.hasNext()) {
                    j = iter.nextInt();
                    for (int i2 = 0; i2 < this.n; ++i2) {
                        ((SetVar[])this.vars)[i2].force(j, this);
                    }
                }
            }
            for (i = 0; i < this.n; ++i) {
                this.sdm[i].startMonitoring();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm[idxVarInProp].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[idxVarInProp].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
    }

    @Override
    public ESat isEntailed() {
        boolean allInstantiated = true;
        for (int i = 0; i < this.n; ++i) {
            if (!((SetVar[])this.vars)[i].isInstantiated()) {
                allInstantiated = false;
            }
            ISetIterator iter = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                for (int i2 = 0; i2 < this.n; ++i2) {
                    if (((SetVar[])this.vars)[i2].getUB().contains(j)) continue;
                    return ESat.FALSE;
                }
            }
        }
        if (allInstantiated) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

