/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45_Binarization;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.C45.C45;
import keel.Algorithms.Decision_Trees.C45_Binarization.OVO;
import keel.Algorithms.Decision_Trees.C45_Binarization.RuleBase;
import keel.Algorithms.Decision_Trees.C45_Binarization.myDataset;
import keel.Algorithms.Decision_Trees.C45_Binarization.parseParameters;
import org.core.Fichero;
import org.core.Files;

public class Multiclassifier {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String ficheroBR;
    String fichTrain;
    String[] claseMayoritaria;
    String cabecera;
    String sOvo;
    String binarization;
    String[] method;
    int nClasses;
    int n_classifiers;
    int neighbours;
    int preprocessing;
    int distance;
    boolean pruned;
    boolean[] valid;
    C45[] classifiers;
    myDataset[] train_sets;
    OVO ovo;
    float threshold;
    float confidence;
    int instancesPerLeaf;
    boolean nested;
    boolean dynamic;
    int[] empates;
    parseParameters parameters;
    String input_validation_name;
    String input_test_name;
    double[] aprioriClassDistribution;
    RuleBase[] treeRuleSet;
    private boolean somethingWrong = false;

    public Multiclassifier() {
    }

    public Multiclassifier(parseParameters parameters) {
        this.parameters = parameters;
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        this.fichTrain = parameters.getTrainingInputFile();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.ficheroBR = parameters.getOutputFile(0);
        this.pruned = true;
        this.confidence = Float.parseFloat(parameters.getParameter(1));
        this.instancesPerLeaf = Integer.parseInt(parameters.getParameter(2));
        this.nClasses = this.train.getnClasses();
        this.aprioriClassDistribution = new double[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            this.aprioriClassDistribution[i] = 1.0 * (double)this.train.numberInstances(i) / (double)this.train.size();
        }
        this.binarization = parameters.getParameter(3);
        this.sOvo = "WEIGHTED";
        this.sOvo = parameters.getParameter(4);
        if (this.sOvo.equals("BTS")) {
            this.threshold = Float.parseFloat(parameters.getParameter(5));
        } else if (this.sOvo.equals("DynOVO")) {
            this.sOvo = "WEIGHTED";
            this.dynamic = true;
        }
        this.nested = false;
        String prep = "NONE";
        this.cabecera = parameters.getTestInputFile();
        String[] aux = null;
        aux = this.cabecera.split("\\.");
        this.cabecera = aux[aux.length - 2];
        aux = this.cabecera.split("/");
        this.cabecera = aux[aux.length - 1];
    }

    public Multiclassifier(boolean nested, Multiclassifier padre) {
        this.train = padre.train;
        this.val = padre.val;
        this.test = padre.test;
        this.parameters = padre.parameters;
        this.fichTrain = padre.fichTrain;
        this.outputTr = this.parameters.getTrainingOutputFile();
        this.outputTst = this.parameters.getTestOutputFile();
        this.distance = padre.distance;
        this.parameters.getParameter(4);
        if (this.sOvo.equals("BTS")) {
            this.threshold = Float.parseFloat(this.parameters.getParameter(5));
        }
        this.nested = nested;
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set has missing values.");
            System.err.println("Aborting the program");
        } else {
            int i;
            this.nClasses = this.train.getnClasses();
            this.input_validation_name = this.parameters.getValidationInputFile();
            this.input_test_name = this.parameters.getTestInputFile();
            this.ovo = new OVO(this, this.sOvo, this.dynamic);
            this.n_classifiers = this.nClasses * (this.nClasses - 1) / 2;
            if (this.binarization.equals("OVA")) {
                this.n_classifiers = this.nClasses;
            }
            this.valid = new boolean[this.n_classifiers];
            this.claseMayoritaria = new String[this.n_classifiers];
            this.classifiers = new C45[this.n_classifiers];
            this.train_sets = new myDataset[this.n_classifiers];
            this.treeRuleSet = new RuleBase[this.n_classifiers];
            this.aprioriClassDistribution = new double[this.nClasses];
            for (i = 0; i < this.nClasses; ++i) {
                this.aprioriClassDistribution[i] = 1.0 * (double)this.train.numberInstances(i) / (double)this.train.size();
            }
            if (this.binarization.equals("OVO")) {
                int x = 0;
                for (i = 0; i < this.nClasses - 1; ++i) {
                    for (int j = i + 1; j < this.nClasses; ++j) {
                        if (i == j) continue;
                        this.train_sets[x] = new myDataset(this.train, i, j);
                        ++x;
                    }
                }
            } else {
                for (i = 0; i < this.nClasses; ++i) {
                    this.train_sets[i] = new myDataset(this.train, i);
                }
            }
            int x = 0;
            int y = 1;
            boolean is_ovo = this.binarization.equals("OVO");
            for (int i2 = 0; i2 < this.n_classifiers; ++i2) {
                String text = new String("");
                text = is_ovo ? this.train.className(x) + " vs. " + this.train.className(y) : this.train.className(i2) + " vs. REST";
                System.out.println("Classifier -> " + i2 + "; " + text);
                if (!this.train_sets[i2].empty()) {
                    Files.writeFile(this.cabecera + ".tra", this.train_sets[i2].printDataSet(!is_ovo));
                    this.valid[i2] = true;
                    C45 tree = new C45(this.cabecera + ".tra", this.pruned, this.confidence, this.instancesPerLeaf, !is_ovo);
                    try {
                        tree.generateTree();
                    }
                    catch (Exception e) {
                        System.err.println("Error!!");
                        System.err.println(e.getMessage());
                        System.exit(-1);
                    }
                    String treeString = tree.printStringOVO();
                    this.obtainRules(treeString, i2);
                    this.treeRuleSet[i2].coverExamples();
                } else {
                    this.valid[i2] = false;
                }
                if (++y % this.nClasses != 0) continue;
                y = ++x + 1;
            }
            if (this.binarization.equals("OVO")) {
                this.ovo.classifierTrainFinished();
            }
            this.ovo.clearTables(false);
            double accTr = this.doOutput(this.val, this.outputTr);
            this.ovo.clearTables(true);
            double accTst = this.doOutput(this.test, this.outputTst);
            System.out.println("Accuracy in training: " + accTr);
            System.out.println("Accuracy in test: " + accTst);
        }
    }

    public void execute_nesting(int[] empate) {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set has missing values.");
            System.err.println("Aborting the program");
        } else {
            int i;
            this.nClasses = this.train.getnClasses();
            this.ovo = new OVO(this, this.sOvo, false);
            this.n_classifiers = this.nClasses * (this.nClasses - 1) / 2;
            this.valid = new boolean[this.n_classifiers];
            this.treeRuleSet = new RuleBase[this.n_classifiers];
            this.claseMayoritaria = new String[this.n_classifiers];
            this.train_sets = new myDataset[this.n_classifiers];
            this.aprioriClassDistribution = new double[this.nClasses];
            for (i = 0; i < this.nClasses; ++i) {
                this.aprioriClassDistribution[i] = 1.0 * (double)this.train.numberInstances(i) / (double)this.train.size();
            }
            int x = 0;
            for (i = 0; i < this.nClasses - 1; ++i) {
                for (int j = i + 1; j < this.nClasses; ++j) {
                    if (i == j) continue;
                    this.train_sets[x] = new myDataset(this.train, i, j, empate);
                    ++x;
                }
            }
            int x2 = 0;
            int y = 1;
            for (int i2 = 0; i2 < this.n_classifiers; ++i2) {
                if (!this.train_sets[i2].empty()) {
                    Fichero.escribeFichero("training.txt", this.train_sets[i2].printDataSet(false));
                    this.valid[i2] = true;
                    System.out.println("Training classifier[" + i2 + "] for classes " + x2 + " and " + y);
                    C45 tree = new C45("training.txt", this.pruned, this.confidence, this.instancesPerLeaf, false);
                    try {
                        tree.generateTree();
                    }
                    catch (Exception e) {
                        System.err.println("Error!!");
                        System.err.println(e.getMessage());
                        System.exit(-1);
                    }
                    String treeString = tree.printStringOVO();
                    this.obtainRules(treeString, i2);
                    this.treeRuleSet[i2].coverExamples();
                    this.claseMayoritaria[i2] = this.train_sets[i2].mostFrequentClass();
                } else {
                    this.valid[i2] = false;
                }
                if (++y % this.nClasses != 0) continue;
                y = ++x2 + 1;
            }
            this.ovo.classifierTrainFinished();
            this.empates = empate;
            this.doOutput(this.val, this.outputTr);
        }
    }

    private void obtainRules(String treeString, int classifier) {
        String rules = new String("");
        StringTokenizer lines = new StringTokenizer(treeString, "\n");
        String line = lines.nextToken();
        line = lines.nextToken();
        Vector<String> variables = new Vector<String>();
        Vector<String> values = new Vector<String>();
        Vector<String> operators = new Vector<String>();
        int contador = 0;
        while (lines.hasMoreTokens()) {
            int i;
            line = lines.nextToken();
            StringTokenizer field = new StringTokenizer(line, " \t");
            String cosa = field.nextToken();
            if (cosa.compareToIgnoreCase("if") == 0) {
                field.nextToken();
                variables.add(field.nextToken());
                operators.add(field.nextToken());
                values.add(field.nextToken());
                continue;
            }
            if (cosa.compareToIgnoreCase("elseif") == 0) {
                int dejar = Integer.parseInt(field.nextToken());
                for (int i2 = variables.size() - 1; i2 >= dejar; --i2) {
                    variables.remove(variables.size() - 1);
                    operators.remove(operators.size() - 1);
                    values.remove(values.size() - 1);
                }
                field.nextToken();
                variables.add(field.nextToken());
                operators.add(field.nextToken());
                values.add(field.nextToken());
                continue;
            }
            field.nextToken();
            rules = rules + "\nRULE-" + ++contador + ": IF ";
            for (i = 0; i < variables.size() - 1; ++i) {
                rules = rules + (String)variables.get(i) + " " + (String)operators.get(i) + " " + (String)values.get(i) + " AND ";
            }
            rules = rules + (String)variables.get(i) + " " + (String)operators.get(i) + " " + (String)values.get(i);
            rules = rules + " THEN class = " + field.nextToken();
            variables.remove(variables.size() - 1);
            operators.remove(operators.size() - 1);
            values.remove(values.size() - 1);
        }
        this.treeRuleSet[classifier] = new RuleBase(this.train_sets[classifier], rules);
    }

    private double doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        int[] hits = new int[this.nClasses];
        for (int i = 0; i < dataset.getnData(); ++i) {
            int clase = dataset.getOutputAsInteger(i);
            String actualClass = dataset.getOutputAsString(i);
            String prediccion = this.classificationOutput(dataset.getExample(i));
            output = output + actualClass + " " + prediccion + "\n";
            if (!actualClass.equalsIgnoreCase(prediccion)) continue;
            int n = clase;
            hits[n] = hits[n] + 1;
        }
        Files.writeFile(filename, output);
        double accAvg = 0.0;
        int numClases = 0;
        for (int i = 0; i < this.nClasses; ++i) {
            try {
                int datos = dataset.numberInstances(i);
                if (datos <= 0) continue;
                ++numClases;
                double acc = 1.0 * (double)hits[i] / (double)datos;
                System.out.print("Cl[" + i + "]: " + hits[i] + "/" + datos + "(" + acc + ")\t");
                accAvg += acc;
                continue;
            }
            catch (Exception e) {
                System.err.println("NO examples for class " + i);
            }
        }
        System.out.println("");
        return 100.0 * (accAvg /= (double)numClases);
    }

    private String classificationOutput(double[] example) {
        if (this.binarization.equals("OVO")) {
            return this.ovo.computeClassScores(example);
        }
        return this.ovo.computeClassScoresOVA(example);
    }

    protected int obtainClass(int x, int y, double[] example) {
        int i = 0;
        for (int i2 = 0; i2 < x; ++i2) {
            i += this.nClasses - (i2 + 1);
        }
        if (this.valid[i += y - x - 1]) {
            String clase = "?";
            for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
            }
            return this.train_sets[i].numericClass(clase);
        }
        return -1;
    }

    protected double[] obtainConfidence(int x, int y, double[] example) {
        int i = 0;
        double[] salida = new double[2];
        for (int i2 = 0; i2 < x; ++i2) {
            i += this.nClasses - (i2 + 1);
        }
        double confidence = 0.0;
        if (this.valid[i += y - x - 1]) {
            String clase = "?";
            for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
                confidence = this.treeRuleSet[i].ruleBase.get(j).confidence();
            }
            int clase_num = this.train_sets[i].numericClass(clase);
            salida[0] = clase_num == x ? confidence : 1.0 - confidence;
            salida[1] = 1.0 - salida[0];
            return salida;
        }
        salida[0] = 0.0;
        salida[1] = 0.0;
        return salida;
    }

    protected double[][] ovo_table(double[] example) {
        double[][] tabla = new double[this.nClasses][this.nClasses];
        int x = 0;
        int y = 1;
        for (int i = 0; i < this.n_classifiers; ++i) {
            if (this.valid[i]) {
                String clase = "?";
                double confidence = 0.0;
                for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                    if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                    clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
                    confidence = this.treeRuleSet[i].ruleBase.get(j).confidence();
                }
                int clase_num = this.train_sets[i].numericClass(clase);
                if (x == clase_num) {
                    tabla[x][y] = confidence;
                    tabla[y][x] = 1.0 - confidence;
                } else {
                    tabla[y][x] = confidence;
                    tabla[x][y] = 1.0 - confidence;
                }
            } else {
                tabla[y][x] = 0.0;
                tabla[x][y] = 0.0;
            }
            if (++y % this.nClasses != 0) continue;
            y = ++x + 1;
        }
        return tabla;
    }

    protected double[] ova_table(double[] example) {
        double[] grado_asoc = new double[this.n_classifiers];
        for (int i = 0; i < this.n_classifiers; ++i) {
            if (!this.valid[i]) continue;
            String clase = "?";
            double confidence = 0.0;
            for (int j = 0; j < this.treeRuleSet[i].size() && clase.equals("?"); ++j) {
                if (!this.treeRuleSet[i].ruleBase.get(j).covers(example)) continue;
                clase = this.treeRuleSet[i].ruleBase.get((int)j).clase;
                confidence = this.treeRuleSet[i].ruleBase.get(j).confidence();
            }
            int clase_num = this.train_sets[i].numericClass(clase);
            grado_asoc[i] = 0.0;
            if (clase_num != 0) continue;
            grado_asoc[i] = confidence;
        }
        return grado_asoc;
    }
}

