/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IArimaDecomposer;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.ucarima.ModelDecomposer;
import ec.tstoolkit.ucarima.SeasonalSelector;
import ec.tstoolkit.ucarima.TrendCycleSelector;
import ec.tstoolkit.ucarima.UcarimaModel;

public class DefaultModelDecomposer
implements IArimaDecomposer {
    private double epsphi = 2.0;
    private double rmod = 0.5;
    private double smod = 0.8;
    private double smod1 = 0.8;
    private boolean noisyModel = true;

    public DefaultModelDecomposer(boolean noisy) {
        this.noisyModel = noisy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UcarimaModel decompose(SeatsModel model, InformationSet info, SeatsContext context) {
        UcarimaModel ucarimaModel;
        UcarimaModel ucm;
        block15: {
            int sc;
            int rc;
            SarimaSpecification spec;
            block14: {
                ArimaModel arima;
                Polynomial.Division division;
                ucm = null;
                SarimaModel sarima = model.getSarima();
                spec = sarima.getSpecification();
                this.addStartInfo(context);
                int rar = spec.getD() + spec.getBD();
                int sar = spec.getBD();
                int rma = 0;
                int sma = 0;
                Polynomial pr = sarima.getRegularMA();
                Polynomial ps = sarima.getSeasonalMA();
                while (ps.getDegree() > 0 && (division = Polynomial.divide(ps, UnitRoots.D1)).isExact()) {
                    ++sma;
                    ++rma;
                    ps = division.getQuotient();
                }
                while (pr.getDegree() > 0 && (division = Polynomial.divide(pr, UnitRoots.D1)).isExact()) {
                    ++rma;
                    pr = division.getQuotient();
                }
                rc = Math.min(rma, rar);
                sc = Math.min(sma, sar);
                if (rc > 0 || sc > 0) {
                    int i;
                    Polynomial rur = Polynomial.ONE;
                    for (i = 0; i < rc; ++i) {
                        rur = rur.times(UnitRoots.D1);
                    }
                    for (i = 0; i < sc; ++i) {
                        rur = rur.times(UnitRoots.S(spec.getFrequency(), 1));
                    }
                    BackFilter ur = new BackFilter(rur);
                    arima = new ArimaModel(sarima.getStationaryAR(), sarima.getNonStationaryAR().divide(ur), sarima.getMA().divide(ur), sarima.getInnovationVariance());
                } else {
                    arima = ArimaModel.create(sarima);
                }
                int frequency = sarima.getSpecification().getFrequency();
                TrendCycleSelector tsel = new TrendCycleSelector(this.rmod);
                tsel.setDefaultLowFreqThreshold(frequency);
                SeasonalSelector ssel = new SeasonalSelector(frequency, this.epsphi);
                if (spec.getBD() > 0 || spec.getBP() > 0) {
                    ssel.setK(this.smod);
                } else {
                    ssel.setK(this.smod1);
                }
                ModelDecomposer decomposer = new ModelDecomposer();
                decomposer.add(tsel);
                decomposer.add(ssel);
                ucm = decomposer.decompose(ArimaModel.create(arima));
                double var = ucm.setVarianceMax(-1, this.noisyModel);
                if (!(var >= 0.0)) break block14;
                UcarimaModel ucarimaModel2 = this.complete(spec.getFrequency(), sarima, ucm, rc, sc);
                this.addEndInfo(context, ucm != null);
                return ucarimaModel2;
            }
            if (!this.noisyModel) break block15;
            ucm.normalize();
            model.setNoisyModel(ucm.getModel());
            UcarimaModel ucarimaModel3 = this.complete(spec.getFrequency(), null, ucm, rc, sc);
            this.addEndInfo(context, ucm != null);
            return ucarimaModel3;
        }
        try {
            ucm = null;
            ucarimaModel = null;
            this.addEndInfo(context, ucm != null);
        }
        catch (BaseException err) {
            try {
                UcarimaModel ucarimaModel4 = null;
                this.addEndInfo(context, ucm != null);
                return ucarimaModel4;
            }
            catch (Throwable throwable) {
                this.addEndInfo(context, ucm != null);
                throw throwable;
            }
        }
        return ucarimaModel;
    }

    public double getEpsphi() {
        return this.epsphi;
    }

    public double getRmod() {
        return this.rmod;
    }

    public double getSmod() {
        return this.smod;
    }

    public double getSmod1() {
        return this.smod1;
    }

    public void setEpsphi(double epsphi) {
        this.epsphi = epsphi;
    }

    public void setRmod(double rmod) {
        this.rmod = rmod;
    }

    public void setSmod(double smod) {
        this.smod = smod;
    }

    public void setSmod1(double smod1) {
        this.smod1 = smod1;
    }

    private UcarimaModel complete(int frequency, IArimaModel arima, UcarimaModel ucm, int rc, int sc) {
        if (rc == 0 && sc == 0) {
            return ucm;
        }
        ArimaModel[] cmps = new ArimaModel[ucm.getComponentsCount()];
        Polynomial rur = Polynomial.ONE;
        for (int i = 0; i < rc; ++i) {
            rur = rur.times(UnitRoots.D1);
        }
        BackFilter pr = new BackFilter(rur);
        Polynomial sur = Polynomial.ONE;
        for (int i = 0; i < sc; ++i) {
            sur = sur.times(UnitRoots.S(frequency, 1));
        }
        BackFilter ps = new BackFilter(sur);
        ArimaModel t = ucm.getComponent(0);
        cmps[0] = rc > 0 ? new ArimaModel(t.getStationaryAR(), t.getNonStationaryAR().times(pr), t.getMA().times(pr), t.getInnovationVariance()) : t;
        ArimaModel s = ucm.getComponent(1);
        cmps[1] = sc > 0 ? new ArimaModel(s.getStationaryAR(), s.getNonStationaryAR().times(ps), s.getMA().times(ps), s.getInnovationVariance()) : s;
        for (int i = 2; i < ucm.getComponentsCount(); ++i) {
            cmps[i] = ucm.getComponent(i);
        }
        return new UcarimaModel(arima, cmps);
    }

    private void addEndInfo(SeatsContext context, boolean ok) {
    }

    private void addStartInfo(SeatsContext context) {
    }
}

