/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FComplexMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected FComplexMatrix1D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        int n = (int)this.size();
        if (n == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = fComplexFComplexFunction.apply(this.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFunction.apply(FComplexMatrix1D.this.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(FComplexMatrix1D.this.getQuick(i)));
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            for (int i = 1; i < n; ++i) {
                fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(this.getQuick(i)));
            }
        }
        return fArray2;
    }

    public float[] aggregate(final FComplexMatrix1D fComplexMatrix1D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        this.checkSize(fComplexMatrix1D);
        int n = (int)this.size();
        if (n == 0) {
            float[] fArray = new float[]{Float.NaN, Float.NaN};
            return fArray;
        }
        float[] fArray = fComplexFComplexFComplexFunction2.apply(this.getQuick(0), fComplexMatrix1D.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(FComplexMatrix1D.this.getQuick(n4), fComplexMatrix1D.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(FComplexMatrix1D.this.getQuick(i), fComplexMatrix1D.getQuick(i)));
                        }
                        return fArray;
                    }
                });
            }
            fArray = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            for (int i = 1; i < n; ++i) {
                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(this.getQuick(i), fComplexMatrix1D.getQuick(i)));
            }
        }
        return fArray;
    }

    public FComplexMatrix1D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = (int)this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FComplexMatrix1D.this.setQuick(i, fComplexFComplexFunction.apply(FComplexMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, fComplexFComplexFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] elem;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.elem = FComplexMatrix1D.this.getQuick(i);
                            if (!fComplexProcedure.apply(this.elem)) continue;
                            FComplexMatrix1D.this.setQuick(i, fComplexFComplexFunction.apply(this.elem));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float[] fArray = this.getQuick(i);
                if (!fComplexProcedure.apply(fArray)) continue;
                this.setQuick(i, fComplexFComplexFunction.apply(fArray));
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] elem;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.elem = FComplexMatrix1D.this.getQuick(i);
                            if (!fComplexProcedure.apply(this.elem)) continue;
                            FComplexMatrix1D.this.setQuick(i, fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float[] fArray2 = this.getQuick(i);
                if (!fComplexProcedure.apply(fArray2)) continue;
                this.setQuick(i, fArray);
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexRealFunction fComplexRealFunction) {
        int n = (int)this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FComplexMatrix1D.this.setQuick(i, fComplexRealFunction.apply(FComplexMatrix1D.this.getQuick(i)), 0.0f);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, fComplexRealFunction.apply(this.getQuick(i)), 0.0f);
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D == this) {
            return this;
        }
        this.checkSize(fComplexMatrix1D);
        final FComplexMatrix1D fComplexMatrix1D2 = this.haveSharedCells(fComplexMatrix1D) ? fComplexMatrix1D.copy() : fComplexMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            FComplexMatrix1D.this.setQuick(i, fComplexMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, fComplexMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexMatrix1D fComplexMatrix1D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        int n = (int)this.size();
        this.checkSize(fComplexMatrix1D);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FComplexMatrix1D.this.setQuick(i, fComplexFComplexFComplexFunction.apply(FComplexMatrix1D.this.getQuick(i), fComplexMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, fComplexFComplexFComplexFunction.apply(this.getQuick(i), fComplexMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final float f, final float f2) {
        int n = (int)this.size();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FComplexMatrix1D.this.setQuick(i, f, f2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, f, f2);
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final float[] fArray) {
        int n = (int)this.size();
        if (fArray.length != 2 * n) {
            throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + this.size());
        }
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            FComplexMatrix1D.this.setQuick(i, fArray[2 * i], fArray[2 * i + 1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(i, fArray[2 * i], fArray[2 * i + 1]);
            }
        }
        return this;
    }

    public FComplexMatrix1D assignImaginary(final FloatMatrix1D floatMatrix1D) {
        this.checkSize(floatMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f = FComplexMatrix1D.this.getQuick(i)[0];
                            float f2 = floatMatrix1D.getQuick(i);
                            FComplexMatrix1D.this.setQuick(i, f, f2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float f = this.getQuick(i)[0];
                float f2 = floatMatrix1D.getQuick(i);
                this.setQuick(i, f, f2);
            }
        }
        return this;
    }

    public FComplexMatrix1D assignReal(final FloatMatrix1D floatMatrix1D) {
        this.checkSize(floatMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float f = floatMatrix1D.getQuick(i);
                            float f2 = FComplexMatrix1D.this.getQuick(i)[1];
                            FComplexMatrix1D.this.setQuick(i, f, f2);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float f = floatMatrix1D.getQuick(i);
                float f2 = this.getQuick(i)[1];
                this.setQuick(i, f, f2);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = (int)this.size();
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = n / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? n : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        float[] fArray = new float[2];
                        for (int i = n6; i < n7; ++i) {
                            fArray = FComplexMatrix1D.this.getQuick(i);
                            if ((double)fArray[0] == 0.0 && (double)fArray[1] == 0.0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n2 = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n2 += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < n; ++i) {
                fArray = this.getQuick(i);
                if ((double)fArray[0] == 0.0 && (double)fArray[1] == 0.0) continue;
                ++n2;
            }
        }
        return n2;
    }

    public FComplexMatrix1D copy() {
        FComplexMatrix1D fComplexMatrix1D = this.like();
        fComplexMatrix1D.assign(this);
        return fComplexMatrix1D;
    }

    public boolean equals(float[] fArray) {
        return FComplexProperty.DEFAULT.equals(this, fArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FComplexMatrix1D)) {
            return false;
        }
        return FComplexProperty.DEFAULT.equals(this, (FComplexMatrix1D)object);
    }

    public float[] get(int n) {
        int n2 = (int)this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    public abstract Object elements();

    public abstract FloatMatrix1D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        arrayList.clear();
        int n = (int)this.size();
        for (int i = 0; i < n; ++i) {
            float[] fArray = this.getQuick(i);
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
            intArrayList.add(i);
            arrayList.add(fArray);
        }
    }

    public abstract float[] getQuick(int var1);

    public abstract FloatMatrix1D getRealPart();

    public FComplexMatrix1D like() {
        int n = (int)this.size();
        return this.like(n);
    }

    public abstract FComplexMatrix1D like(int var1);

    public abstract FComplexMatrix2D like2D(int var1, int var2);

    public abstract FComplexMatrix2D reshape(int var1, int var2);

    public abstract FComplexMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, float f, float f2) {
        int n2 = (int)this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        this.setQuick(n, f, f2);
    }

    public void set(int n, float[] fArray) {
        int n2 = (int)this.size();
        if (n < 0 || n >= n2) {
            this.checkIndex(n);
        }
        this.setQuick(n, fArray);
    }

    public abstract void setQuick(int var1, float var2, float var3);

    public abstract void setQuick(int var1, float[] var2);

    public void swap(final FComplexMatrix1D fComplexMatrix1D) {
        int n = (int)this.size();
        this.checkSize(fComplexMatrix1D);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray = FComplexMatrix1D.this.getQuick(i);
                            FComplexMatrix1D.this.setQuick(i, fComplexMatrix1D.getQuick(i));
                            fComplexMatrix1D.setQuick(i, fArray);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                float[] fArray = this.getQuick(i);
                this.setQuick(i, fComplexMatrix1D.getQuick(i));
                fComplexMatrix1D.setQuick(i, fArray);
            }
        }
    }

    public float[] toArray() {
        int n = (int)this.size();
        float[] fArray = new float[2 * n];
        this.toArray(fArray);
        return fArray;
    }

    public void toArray(final float[] fArray) {
        int n = (int)this.size();
        if (fArray.length < 2 * n) {
            throw new IllegalArgumentException("values too small");
        }
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray2 = FComplexMatrix1D.this.getQuick(i);
                            fArray[2 * i] = fArray2[0];
                            fArray[2 * i + 1] = fArray2[1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                float[] fArray2 = this.getQuick(i);
                fArray[2 * i] = fArray2[0];
                fArray[2 * i + 1] = fArray2[1];
            }
        }
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix1D: %d elements\n\n", this.size()));
        float[] fArray = new float[2];
        int n = 0;
        while ((long)n < this.size()) {
            fArray = this.getQuick(n);
            if (fArray[1] == 0.0f) {
                stringBuffer.append(String.format(string + "\n", Float.valueOf(fArray[0])));
            } else if (fArray[0] == 0.0f) {
                stringBuffer.append(String.format(string + "i\n", Float.valueOf(fArray[1])));
            } else if (fArray[1] < 0.0f) {
                stringBuffer.append(String.format(string + " - " + string + "i\n", Float.valueOf(fArray[0]), Float.valueOf(-fArray[1])));
            } else {
                stringBuffer.append(String.format(string + " + " + string + "i\n", Float.valueOf(fArray[0]), Float.valueOf(fArray[1])));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public FComplexMatrix1D viewFlip() {
        return (FComplexMatrix1D)this.view().vFlip();
    }

    public FComplexMatrix1D viewPart(int n, int n2) {
        return (FComplexMatrix1D)this.view().vPart(n, n2);
    }

    public FComplexMatrix1D viewSelection(FComplexProcedure fComplexProcedure) {
        int n = (int)this.size();
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < n; ++i) {
            if (!fComplexProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public FComplexMatrix1D viewSelection(int[] nArray) {
        int n = (int)this.size();
        if (nArray == null) {
            nArray = new int[n];
            int n2 = n - 1;
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public FComplexMatrix1D viewStrides(int n) {
        return (FComplexMatrix1D)this.view().vStrides(n);
    }

    public float[] zDotProduct(FComplexMatrix1D fComplexMatrix1D) {
        int n = (int)this.size();
        return this.zDotProduct(fComplexMatrix1D, 0, n);
    }

    public float[] zDotProduct(final FComplexMatrix1D fComplexMatrix1D, final int n, int n2) {
        int n3 = (int)this.size();
        if (n < 0 || n2 <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        int n4 = n + n2;
        if (n3 < n4) {
            n4 = n3;
        }
        if (fComplexMatrix1D.size < n4) {
            n4 = fComplexMatrix1D.size;
        }
        n2 = n4 - n;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        float[] fArray = new float[2];
        if (n5 > 1 && n3 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n6;
            n5 = Math.min(n5, n2);
            Future[] futureArray = new Future[n5];
            float[][] fArray2 = new float[n5][2];
            int n7 = n2 / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? n2 : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n8; i < n9; ++i) {
                            int n2 = i + n;
                            float[] fArray2 = fComplexMatrix1D.getQuick(n2);
                            fArray2[1] = -fArray2[1];
                            fArray = FComplex.plus(fArray, FComplex.mult(fArray2, FComplexMatrix1D.this.getQuick(n2)));
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    fArray2[n6] = (float[])futureArray[n6].get();
                }
                fArray = fArray2[0];
                for (n6 = 1; n6 < n5; ++n6) {
                    fArray = FComplex.plus(fArray, fArray2[n6]);
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n10 = i + n;
                float[] fArray3 = fComplexMatrix1D.getQuick(n10);
                fArray3[1] = -fArray3[1];
                fArray = FComplex.plus(fArray, FComplex.mult(fArray3, this.getQuick(n10)));
            }
        }
        return fArray;
    }

    public float[] zDotProduct(FComplexMatrix1D fComplexMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        int n5 = (int)this.size();
        if (n < 0 || n2 <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        int n6 = n + n2;
        if (n5 < n6) {
            n6 = n5;
        }
        if (fComplexMatrix1D.size < n6) {
            n6 = fComplexMatrix1D.size;
        }
        if ((n2 = n6 - n) <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n7 = intArrayList2.size();
        for (n4 = 0; n4 < n7 && nArray[n4] < n; ++n4) {
        }
        float[] fArray = new float[2];
        while (--n2 >= 0 && n4 < n7 && (n3 = nArray[n4]) < n6) {
            float[] fArray2 = fComplexMatrix1D.getQuick(n3);
            fArray2[1] = -fArray2[1];
            fArray = FComplex.plus(fArray, FComplex.mult(fArray2, this.getQuick(n3)));
            ++n4;
        }
        return fArray;
    }

    public float[] zSum() {
        float[] fArray = new float[2];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            float[][] fArray2 = new float[n][2];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        for (int i = n4; i < n5; ++i) {
                            fArray = FComplex.plus(fArray, FComplexMatrix1D.this.getQuick(i));
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray2[n2] = (float[])futureArray[n2].get();
                }
                fArray = fArray2[0];
                for (n2 = 1; n2 < n; ++n2) {
                    fArray[0] = fArray[0] + fArray2[n2][0];
                    fArray[1] = fArray[1] + fArray2[n2][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                fArray = FComplex.plus(fArray, this.getQuick(i));
            }
        }
        return fArray;
    }

    protected int cardinality(int n) {
        int n2 = (int)this.size();
        int n3 = 0;
        int n4 = 0;
        float[] fArray = new float[2];
        while (n4++ < n2 && n3 < n) {
            fArray = this.getQuick(n4);
            if ((double)fArray[0] == 0.0 && (double)fArray[1] == 0.0) continue;
            ++n3;
        }
        return n3;
    }

    protected FComplexMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D == null) {
            return false;
        }
        if (this == fComplexMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(fComplexMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        return false;
    }

    protected FComplexMatrix1D view() {
        return (FComplexMatrix1D)this.clone();
    }

    protected abstract FComplexMatrix1D viewSelectionLike(int[] var1);

    protected float[] zDotProduct(FComplexMatrix1D fComplexMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(fComplexMatrix1D, 0, (int)this.size(), intArrayList);
    }
}

