/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.PruningEnum;
import eu.kliegr.ac1.RuleLearningAlgEnum;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class RuleLearningConfig
extends BaseConfig {
    private static final Logger LOGGER = Logger.getLogger(RuleLearningConfig.class.getName());
    private final float minConfidence;
    private final int minLen;
    private final int maxLen;
    private final float minSupport;
    private final RuleLearningAlgEnum algorithm;
    private final PruningEnum pruning;
    private final int targetRuleCount;
    private final float confEpsilon;
    private final float maxExecTimeTotal;
    private final float maxExecTimeIter;
    private final boolean useDiscretizedInput;

    public RuleLearningConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.setOutputPath(prop.getProperty("OutputPath"));
        this.dataPath = prop.getProperty("TrainDataPath");
        this.minConfidence = Float.parseFloat(prop.getProperty("minConfidence"));
        this.minLen = Integer.parseInt(prop.getProperty("minLen"));
        this.maxLen = Integer.parseInt(prop.getProperty("maxLen"));
        this.targetRuleCount = Integer.parseInt(prop.getProperty("targetRuleCount"));
        this.confEpsilon = Float.parseFloat(prop.getProperty("confEpsilon"));
        this.maxExecTimeIter = Float.parseFloat(prop.getProperty("maxExecTimeIter"));
        this.maxExecTimeTotal = Float.parseFloat(prop.getProperty("maxExecTimeTotal"));
        this.minSupport = Float.parseFloat(prop.getProperty("minSupport"));
        this.useDiscretizedInput = Boolean.parseBoolean(prop.getProperty("UseDiscretizedInput"));
        String _pruning = prop.getProperty("PruningAlgorithm");
        this.pruning = _pruning != null ? PruningEnum.valueOf(_pruning) : null;
        this.csvSeparator = prop.getProperty("DataTypes").contains(";") ? ";" : ",";
        this.attType = this.parseAttributeTypes(prop.getProperty("DataTypes").split(this.csvSeparator));
        String _algorithm = prop.getProperty("Algorithm");
        this.algorithm = _algorithm == null ? RuleLearningAlgEnum.arules : RuleLearningAlgEnum.valueOf(_algorithm);
        this.targetAttribute = prop.getProperty("TargetAttribute");
        this.IDcolumnName = prop.getProperty("IDcolumnName");
    }

    public float getMinConfidence() {
        return this.minConfidence;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public float getMaxExecTimeIter() {
        return this.maxExecTimeIter;
    }

    public float getMaxExecTimeTotal() {
        return this.maxExecTimeTotal;
    }

    public float getConfEpsilon() {
        return this.confEpsilon;
    }

    public int getTargetRuleCount() {
        return this.targetRuleCount;
    }

    public float getMinSupport() {
        return this.minSupport;
    }

    public PruningEnum getPruning() {
        return this.pruning;
    }

    public RuleLearningAlgEnum getAlgorithm() {
        return this.algorithm;
    }

    public boolean isUseDiscretizedInput() {
        return this.useDiscretizedInput;
    }
}

