/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.filters.unsupervised.attribute.RandomProjection;

public class RandomizableFilteredClassifier
extends FilteredClassifier {
    static final long serialVersionUID = -4523466618555717333L;

    @Override
    public String globalInfo() {
        return "A simple variant of the FilteredClassifier that instantiates the model with a randomizable filter, more specifically, RandomProjection, and IBk as the base classifier. Other than this, and checking that at least one of the two base schemes implements the Randomizable interface, it implements exactly the same functionality as FilteredClassifier, which (now) also implements Randomizable.";
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.lazy.IBk";
    }

    @Override
    protected String defaultFilterString() {
        return "weka.filters.unsupervised.attribute.RandomProjection -N 10 -D Sparse1";
    }

    public RandomizableFilteredClassifier() {
        this.m_Classifier = new IBk();
        this.m_Filter = new RandomProjection();
    }

    @Override
    public void initializeClassifier(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof Randomizable) && !(this.m_Filter instanceof Randomizable)) {
            throw new Exception("Either the classifier or the filter must implement the Randomizable interface.");
        }
        super.initializeClassifier(data);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof Randomizable) && !(this.m_Filter instanceof Randomizable)) {
            throw new Exception("Either the classifier or the filter must implement the Randomizable interface.");
        }
        super.buildClassifier(data);
    }

    @Override
    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "RandomizableFilteredClassifier: No model built yet.";
        }
        String result = "RandomizableFilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9117 $");
    }

    public static void main(String[] argv) {
        RandomizableFilteredClassifier.runClassifier(new RandomizableFilteredClassifier(), argv);
    }
}

