/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCBA;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierCBA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCBA.Replace;

public class Rule
implements Comparable {
    int[] antecedent;
    int[] classCasesCovered;
    int clas;
    int nAnts;
    int mark;
    long time;
    ArrayList<Replace> replace;
    double conf;
    double supp;
    DataBase dataBase;

    public Rule(Rule r) {
        int k;
        this.antecedent = new int[r.antecedent.length];
        this.classCasesCovered = new int[r.classCasesCovered.length];
        for (k = 0; k < this.antecedent.length; ++k) {
            this.antecedent[k] = r.antecedent[k];
        }
        for (k = 0; k < this.classCasesCovered.length; ++k) {
            this.classCasesCovered[k] = r.classCasesCovered[k];
        }
        this.replace = new ArrayList();
        for (k = 0; k < r.replace.size(); ++k) {
            this.replace.add(r.replace.get(k).clone());
        }
        this.clas = r.clas;
        this.dataBase = r.dataBase;
        this.conf = r.conf;
        this.supp = r.supp;
        this.nAnts = r.nAnts;
        this.mark = r.mark;
        this.time = r.time;
    }

    public Rule(DataBase dataBase) {
        int i;
        this.replace = new ArrayList();
        this.antecedent = new int[dataBase.numVariables()];
        this.classCasesCovered = new int[dataBase.numClasses()];
        for (i = 0; i < this.antecedent.length; ++i) {
            this.antecedent[i] = -1;
        }
        for (i = 0; i < this.classCasesCovered.length; ++i) {
            this.classCasesCovered[i] = 0;
        }
        this.clas = -1;
        this.dataBase = dataBase;
        this.conf = 0.0;
        this.supp = 0.0;
        this.nAnts = 0;
        this.mark = 0;
        this.time = 0L;
    }

    public Rule clone() {
        int i;
        Rule r = new Rule(this.dataBase);
        for (i = 0; i < this.antecedent.length; ++i) {
            r.antecedent[i] = this.antecedent[i];
        }
        for (i = 0; i < this.classCasesCovered.length; ++i) {
            r.classCasesCovered[i] = this.classCasesCovered[i];
        }
        for (i = 0; i < this.replace.size(); ++i) {
            r.replace.add(this.replace.get(i).clone());
        }
        r.clas = this.clas;
        r.dataBase = this.dataBase;
        r.conf = this.conf;
        r.supp = this.supp;
        r.nAnts = this.nAnts;
        r.mark = this.mark;
        r.time = this.time;
        return r;
    }

    public void asignaAntecedente(int[] antecedent) {
        this.nAnts = 0;
        for (int i = 0; i < antecedent.length; ++i) {
            this.antecedent[i] = antecedent[i];
            if (this.antecedent[i] <= -1) continue;
            ++this.nAnts;
        }
    }

    public void setConsequent(int clas) {
        this.clas = clas;
    }

    public double matching(int[] example) {
        return this.degree(example);
    }

    private double degree(int[] example) {
        double degree = 1.0;
        for (int i = 0; i < this.antecedent.length && degree > 0.0; degree *= (double)this.dataBase.matching(i, this.antecedent[i], example[i]), ++i) {
        }
        return degree;
    }

    public void addReplace(Replace r) {
        this.replace.add(r);
    }

    public boolean isEqual(Rule rule) {
        if (this.clas != rule.getClas()) {
            return false;
        }
        for (int i = 0; i < this.antecedent.length; ++i) {
            if (this.antecedent[i] == rule.antecedent[i]) continue;
            return false;
        }
        return true;
    }

    public void setConfidence(double conf) {
        this.conf = conf;
    }

    public void setSupport(double supp) {
        this.supp = supp;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    public double getConfidence() {
        return this.conf;
    }

    public double getSupport() {
        return this.supp;
    }

    public int getClas() {
        return this.clas;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getMark() {
        return this.mark;
    }

    public void onMark() {
        this.mark = 1;
    }

    public void offMark() {
        this.mark = 0;
    }

    public int getnReplace() {
        return this.replace.size();
    }

    public Replace getReplace(int pos) {
        return this.replace.get(pos);
    }

    public boolean isMark() {
        return this.mark == 1;
    }

    public boolean isPrecedence(Rule r) {
        if (this.conf > r.conf) {
            return true;
        }
        if (this.conf < r.conf) {
            return false;
        }
        if (this.supp > r.supp) {
            return true;
        }
        if (this.supp < r.supp) {
            return false;
        }
        if (this.time < r.time) {
            return true;
        }
        return this.time <= r.time;
    }

    public void incrCovered(int clas) {
        int n = clas;
        this.classCasesCovered[n] = this.classCasesCovered[n] + 1;
    }

    public void decrCovered(int clas) {
        int n = clas;
        this.classCasesCovered[n] = this.classCasesCovered[n] - 1;
    }

    public int getclassCasesCovered(int clas) {
        return this.classCasesCovered[clas];
    }

    public boolean isSubset(Rule a) {
        if (this.clas != a.clas || this.nAnts > a.nAnts) {
            return false;
        }
        for (int k = 0; k < this.antecedent.length; ++k) {
            if (this.antecedent[k] <= -1 || this.antecedent[k] == a.antecedent[k]) continue;
            return false;
        }
        return true;
    }

    public void setLabel(int pos, int label) {
        if (this.antecedent[pos] < 0 && label > -1) {
            ++this.nAnts;
        }
        if (this.antecedent[pos] > -1 && label < 0) {
            --this.nAnts;
        }
        this.antecedent[pos] = label;
    }

    public int compareTo(Object a) {
        if (((Rule)a).conf < this.conf) {
            return -1;
        }
        if (((Rule)a).conf > this.conf) {
            return 1;
        }
        if (((Rule)a).supp < this.supp) {
            return -1;
        }
        if (((Rule)a).supp > this.supp) {
            return 1;
        }
        if (((Rule)a).time < this.time) {
            return 1;
        }
        if (((Rule)a).time > this.time) {
            return -1;
        }
        return 0;
    }
}

