/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.PFKNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;
import org.core.Randomize;

public class PFKNN
extends FuzzyIBLAlgorithm {
    private int K;
    private int[] selected;
    private double[][] membership;
    private double[][] referenceMembership;
    private double[][] testMembership;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.seed = Long.parseLong(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public PFKNN(String script) {
        this.readDataFiles(script);
        this.name = "PFKNN";
        this.selected = new int[this.trainData.length];
        this.membership = new double[this.trainData.length][this.nClasses];
        this.referenceMembership = new double[this.referenceData.length][this.nClasses];
        this.testMembership = new double[this.testData.length][this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    private void selectBoundaryPoints() {
        Arrays.fill(this.selected, 0);
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (int index = 0; index < this.trainData.length; ++index) {
            int i;
            for (i = 0; i < this.K; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                if (this.trainOutput[i] == this.trainOutput[index]) continue;
                double dist = Util.euclideanDistance(this.trainData[i], this.trainData[index]);
                boolean stop = false;
                for (int j = 0; j < this.K && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.K - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            for (int j = 0; j < this.K; ++j) {
                this.selected[nearestN[j]] = 1;
            }
        }
    }

    private void shuffleVector(int[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            int pos = Randomize.Randint(0, vector.length);
            int tmp = vector[i];
            vector[i] = vector[pos];
            vector[pos] = tmp;
        }
    }

    private void accomodateClusters() {
        this.evaluateMembership();
        int[] order = new int[this.trainData.length];
        for (int i = 0; i < this.trainData.length; ++i) {
            order[i] = i;
        }
        double[] classMembership = new double[this.nClasses];
        for (int i = 0; i < this.trainData.length; ++i) {
            int n;
            int i2;
            int index = order[i];
            Arrays.fill(classMembership, 0.0);
            int[] nearestN = new int[this.K];
            double[] minDist = new double[this.K];
            for (i2 = 0; i2 < this.K; ++i2) {
                nearestN[i2] = -1;
                minDist[i2] = Double.MAX_VALUE;
            }
            for (i2 = 0; i2 < this.trainData.length; ++i2) {
                double dist = Util.euclideanDistance(this.trainData[i2], this.trainData[index]);
                if (i2 == index) continue;
                boolean stop = false;
                for (int j = 0; j < this.K && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.K - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i2;
                    stop = true;
                }
            }
            double MAX_NORM = 1.0E8;
            double[] norm = new double[this.K];
            double sum = 0.0;
            for (n = 0; n < this.K; ++n) {
                if (nearestN[n] == -1) continue;
                if (minDist[n] == 0.0) {
                    norm[n] = MAX_NORM;
                }
                norm[n] = 1.0 / Math.pow(minDist[n], 2.0);
                norm[n] = Math.min(norm[n], MAX_NORM);
                sum += norm[n];
            }
            for (n = 0; n < this.K; ++n) {
                if (nearestN[n] == -1) continue;
                for (int c = 0; c < this.nClasses; ++c) {
                    int n2 = c;
                    classMembership[n2] = classMembership[n2] + this.membership[nearestN[n]][c] * (norm[n] / sum);
                }
            }
            double max = Double.MIN_VALUE;
            int pred = -1;
            for (int c = 0; c < this.nClasses; ++c) {
                if (!(max < classMembership[c])) continue;
                max = classMembership[c];
                pred = c;
            }
            if (pred == this.trainOutput[index]) continue;
            this.selected[index] = 1;
            this.evaluateMembership();
        }
    }

    private void evaluateMembership() {
        for (int instance = 0; instance < this.trainData.length; ++instance) {
            if (this.selected[instance] == 1) {
                int i;
                int[] nearestN = new int[this.K];
                double[] minDist = new double[this.K];
                for (i = 0; i < this.K; ++i) {
                    nearestN[i] = 0;
                    minDist[i] = Double.MAX_VALUE;
                }
                for (i = 0; i < this.trainData.length; ++i) {
                    double dist = Util.euclideanDistance(this.trainData[i], this.trainData[instance]);
                    if (this.selected[i] != 1 || i == instance) continue;
                    boolean stop = false;
                    for (int j = 0; j < this.K && !stop; ++j) {
                        if (!(dist < minDist[j])) continue;
                        for (int l = this.K - 1; l >= j + 1; --l) {
                            minDist[l] = minDist[l - 1];
                            nearestN[l] = nearestN[l - 1];
                        }
                        minDist[j] = dist;
                        nearestN[j] = i;
                        stop = true;
                    }
                }
                int[] selectedClasses = new int[this.nClasses];
                Arrays.fill(selectedClasses, 0);
                for (i = 0; i < this.K; ++i) {
                    int n = this.trainOutput[nearestN[i]];
                    selectedClasses[n] = selectedClasses[n] + 1;
                }
                Arrays.fill(this.membership[instance], 0.0);
                for (int i2 = 0; i2 < this.nClasses; ++i2) {
                    double term = (double)selectedClasses[i2] / (double)this.K;
                    this.membership[instance][i2] = this.trainOutput[instance] == i2 ? 0.51 + 0.49 * term : 0.49 * term;
                }
                continue;
            }
            for (int i = 0; i < this.nClasses; ++i) {
                this.membership[instance][i] = this.trainOutput[instance] == i ? 1.0 : 0.0;
            }
        }
    }

    private void editTrainingSet() {
        int instance;
        int[] remove = new int[this.trainData.length];
        Arrays.fill(remove, 1);
        for (instance = 0; instance < this.trainData.length; ++instance) {
            int winner = -1;
            double minDist = Double.MAX_VALUE;
            for (int i = 0; i < this.trainData.length; ++i) {
                double dist;
                if (this.selected[i] != 1 || this.trainOutput[i] != this.trainOutput[instance] || !(minDist > (dist = Util.euclideanDistance(this.trainData[instance], this.trainData[i])))) continue;
                minDist = dist;
                winner = i;
            }
            if (winner != -1) {
                remove[winner] = 0;
                continue;
            }
            remove[instance] = 0;
        }
        for (instance = 0; instance < this.trainData.length; ++instance) {
            if (remove[instance] != 1) continue;
            this.selected[instance] = 0;
        }
        this.evaluateMembership();
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.trainPrediction[i] = this.classifyTrain(i, this.trainData[i]);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.testPrediction[i] = this.classifyTest(i, this.testData[i]);
        }
    }

    private int classifyTrain(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            if (this.selected[i2] != 1 || index == i2) continue;
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        double MAX_NORM = 1.0E8;
        for (i = 0; i < this.K; ++i) {
            if (minDist[i] == 0.0) {
                norm[i] = MAX_NORM;
            }
            norm[i] = 1.0 / Math.pow(minDist[i], 2.0);
            norm[i] = Math.min(norm[i], MAX_NORM);
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.referenceMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
        return this.computeClass(this.referenceMembership[index]);
    }

    private int classifyTest(int index, double[] example) {
        int i;
        int i2;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i2 = 0; i2 < this.K; ++i2) {
            nearestN[i2] = 0;
            minDist[i2] = Double.MAX_VALUE;
        }
        for (i2 = 0; i2 < this.trainData.length; ++i2) {
            if (this.selected[i2] != 1) continue;
            double dist = Util.euclideanDistance(this.trainData[i2], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i2;
                stop = true;
            }
        }
        double[] norm = new double[this.K];
        double sum = 0.0;
        double MAX_NORM = 1.0E8;
        for (i = 0; i < this.K; ++i) {
            if (minDist[i] == 0.0) {
                norm[i] = MAX_NORM;
            }
            norm[i] = 1.0 / Math.pow(minDist[i], 2.0);
            norm[i] = Math.min(norm[i], MAX_NORM);
            sum += norm[i];
        }
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.testMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.membership[nearestN[i]][c] * (norm[i] / sum);
            }
        }
        return this.computeClass(this.testMembership[index]);
    }

    private int computeClass(double[] pertenence) {
        double max = Double.MIN_VALUE;
        int output = -1;
        for (int i = 0; i < pertenence.length; ++i) {
            if (!(max < pertenence[i])) continue;
            max = pertenence[i];
            output = i;
        }
        return output;
    }

    public void generateModel() {
        Timer.resetTime();
        this.selectBoundaryPoints();
        this.accomodateClusters();
        this.editTrainingSet();
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

