/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IRecombinator;
import net.sf.jclec.ISystem;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecoratedRecombinator<I extends IIndividual>
implements IRecombinator<I>,
IConfigure {
    protected IRecombinator<I> decorated;
    protected ISystem<I> context;

    public DecoratedRecombinator() {
    }

    public DecoratedRecombinator(ISystem<I> context) {
        this.contextualize(context);
    }

    public final IRecombinator<I> getDecorated() {
        return this.decorated;
    }

    public final void setDecorated(IRecombinator<I> decorated) {
        this.decorated = decorated;
        if (this.context != null) {
            decorated.contextualize(this.context);
        }
    }

    @Override
    public void contextualize(ISystem<I> context) {
        this.context = context;
        if (this.decorated != null) {
            this.decorated.contextualize(context);
        }
    }

    @Override
    public final int getPpl() {
        return this.decorated.getPpl();
    }

    @Override
    public final int getSpl() {
        return this.decorated.getSpl();
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String decoratedClassname = settings.getString("decorated[@type]");
            Class<?> decoratedClass = Class.forName(decoratedClassname);
            IRecombinator decorated = (IRecombinator)decoratedClass.newInstance();
            if (decorated instanceof IConfigure) {
                ((IConfigure)((Object)decorated)).configure(settings.subset("decorated"));
            }
            this.setDecorated(decorated);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

