/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.GivensRotation;
import ec.tstoolkit.maths.matrices.HouseholderReflection;
import ec.tstoolkit.maths.matrices.IVectorTransformation;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class ElementaryTransformations {
    public static void transform(IVectorTransformation transformation, DataBlockIterator vectors) {
        DataBlock cur = vectors.getData();
        do {
            transformation.transform(cur);
        } while (vectors.next());
    }

    public static void rowHouseholder(SubMatrix m) {
        ElementaryTransformations.householder(m.rows());
    }

    public static boolean givensTriangularize(SubMatrix X) {
        try {
            int r = X.getRowsCount();
            int c = X.getColumnsCount();
            SubMatrix L = X;
            do {
                ElementaryTransformations.rowGivens(L);
                L = L.extract(1, r, 1, c);
                --r;
                --c;
            } while (!L.isEmpty());
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static boolean fastRowGivens(SubMatrix X) {
        try {
            int nr = X.m_nrows;
            int nc = X.m_ncols;
            int rinc = X.m_row_inc;
            int cinc = X.m_col_inc;
            int beg = X.m_start;
            double[] x = X.m_data;
            int c = 1;
            int cur = beg + cinc;
            while (c < nc) {
                double a = x[beg];
                double b = x[cur];
                if (b != 0.0) {
                    double d;
                    double ro;
                    double h;
                    if (a != 0.0) {
                        h = ElementaryTransformations.hypotenuse(a, b);
                        ro = b / h;
                        d = a / h;
                    } else if (b < 0.0) {
                        d = 0.0;
                        ro = -1.0;
                        h = -b;
                    } else {
                        d = 0.0;
                        ro = 1.0;
                        h = b;
                    }
                    x[cur] = 0.0;
                    x[beg] = a = h;
                    int s = 1;
                    int sdiag = beg + rinc;
                    int scur = cur + rinc;
                    while (s < nr) {
                        a = x[sdiag];
                        b = x[scur];
                        x[sdiag] = d * a + ro * b;
                        x[scur] = -ro * a + d * b;
                        ++s;
                        sdiag += rinc;
                        scur += rinc;
                    }
                }
                ++c;
                cur += cinc;
            }
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static void rowHouseholder(DataBlock row, SubMatrix X) {
        DataBlockIterator rows = X.rows();
        DataBlock cur = rows.getData();
        HouseholderReflection reflection = HouseholderReflection.from(row);
        do {
            reflection.transform(cur);
        } while (rows.next());
    }

    public static boolean fastRowGivens(DataBlock row, SubMatrix X) {
        try {
            int nr = X.m_nrows;
            int rinc = X.m_row_inc;
            int cinc = X.m_col_inc;
            int beg = X.m_start;
            double[] x = X.m_data;
            double[] z = row.getData();
            int zbeg = row.getStartPosition();
            int zend = row.getEndPosition();
            int zinc = row.getIncrement();
            int zcur = zbeg + zinc;
            int mbeg = beg + cinc;
            while (zcur != zend) {
                double a = z[zbeg];
                double b = z[zcur];
                if (b != 0.0) {
                    double d;
                    double ro;
                    double h;
                    if (a != 0.0) {
                        h = ElementaryTransformations.hypotenuse(a, b);
                        ro = b / h;
                        d = a / h;
                    } else if (b < 0.0) {
                        d = 0.0;
                        ro = -1.0;
                        h = -b;
                    } else {
                        d = 0.0;
                        ro = 1.0;
                        h = b;
                    }
                    z[zcur] = 0.0;
                    z[zbeg] = a = h;
                    int r = 0;
                    int rdiag = beg;
                    int rcur = mbeg;
                    while (r < nr) {
                        a = x[rdiag];
                        b = x[rcur];
                        x[rdiag] = d * a + ro * b;
                        x[rcur] = -ro * a + d * b;
                        ++r;
                        rdiag += rinc;
                        rcur += rinc;
                    }
                }
                zcur += zinc;
                mbeg += cinc;
            }
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static boolean fastGivensTriangularize(SubMatrix X) {
        try {
            int nr = X.m_nrows;
            int nc = X.m_ncols;
            int rinc = X.m_row_inc;
            int cinc = X.m_col_inc;
            int beg = X.m_start;
            int dinc = rinc + cinc;
            double[] x = X.m_data;
            int r = 0;
            int idiag = beg;
            while (r < nr) {
                int c = r + 1;
                int cur = idiag + cinc;
                while (c < nc) {
                    double a = x[idiag];
                    double b = x[cur];
                    if (b != 0.0) {
                        double d;
                        double ro;
                        double h;
                        if (a != 0.0) {
                            h = ElementaryTransformations.hypotenuse(a, b);
                            ro = b / h;
                            d = a / h;
                        } else if (b < 0.0) {
                            d = 0.0;
                            ro = -1.0;
                            h = -b;
                        } else {
                            d = 0.0;
                            ro = 1.0;
                            h = b;
                        }
                        x[cur] = 0.0;
                        x[idiag] = a = h;
                        int s = r + 1;
                        int sdiag = idiag + rinc;
                        int scur = cur + rinc;
                        while (s < nr) {
                            a = x[sdiag];
                            b = x[scur];
                            x[sdiag] = d * a + ro * b;
                            x[scur] = -ro * a + d * b;
                            ++s;
                            sdiag += rinc;
                            scur += rinc;
                        }
                    }
                    ++c;
                    cur += cinc;
                }
                ++r;
                idiag += dinc;
            }
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static boolean householderTriangularize(SubMatrix X) {
        try {
            int r = X.getRowsCount();
            int c = X.getColumnsCount();
            SubMatrix L = X;
            do {
                ElementaryTransformations.rowHouseholder(L);
                L = L.extract(1, r, 1, c);
                --r;
                --c;
            } while (!L.isEmpty());
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static void rowGivens(SubMatrix m) {
        ElementaryTransformations.givens(m.rows(), m.getColumnsCount());
    }

    public static void columnHouseholder(SubMatrix m) {
        ElementaryTransformations.householder(m.columns());
    }

    private static void householder(DataBlockIterator vectors) {
        DataBlock cur = vectors.getData();
        HouseholderReflection reflection = HouseholderReflection.from(cur);
        while (vectors.next()) {
            reflection.transform(cur);
        }
    }

    public static boolean extendedGivensTriangularize(Matrix X, DataBlock W, Matrix L, DataBlock V) {
        int nc = X.getColumnsCount();
        int nr = X.getRowsCount();
        double one = 1.0;
        double[] pl = L.data_;
        double[] px = X.data_;
        int i = 0;
        int j = 0;
        while (j < nr) {
            pl[i] = one;
            ++j;
            i += nr + 1;
        }
        for (i = 0; i < nc; ++i) {
            double w = W.get(i);
            if (w == 0.0) continue;
            for (int j2 = 0; j2 < nr; ++j2) {
                int il;
                double xj = X.get(j2, i);
                if (xj == 0.0) continue;
                double v = V.get(j2);
                if (v == 0.0) {
                    int k = j2 + 1;
                    il = k + j2 * nr;
                    int ix = k + i * nr;
                    while (k < nr) {
                        pl[il] = px[ix] / xj;
                        ++k;
                        ++ix;
                        ++il;
                    }
                    if (Double.isInfinite(w)) {
                        V.set(j2, Double.POSITIVE_INFINITY);
                        break;
                    }
                    V.set(j2, w * xj * xj);
                    break;
                }
                if (Double.isInfinite(v)) {
                    int k = j2 + 1;
                    il = k + j2 * nr;
                    int ix = k + i * nr;
                    while (k < nr) {
                        int n = ix++;
                        px[n] = px[n] - pl[il] * xj;
                        ++k;
                        ++il;
                    }
                    continue;
                }
                if (Double.isInfinite(w)) {
                    int k = j2 + 1;
                    il = k + j2 * nr;
                    int ix = k + i * nr;
                    while (k < nr) {
                        double l = pl[il];
                        pl[il] = px[ix] / xj;
                        int n = ix++;
                        px[n] = px[n] - l * xj;
                        ++k;
                        ++il;
                    }
                    w = v / (xj * xj);
                    V.set(j2, Double.POSITIVE_INFINITY);
                    continue;
                }
                double nv = v + xj * xj * w;
                double z = v / nv;
                int k = j2 + 1;
                int il2 = k + j2 * nr;
                int ix = k + i * nr;
                while (k < nr) {
                    double l = pl[il2];
                    pl[il2] = z * l + w * xj / nv * px[ix];
                    int n = ix++;
                    px[n] = px[n] - l * xj;
                    ++k;
                    ++il2;
                }
                w *= z;
                V.set(j2, nv);
            }
            W.set(i, w);
        }
        return true;
    }

    private static void givens(DataBlockIterator vectors, int n) {
        DataBlock cur = vectors.getData();
        for (int i = 1; i < n; ++i) {
            vectors.begin();
            if (cur.get(i) == 0.0) continue;
            GivensRotation rotation = new GivensRotation(cur, i);
            while (vectors.next()) {
                rotation.transform(cur);
            }
        }
    }

    public static double hypotenuse(double x, double y) {
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double w = Math.max(xabs, yabs);
        double z = Math.min(xabs, yabs);
        if (z == 0.0) {
            return w;
        }
        double zw = z / w;
        return w * Math.sqrt(1.0 + zw * zw);
    }
}

