/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileLoader
implements TileLoader {
    public static String USER_AGENT = "ropenstreetmapclient/1.0 (+https://github.com/ifellows/ROSM)";
    public static String ACCEPT = "text/html, image/png, image/jpeg, image/gif, */*";
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener tileLoaderListener) {
        this.listener = tileLoaderListener;
    }

    public Runnable createTileLoaderJob(final TileSource tileSource, final int n, final int n2, final int n3) {
        return new Runnable(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile;
                TileCache tileCache = OsmTileLoader.this.listener.getTileCache();
                Object object = tileCache;
                synchronized (object) {
                    tile = tileCache.getTile(tileSource, n, n2, n3);
                    if (tile == null || tile.isLoaded() || tile.loading) {
                        return;
                    }
                    tile.loading = true;
                }
                try {
                    object = OsmTileLoader.this.loadTileFromOsm(tile);
                    OsmTileLoader.this.loadTileMetadata(tile, (URLConnection)object);
                    if ("no-tile".equals(tile.getValue("tile-info"))) {
                        tile.setError("No tile at this zoom level");
                    } else {
                        this.input = ((URLConnection)object).getInputStream();
                        tile.loadImage(this.input);
                        this.input.close();
                        this.input = null;
                    }
                    tile.setLoaded(true);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                }
                catch (Exception exception) {
                    tile.setError(exception.getMessage());
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                    if (this.input == null) {
                        System.err.println("failed loading " + n3 + "/" + n + "/" + n2 + " " + exception.getMessage());
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }
        };
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL uRL = new URL(tile.getUrl());
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)uRLConnection);
        }
        uRLConnection.setReadTimeout(30000);
        return uRLConnection;
    }

    protected void loadTileMetadata(Tile tile, URLConnection uRLConnection) {
        String string = uRLConnection.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
        if (string != null) {
            tile.putValue("capture-date", string);
        }
        if ((string = uRLConnection.getHeaderField("X-VE-Tile-Info")) != null) {
            tile.putValue("tile-info", string);
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection httpURLConnection) {
        if (USER_AGENT != null) {
            httpURLConnection.setRequestProperty("User-agent", USER_AGENT);
        }
        httpURLConnection.setRequestProperty("Accept", ACCEPT);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

