/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.HeadNode;
import org.rosuda.JGR.browser.Refresher;

public class BrowserTree
extends JTree {
    static int nodeOffset = -1;
    HeadNode head;
    DefaultTreeModel mod;
    Refresher ref;

    public BrowserTree() {
        if (nodeOffset == -1) {
            nodeOffset = (Integer)UIManager.get("Tree.rightChildIndent") + (Integer)UIManager.get("Tree.leftChildIndent");
        }
        this.head = new HeadNode();
        this.mod = new DefaultTreeModel(this.head);
        this.setModel(this.mod);
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new BrowserCellRenderer());
        new Thread(new Runnable(){

            @Override
            public void run() {
                BrowserTree.this.head.update(BrowserTree.this.mod);
            }
        }).start();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.repaint();
        ExpandListener lis = new ExpandListener();
        this.addTreeWillExpandListener(lis);
        this.addTreeExpansionListener(lis);
        TreeMouseListener mlis = new TreeMouseListener();
        this.addMouseListener(mlis);
        this.setRowHeight(0);
        this.setToggleClickCount(1000);
    }

    public void startRefresher() {
        if (this.ref != null) {
            return;
        }
        this.ref = new Refresher(this.mod);
        new Thread(this.ref).start();
    }

    public void stopRefresher() {
        if (this.ref != null) {
            this.ref.stopRunning();
            this.ref = null;
        }
    }

    class BrowserCellRenderer
    implements TreeCellRenderer {
        BrowserCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            BrowserNode node = (BrowserNode)value;
            return node.getRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    class ExpandListener
    implements TreeWillExpandListener,
    TreeExpansionListener {
        ExpandListener() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            final BrowserNode node = (BrowserNode)event.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    node.setExpanded(true);
                    node.update(BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BrowserTree.this.mod.reload(node);
                        }
                    });
                }
            }).start();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            final BrowserNode node = (BrowserNode)event.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    node.setExpanded(false);
                    node.update(BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BrowserTree.this.mod.reload(node);
                        }
                    });
                }
            }).start();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    class TreeMouseListener
    implements MouseListener {
        TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = BrowserTree.this.getClosestRowForLocation(e.getX(), e.getY());
                BrowserTree.this.setSelectionRow(row);
                final BrowserNode node = (BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        node.editObject();
                    }
                }).start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pop(e);
            } else {
                int wid = BrowserTree.this.getParent().getWidth();
                if (e.getX() < wid - nodeOffset && e.getX() >= wid - nodeOffset * 2) {
                    this.pop(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.pop(e);
            }
        }

        private void pop(MouseEvent e) {
            int row = BrowserTree.this.getClosestRowForLocation(e.getX(), e.getY());
            BrowserTree.this.setSelectionRow(row);
            JPopupMenu popupMenu = ((BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent()).getPopupMenu();
            if (popupMenu != null) {
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

