/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfcomplex;

import cern.jet.math.tfloat.FloatConstants;

public class FComplex
extends FloatConstants {
    public static final float abs(float[] fArray) {
        float f = Math.abs(fArray[0]);
        float f2 = Math.abs(fArray[1]);
        if ((double)f == 0.0 && (double)f2 == 0.0) {
            return 0.0f;
        }
        if (f >= f2) {
            float f3 = fArray[1] / fArray[0];
            return (float)((double)f * Math.sqrt(1.0 + (double)(f3 * f3)));
        }
        float f4 = fArray[0] / fArray[1];
        return (float)((double)f2 * Math.sqrt(1.0 + (double)(f4 * f4)));
    }

    public static final float abs(float f, float f2) {
        float f3 = Math.abs(f);
        float f4 = Math.abs(f2);
        if ((double)f3 == 0.0 && (double)f4 == 0.0) {
            return 0.0f;
        }
        if (f3 >= f4) {
            float f5 = f2 / f;
            return (float)((double)f3 * Math.sqrt(1.0 + (double)(f5 * f5)));
        }
        float f6 = f / f2;
        return (float)((double)f4 * Math.sqrt(1.0 + (double)(f6 * f6)));
    }

    public static final float[] acos(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = (float)(1.0 - (double)(fArray[0] * fArray[0] - fArray[1] * fArray[1]));
        float f2 = -(fArray[0] * fArray[1] + fArray[1] * fArray[0]);
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2 = FComplex.sqrt(fArray2);
        f = -fArray2[1];
        f2 = fArray2[0];
        fArray2[0] = fArray[0] + f;
        fArray2[1] = fArray[1] + f2;
        f = (float)Math.log(FComplex.abs(fArray2));
        fArray2[0] = f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
        fArray2[1] = -f;
        return fArray2;
    }

    public static final float arg(float[] fArray) {
        return (float)Math.atan2(fArray[1], fArray[0]);
    }

    public static final float arg(float f, float f2) {
        return (float)Math.atan2(f2, f);
    }

    public static final float[] asin(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = (float)(1.0 - (double)(fArray[0] * fArray[0] - fArray[1] * fArray[1]));
        float f2 = -(fArray[0] * fArray[1] + fArray[1] * fArray[0]);
        fArray2[0] = f;
        fArray2[1] = f2;
        fArray2 = FComplex.sqrt(fArray2);
        f = -fArray2[1];
        f2 = fArray2[0];
        fArray2[0] = fArray2[0] + f;
        fArray2[1] = fArray2[1] + f2;
        f = (float)Math.log(FComplex.abs(fArray2));
        fArray2[0] = f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
        fArray2[1] = -f;
        return fArray2;
    }

    public static final float[] atan(float[] fArray) {
        float[] fArray2 = new float[]{-fArray[0], 1.0f - fArray[1]};
        float f = fArray[0];
        float f2 = 1.0f + fArray[1];
        fArray2 = FComplex.div(fArray2, f, f2);
        f = (float)Math.log(FComplex.abs(fArray2));
        f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
        fArray2[0] = 0.5f * f2;
        fArray2[1] = -0.5f * f;
        return fArray2;
    }

    public static final float[] conj(float[] fArray) {
        float[] fArray2 = new float[]{fArray[0], -fArray[1]};
        return fArray2;
    }

    public static final float[] cos(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = -fArray[1];
        float f2 = fArray[0];
        float f3 = (float)Math.exp(f);
        float f4 = (float)((double)f3 * Math.cos(f2));
        float f5 = (float)((double)f3 * Math.sin(f2));
        f3 = (float)Math.exp(-f);
        float f6 = (float)((double)f3 * Math.cos(-f2));
        float f7 = (float)((double)f3 * Math.sin(-f2));
        fArray2[0] = 0.5f * (f4 += f6);
        fArray2[1] = 0.5f * (f5 += f7);
        return fArray2;
    }

    public static final float[] div(float[] fArray, float f, float f2) {
        float[] fArray2 = new float[2];
        if (Math.abs(f) >= Math.abs(f2)) {
            float f3 = (float)(1.0 / (double)(f + f2 * (f2 / f)));
            fArray2[0] = f3 * (fArray[0] + fArray[1] * (f2 / f));
            fArray2[1] = f3 * (fArray[1] - fArray[0] * (f2 / f));
        } else {
            float f4 = (float)(1.0 / (double)(f * (f / f2) + f2));
            fArray2[0] = f4 * (fArray[0] * (f / f2) + fArray[1]);
            fArray2[1] = f4 * (fArray[1] * (f / f2) - fArray[0]);
        }
        return fArray2;
    }

    public static final float[] div(float[] fArray, float[] fArray2) {
        return FComplex.div(fArray, fArray2[0], fArray2[1]);
    }

    public static final float equals(float[] fArray, float[] fArray2, float f) {
        if (FComplex.abs(fArray[0] - fArray2[0], fArray[1] - fArray2[1]) <= Math.abs(f)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static final boolean isEqual(float[] fArray, float[] fArray2, float f) {
        return FComplex.abs(fArray[0] - fArray2[0], fArray[1] - fArray2[1]) <= Math.abs(f);
    }

    public static final float[] exp(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = (float)Math.exp(fArray[0]);
        fArray2[0] = (float)((double)f * Math.cos(fArray[1]));
        fArray2[1] = (float)((double)f * Math.sin(fArray[1]));
        return fArray2;
    }

    public static final float[] inv(float[] fArray) {
        float[] fArray2 = new float[2];
        if ((double)fArray[1] != 0.0) {
            if (Math.abs(fArray[0]) >= Math.abs(fArray[1])) {
                float f;
                fArray2[0] = f = (float)(1.0 / (double)(fArray[0] + fArray[1] * (fArray[1] / fArray[0])));
                fArray2[1] = f * (-fArray[1] / fArray[0]);
            } else {
                float f = (float)(1.0 / (double)(fArray[0] * (fArray[0] / fArray[1]) + fArray[1]));
                fArray2[0] = f * (fArray[0] / fArray[1]);
                fArray2[1] = -f;
            }
        } else {
            fArray2[0] = 1.0f / fArray[0];
            fArray2[1] = 0.0f;
        }
        return fArray2;
    }

    public static final float[] log(float[] fArray) {
        float[] fArray2 = new float[]{(float)Math.log(FComplex.abs(fArray)), FComplex.arg(fArray)};
        return fArray2;
    }

    public static final float[] minus(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[0] - fArray2[0], fArray[1] - fArray2[1]};
        return fArray3;
    }

    public static final float[] minusAbs(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{Math.abs(fArray[0] - fArray2[0]), Math.abs(fArray[1] - fArray2[1])};
        return fArray3;
    }

    public static final float[] mult(float[] fArray, float f) {
        float[] fArray2 = new float[]{fArray[0] * f, fArray[1] * f};
        return fArray2;
    }

    public static final float[] mult(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[0] * fArray2[0] - fArray[1] * fArray2[1], fArray[1] * fArray2[0] + fArray[0] * fArray2[1]};
        return fArray3;
    }

    public static final float[] neg(float[] fArray) {
        float[] fArray2 = new float[]{-fArray[0], -fArray[1]};
        return fArray2;
    }

    public static final float[] plus(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray[0] + fArray2[0], fArray[1] + fArray2[1]};
        return fArray3;
    }

    public static final float[] pow(float[] fArray, float f) {
        float[] fArray2 = new float[2];
        float f2 = (float)((double)f * Math.log(FComplex.abs(fArray)));
        float f3 = f * FComplex.arg(fArray);
        float f4 = (float)Math.exp(f2);
        fArray2[0] = (float)((double)f4 * Math.cos(f3));
        fArray2[1] = (float)((double)f4 * Math.sin(f3));
        return fArray2;
    }

    public static final float[] pow(float f, float[] fArray) {
        float[] fArray2 = new float[2];
        float f2 = (float)Math.log(Math.abs(f));
        float f3 = (float)Math.atan2(0.0, f);
        float f4 = f2 * fArray[0] - f3 * fArray[1];
        float f5 = f2 * fArray[1] + f3 * fArray[0];
        float f6 = (float)Math.exp(f4);
        fArray2[0] = (float)((double)f6 * Math.cos(f5));
        fArray2[1] = (float)((double)f6 * Math.sin(f5));
        return fArray2;
    }

    public static final float[] pow(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[2];
        float f = (float)Math.log(FComplex.abs(fArray));
        float f2 = FComplex.arg(fArray);
        float f3 = f * fArray2[0] - f2 * fArray2[1];
        float f4 = f * fArray2[1] + f2 * fArray2[0];
        float f5 = (float)Math.exp(f3);
        fArray3[0] = (float)((double)f5 * Math.cos(f4));
        fArray3[1] = (float)((double)f5 * Math.sin(f4));
        return fArray3;
    }

    public static final float[] sin(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = -fArray[1];
        float f2 = fArray[0];
        float f3 = (float)Math.exp(f);
        float f4 = (float)((double)f3 * Math.cos(f2));
        float f5 = (float)((double)f3 * Math.sin(f2));
        f3 = (float)Math.exp(-f);
        float f6 = (float)((double)f3 * Math.cos(-f2));
        float f7 = (float)((double)f3 * Math.sin(-f2));
        fArray2[0] = 0.5f * (f5 -= f7);
        fArray2[1] = -0.5f * (f4 -= f6);
        return fArray2;
    }

    public static final float[] sqrt(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = FComplex.abs(fArray);
        if ((double)f > 0.0) {
            if ((double)fArray[0] > 0.0) {
                float f2;
                fArray2[0] = f2 = (float)Math.sqrt(0.5 * (double)(f + fArray[0]));
                fArray2[1] = 0.5f * (fArray[1] / f2);
            } else {
                float f3 = (float)Math.sqrt(0.5 * (double)(f - fArray[0]));
                if ((double)fArray[1] < 0.0) {
                    f3 = -f3;
                }
                fArray2[0] = 0.5f * (fArray[1] / f3);
                fArray2[1] = f3;
            }
        } else {
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
        }
        return fArray2;
    }

    public static final float[] square(float[] fArray) {
        return FComplex.mult(fArray, fArray);
    }

    public static final float[] tan(float[] fArray) {
        float[] fArray2 = new float[2];
        float f = -fArray[1];
        float f2 = fArray[0];
        float f3 = (float)Math.exp(f);
        float f4 = (float)((double)f3 * Math.cos(f2));
        float f5 = (float)((double)f3 * Math.sin(f2));
        f3 = (float)Math.exp(-f);
        float f6 = (float)((double)f3 * Math.cos(-f2));
        float f7 = (float)((double)f3 * Math.sin(-f2));
        float f8 = f4 - f6;
        float f9 = f5 - f7;
        fArray2[0] = 0.5f * f9;
        fArray2[1] = -0.5f * f8;
        f8 = f4 + f6;
        f9 = f5 + f7;
        float f10 = 0.5f * f8;
        float f11 = 0.5f * f9;
        fArray2 = FComplex.div(fArray2, f10, f11);
        return fArray2;
    }

    protected FComplex() {
    }
}

