/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.EdgeReversedGraph;

public class StrongConnectivityInspector<V, E> {
    private final DirectedGraph<V, E> graph;
    private LinkedList<VertexData<V>> orderedVertices;
    private List<Set<V>> stronglyConnectedSets;
    private List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs;
    private Map<V, VertexData<V>> vertexToVertexData;

    public StrongConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.graph = directedGraph;
        this.vertexToVertexData = null;
        this.orderedVertices = null;
        this.stronglyConnectedSets = null;
        this.stronglyConnectedSubgraphs = null;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List<Set<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            this.orderedVertices = new LinkedList();
            this.stronglyConnectedSets = new Vector<Set<V>>();
            this.createVertexData();
            for (VertexData<V> vertexData : this.vertexToVertexData.values()) {
                if (((VertexData)vertexData).isDiscovered()) continue;
                this.dfsVisit(this.graph, vertexData, null);
            }
            EdgeReversedGraph<V, E> edgeReversedGraph = new EdgeReversedGraph<V, E>(this.graph);
            this.resetVertexData();
            for (VertexData vertexData : this.orderedVertices) {
                if (vertexData.isDiscovered()) continue;
                HashSet hashSet = new HashSet();
                this.stronglyConnectedSets.add(hashSet);
                this.dfsVisit(edgeReversedGraph, vertexData, hashSet);
            }
            this.orderedVertices = null;
            this.vertexToVertexData = null;
        }
        return this.stronglyConnectedSets;
    }

    public List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs() {
        if (this.stronglyConnectedSubgraphs == null) {
            List<Set<V>> list = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new Vector<DirectedSubgraph<V, E>>(list.size());
            for (Set<V> set : list) {
                this.stronglyConnectedSubgraphs.add(new DirectedSubgraph<V, E>(this.graph, set, null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    private void createVertexData() {
        this.vertexToVertexData = new HashMap<V, VertexData<V>>(this.graph.vertexSet().size());
        for (Object v : this.graph.vertexSet()) {
            this.vertexToVertexData.put(v, new VertexData2(v, false, false));
        }
    }

    private void dfsVisit(DirectedGraph<V, E> directedGraph, VertexData<V> vertexData, Set<V> set) {
        ArrayDeque<VertexData<V>> arrayDeque = new ArrayDeque<VertexData<V>>();
        arrayDeque.add(vertexData);
        while (!arrayDeque.isEmpty()) {
            VertexData vertexData2 = (VertexData)arrayDeque.removeLast();
            if (!vertexData2.isDiscovered()) {
                vertexData2.setDiscovered(true);
                if (set != null) {
                    set.add(vertexData2.getVertex());
                }
                arrayDeque.add(new VertexData1(vertexData2, true, true));
                for (E e : directedGraph.outgoingEdgesOf(vertexData2.getVertex())) {
                    VertexData<V> vertexData3 = this.vertexToVertexData.get(directedGraph.getEdgeTarget(e));
                    if (((VertexData)vertexData3).isDiscovered()) continue;
                    arrayDeque.add(vertexData3);
                }
                continue;
            }
            if (!vertexData2.isFinished() || set != null) continue;
            this.orderedVertices.addFirst(vertexData2.getFinishedData());
        }
    }

    private void resetVertexData() {
        for (VertexData<V> vertexData : this.vertexToVertexData.values()) {
            ((VertexData)vertexData).setDiscovered(false);
            ((VertexData)vertexData).setFinished(false);
        }
    }

    private static final class VertexData2<V>
    extends VertexData<V> {
        private final V vertex;

        private VertexData2(V v, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.vertex = v;
        }

        @Override
        VertexData<V> getFinishedData() {
            return null;
        }

        @Override
        V getVertex() {
            return this.vertex;
        }
    }

    private static final class VertexData1<V>
    extends VertexData<V> {
        private final VertexData<V> finishedData;

        private VertexData1(VertexData<V> vertexData, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.finishedData = vertexData;
        }

        @Override
        VertexData<V> getFinishedData() {
            return this.finishedData;
        }

        @Override
        V getVertex() {
            return null;
        }
    }

    private static abstract class VertexData<V> {
        private byte bitfield = 0;

        private VertexData(boolean bl, boolean bl2) {
            this.setDiscovered(bl);
            this.setFinished(bl2);
        }

        private boolean isDiscovered() {
            return (this.bitfield & 1) == 1;
        }

        private boolean isFinished() {
            return (this.bitfield & 2) == 2;
        }

        private void setDiscovered(boolean bl) {
            this.bitfield = bl ? (byte)(this.bitfield | 1) : (byte)(this.bitfield & 0xFFFFFFFE);
        }

        private void setFinished(boolean bl) {
            this.bitfield = bl ? (byte)(this.bitfield | 2) : (byte)(this.bitfield & 0xFFFFFFFD);
        }

        abstract VertexData<V> getFinishedData();

        abstract V getVertex();
    }
}

