/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.operators.ExchangeOperator;
import dr.evomodel.operators.FNPR;
import dr.evomodel.operators.NNI;
import dr.evomodel.operators.SubtreeSlideOperator;
import dr.evomodel.operators.WilsonBalding;
import dr.evomodel.tree.ConditionalCladeFrequency;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.MathUtils;
import java.util.ArrayList;

@Deprecated
public class ImportancePruneAndRegraft
extends AbstractTreeOperator {
    public final int SAMPLE_EVERY = 10;
    private final TreeModel tree;
    private final int samples;
    private int sampleCount;
    private boolean burnin = false;
    private final ConditionalCladeFrequency probabilityEstimater;
    private final OperatorSchedule schedule;

    public ImportancePruneAndRegraft(TreeModel treeModel, double d, int n, int n2) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = n;
        this.sampleCount = 0;
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, n2);
        this.schedule = this.getOperatorSchedule(treeModel);
    }

    public ImportancePruneAndRegraft(TreeModel treeModel, double d, int n) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = n;
        this.sampleCount = 0;
        double d2 = 1.0 - Math.pow(0.5, 1.0 / (double)n);
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, d2);
        this.schedule = this.getOperatorSchedule(treeModel);
    }

    private OperatorSchedule getOperatorSchedule(TreeModel treeModel) {
        ExchangeOperator exchangeOperator = new ExchangeOperator(0, treeModel, 10.0);
        ExchangeOperator exchangeOperator2 = new ExchangeOperator(1, treeModel, 3.0);
        SubtreeSlideOperator subtreeSlideOperator = new SubtreeSlideOperator(treeModel, 10.0, 1.0, true, false, false, false, AdaptationMode.ADAPTATION_ON, 0.234);
        NNI nNI = new NNI(treeModel, 10.0);
        WilsonBalding wilsonBalding = new WilsonBalding(treeModel, 3.0);
        FNPR fNPR = new FNPR(treeModel, 5.0);
        SimpleOperatorSchedule simpleOperatorSchedule = new SimpleOperatorSchedule();
        simpleOperatorSchedule.addOperator(exchangeOperator);
        simpleOperatorSchedule.addOperator(exchangeOperator2);
        simpleOperatorSchedule.addOperator(subtreeSlideOperator);
        simpleOperatorSchedule.addOperator(nNI);
        simpleOperatorSchedule.addOperator(wilsonBalding);
        simpleOperatorSchedule.addOperator(fNPR);
        return simpleOperatorSchedule;
    }

    @Override
    public double doOperation() {
        if (!this.burnin) {
            if (this.sampleCount < this.samples * 10) {
                ++this.sampleCount;
                if (this.sampleCount % 10 == 0) {
                    this.probabilityEstimater.addTree(this.tree);
                }
                this.setAcceptCount(0L);
                this.setRejectCount(0L);
                this.setTransitions(0L);
                return this.doUnguidedOperation();
            }
            return this.importancePruneAndRegraft();
        }
        return this.doUnguidedOperation();
    }

    private double doUnguidedOperation() {
        int n = this.schedule.getNextOperatorIndex();
        SimpleMCMCOperator simpleMCMCOperator = (SimpleMCMCOperator)this.schedule.getOperator(n);
        return simpleMCMCOperator.doOperation();
    }

    private double importancePruneAndRegraft() {
        NodeRef nodeRef;
        NodeRef nodeRef2;
        int n;
        NodeRef nodeRef3;
        int n2 = this.tree.getNodeCount();
        NodeRef nodeRef4 = this.tree.getRoot();
        while (nodeRef4 == (nodeRef3 = this.tree.getNode(n = MathUtils.nextInt(n2))) || this.tree.getParent(nodeRef3) == nodeRef4) {
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        double d = this.tree.getNodeHeight(nodeRef5);
        double d2 = 0.0;
        double d3 = this.calculateTreeProbability(this.tree);
        int n3 = (int)(-d3);
        double d4 = Math.exp(d3 + (double)n3);
        NodeRef nodeRef6 = this.getOtherChild(this.tree, nodeRef5, nodeRef3);
        NodeRef nodeRef7 = this.tree.getParent(nodeRef5);
        this.tree.beginTreeEdit();
        for (int i = 0; i < n2; ++i) {
            nodeRef2 = this.tree.getNode(i);
            if (nodeRef2 == nodeRef4 || nodeRef5 == (nodeRef = this.tree.getParent(nodeRef2)) || !(this.tree.getNodeHeight(nodeRef2) < d) || !(d < this.tree.getNodeHeight(nodeRef))) continue;
            arrayList.add(i);
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
            double d5 = Math.exp(this.calculateTreeProbability(this.tree) + (double)n3);
            arrayList2.add(d5);
            d2 += d5;
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef6, nodeRef7);
        }
        double d6 = MathUtils.nextDouble() * d2;
        int n4 = 0;
        while (d6 > 0.0) {
            d6 -= ((Double)arrayList2.get(n4)).doubleValue();
            ++n4;
        }
        if (nodeRef5 != (nodeRef = this.tree.getParent(nodeRef2 = this.tree.getNode((Integer)arrayList.get(--n4))))) {
            this.pruneAndRegraft(this.tree, nodeRef3, nodeRef5, nodeRef2, nodeRef);
            this.tree.pushTreeChangedEvent(nodeRef3);
        }
        this.tree.endTreeEdit();
        try {
            this.tree.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.getMessage());
        }
        double d7 = (Double)arrayList2.get(n4);
        this.tree.pushTreeChangedEvent(nodeRef3);
        double d8 = d7 / d2;
        double d9 = d4 / (d2 - d7 + d4);
        double d10 = Math.log(d9 / d8);
        return d10;
    }

    private void pruneAndRegraft(TreeModel treeModel, NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) {
        NodeRef nodeRef5 = treeModel.getParent(nodeRef2);
        NodeRef nodeRef6 = this.getOtherChild(treeModel, nodeRef2, nodeRef);
        treeModel.removeChild(nodeRef2, nodeRef6);
        treeModel.removeChild(nodeRef5, nodeRef2);
        treeModel.addChild(nodeRef5, nodeRef6);
        treeModel.removeChild(nodeRef4, nodeRef3);
        treeModel.addChild(nodeRef2, nodeRef3);
        treeModel.addChild(nodeRef4, nodeRef2);
    }

    private double calculateTreeProbability(Tree tree) {
        return this.probabilityEstimater.getTreeProbability(tree);
    }

    public void setBurnin(boolean bl) {
        this.burnin = bl;
    }

    @Override
    public String getOperatorName() {
        return "ImportancePruneAndRegraft";
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

