/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel._examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.ChiSquareQF;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.search.SDSimpleTask;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class SDSimpleTaskRunnerExample {
    private SDSimpleTaskRunnerExample() {
    }

    public static void main(String[] args) throws IOException {
        Ontology onto = DataFactory.createOntology(new File("../org.vikamine.kernel.test/resources/datasets/adults.arff"));
        System.out.println("Attributes in dataset: " + onto.getNumAttributes());
        System.out.println("Instances in dataset: " + onto.getNumInstances());
        SDSimpleTask task = new SDSimpleTask(onto);
        task.setTarget(new SelectorTarget(new DefaultSGSelector(onto, "class", ">50K")));
        ArrayList<String> attributeIDList = new ArrayList<String>();
        for (Attribute a : onto.getAttributes()) {
            attributeIDList.add(a.getId());
        }
        String[] attributeIDS = new String[]{};
        task.setIgnoreDefaultValues(false);
        task.setAttributes(attributeIDList.toArray(attributeIDS), true, 5);
        task.setQualityFunction(new ChiSquareQF());
        task.setMethodType(SDMap.class);
        task.setMaxSGDSize(3);
        task.setMaxSGCount(20);
        SGSet result = task.performSubgroupDiscovery();
        for (SG sg : result.toSortedList(false)) {
            System.out.println(sg.getSGDescription() + " - " + sg.getStatistics().getSubgroupSize() + "(" + sg.getStatistics().getDeviation() + ")");
        }
    }
}

