/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.SelectFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.PredictionResult;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.ArrayUtils;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import dmLab.utils.dataframe.DataFrame;
import java.util.Random;

public final class MCFSFinalCV {
    private int[] algorithms;
    private Random random;
    private ArrayUtils arrayUtils;
    public ConfusionMatrix[] j48ConfMatrix;
    private ConfusionMatrix j48ConfMatrixTmp;

    /*
     * WARNING - void declaration
     */
    public MCFSFinalCV(int[] algorithms, Random random) {
        void var2_2;
        void var1_1;
        this.algorithms = var1_1;
        this.random = random;
        this.arrayUtils = new ArrayUtils((Random)var2_2);
    }

    public final DataFrame run(FArray array, AttributesRI importances, int[] size, int cvFolds, int setSize, int repetitions) {
        this.j48ConfMatrix = new ConfusionMatrix[size.length];
        if (((Array)array).rowsNumber() <= setSize) {
            repetitions = 1;
        }
        DataFrame result_df = null;
        for (int i = 0; i < size.length; ++i) {
            int currSize = size[i];
            if (currSize <= 0) continue;
            Object object = array;
            if (currSize >= ((Array)object).attributes.length) continue;
            int[] colIdx = SelectFunctions.getColumnsIdx$e342baa(array, importances, currSize);
            int[] rowIdx = ArrayUtils.seq(0, ((Array)array).rowsNumber());
            DataFrame step_df = null;
            for (int j = 0; j < repetitions; ++j) {
                DataFrame dataFrame;
                Object rep_array = array.cloneByIdx(colIdx, this.arrayUtils.randomSelectValues(rowIdx, setSize));
                if (repetitions > 1) {
                    object = rep_array;
                    System.out.println("*** CV Repetition = " + (j + 1) + " [" + ((Array)rep_array).rowsNumber() + " x " + ((Array)object).attributes.length + "]");
                }
                int n = cvFolds;
                String string = Integer.toString(currSize);
                FArray fArray = rep_array;
                rep_array = this;
                this.j48ConfMatrixTmp = null;
                if (fArray.isTargetNominal()) {
                    dataFrame = new DataFrame(((MCFSFinalCV)rep_array).algorithms.length, new String[]{"label", "algorithm", "acc", "wacc"});
                    dataFrame.setColTypes(new short[]{0, 0, 1, 1});
                } else {
                    dataFrame = new DataFrame(((MCFSFinalCV)rep_array).algorithms.length, new String[]{"label", "algorithm", "pearson", "MAE", "RMSE", "SMAPE"});
                    dataFrame.setColTypes(new short[]{0, 0, 1, 1, 1, 1});
                }
                ClassificationBody classificationBody = new ClassificationBody(((MCFSFinalCV)rep_array).random);
                classificationBody.setParameters(new ClassificationParams());
                classificationBody.classParams.verbose = false;
                classificationBody.classParams.saveClassifier = false;
                classificationBody.classParams.savePredictionResult = false;
                classificationBody.classParams.folds = n;
                classificationBody.classParams.repetitions = 1;
                for (int k = 0; k < ((MCFSFinalCV)rep_array).algorithms.length; ++k) {
                    classificationBody.classParams.model = ((MCFSFinalCV)rep_array).algorithms[k];
                    classificationBody.initClassifier();
                    if (k == 0) {
                        System.out.print("Evaluating model performance using " + n + " fold CV. Model: " + Classifier.int2label(((MCFSFinalCV)rep_array).algorithms[k]));
                    } else {
                        System.out.print(", " + Classifier.int2label(((MCFSFinalCV)rep_array).algorithms[k]));
                    }
                    object = classificationBody.runCV(fArray);
                    dataFrame.set(k, 0, string);
                    dataFrame.set(k, 1, Classifier.int2label(((MCFSFinalCV)rep_array).algorithms[k]));
                    if (fArray.isTargetNominal()) {
                        object = ((PredictionResult)object).confusionMatrix;
                        if (((MCFSFinalCV)rep_array).algorithms[k] == Classifier.J48) {
                            ((MCFSFinalCV)rep_array).j48ConfMatrixTmp = object;
                        }
                        dataFrame.set(k, 2, Float.valueOf(((ConfusionMatrix)object).calcMeasure(QualityMeasure.ACC)));
                        dataFrame.set(k, 3, Float.valueOf(((ConfusionMatrix)object).calcMeasure(QualityMeasure.WACC)));
                        continue;
                    }
                    dataFrame.set(k, 2, Float.valueOf((float)((PredictionResult)object).getPredQuality(QualityMeasure.PEARSON)));
                    dataFrame.set(k, 3, Float.valueOf((float)((PredictionResult)object).getPredQuality(QualityMeasure.MAE)));
                    dataFrame.set(k, 4, Float.valueOf((float)((PredictionResult)object).getPredQuality(QualityMeasure.RMSE)));
                    dataFrame.set(k, 5, Float.valueOf((float)((PredictionResult)object).getPredQuality(QualityMeasure.SMAPE)));
                }
                System.out.println();
                DataFrame rep_df = dataFrame;
                this.j48ConfMatrix[i] = this.j48ConfMatrixTmp;
                if (step_df == null) {
                    step_df = rep_df;
                    continue;
                }
                step_df.mathOperation(rep_df, "+");
            }
            step_df.mathOperation(repetitions, "/");
            if (result_df == null) {
                result_df = step_df;
                continue;
            }
            result_df.rbind(step_df);
        }
        this.j48ConfMatrixTmp = null;
        return result_df;
    }
}

