/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import kafka.common.Config;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.producer.ProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ProducerConfig$
implements Config,
ScalaObject {
    public static final ProducerConfig$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ProducerConfig$();
    }

    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ProducerConfig$ producerConfig$ = this;
        synchronized (producerConfig$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public void validate(ProducerConfig config) {
        this.validateClientId(config.clientId());
        this.validateBatchSize(config.batchNumMessages(), config.queueBufferingMaxMessages());
        this.validateProducerType(config.producerType());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateBatchSize(int batchSize, int queueSize) {
        if (batchSize > queueSize) {
            throw new InvalidConfigException(new StringBuilder().append((Object)"Batch size = ").append(BoxesRunTime.boxToInteger(batchSize)).append((Object)" can't be larger than queue size = ").append(BoxesRunTime.boxToInteger(queueSize)).toString());
        }
    }

    public void validateProducerType(String producerType) {
        block3: {
            block2: {
                String string2;
                String string3 = string2 = producerType;
                String string4 = "sync";
                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block2;
                String string5 = string2;
                String string6 = "async";
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block3;
            }
            return;
        }
        throw new InvalidConfigException(new StringBuilder().append((Object)"Invalid value ").append((Object)producerType).append((Object)" for producer.type, valid values are sync/async").toString());
    }

    private ProducerConfig$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
    }
}

