/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import io.github.geniot.indexedtreemap.IndexedTreeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Swap;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.neighborhood.Neighborhoods;
import org.flsgen.grid.regular.square.PartialRegularSquareGrid;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeStructure;
import org.flsgen.solver.Terrain;

public class LandscapeGenerator {
    public static final int NODATA = -1;
    NeighborhoodSelectionStrategy[] STRATEGIES = new NeighborhoodSelectionStrategy[]{NeighborhoodSelectionStrategy.FROM_ALL, NeighborhoodSelectionStrategy.FROM_LAST_POSSIBLE};
    NeighborhoodSelectionStrategy[] STRATEGIES_ALL = new NeighborhoodSelectionStrategy[]{NeighborhoodSelectionStrategy.FROM_ALL, NeighborhoodSelectionStrategy.FROM_LAST_POSSIBLE, NeighborhoodSelectionStrategy.RANDOM};
    protected LandscapeStructure structure;
    protected Terrain terrain;
    protected RegularSquareGrid grid;
    protected int nbClasses;
    protected INeighborhood neighborhood;
    protected INeighborhood bufferNeighborhood;
    protected int[] rasterGrid;
    protected boolean[][] bufferGrid;
    protected int[][] neighbors;
    protected int nbAvailableCells;
    protected ISet[] avalaibleCells;
    protected int nbTry;

    public LandscapeGenerator(LandscapeStructure structure, int neighborhood, int bufferWidth, Terrain terrain) throws FlsgenException {
        this(structure, Neighborhoods.resolveNeighborhood(structure.grid, neighborhood, 1), Neighborhoods.resolveNeighborhood(structure.grid, neighborhood, bufferWidth), terrain);
    }

    public LandscapeGenerator(LandscapeStructure structure, int neighborhood, int minBufferWidth, int maxBufferWidth, Terrain terrain) throws FlsgenException {
        this(structure, Neighborhoods.resolveNeighborhood(structure.grid, neighborhood, 1), Neighborhoods.resolveNeighborhood(structure.grid, neighborhood, minBufferWidth, maxBufferWidth), terrain);
    }

    public LandscapeGenerator(LandscapeStructure structure, INeighborhood neighborhood, INeighborhood bufferNeighborhood, Terrain terrain) {
        this.structure = structure;
        this.grid = structure.grid;
        this.nbClasses = structure.names.length;
        this.terrain = terrain;
        this.neighborhood = neighborhood;
        this.bufferNeighborhood = bufferNeighborhood;
        this.neighbors = new int[this.grid.getNbCells()][];
        for (int i = 0; i < this.grid.getNbCells(); ++i) {
            this.neighbors[i] = neighborhood.getNeighbors(this.grid, i);
        }
        this.init();
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public int getNbTry() {
        return this.nbTry;
    }

    public RegularSquareGrid getGrid() {
        return this.grid;
    }

    public int[] getRasterGrid() {
        return this.rasterGrid;
    }

    public void init() {
        int i;
        this.rasterGrid = new int[this.grid.getNbCells()];
        this.bufferGrid = new boolean[this.nbClasses][];
        this.avalaibleCells = new ISet[this.nbClasses];
        for (i = 0; i < this.nbClasses; ++i) {
            this.avalaibleCells[i] = SetFactory.makeBipartiteSet(0);
            this.bufferGrid[i] = new boolean[this.grid.getNbCells()];
        }
        for (i = 0; i < this.grid.getNbCells(); ++i) {
            this.rasterGrid[i] = -1;
            for (int j = 0; j < this.nbClasses; ++j) {
                this.avalaibleCells[j].add(i);
                this.bufferGrid[j][i] = false;
            }
        }
        this.nbAvailableCells = this.grid.getNbCells();
    }

    public boolean generateSquarePatch(int classId, int size) throws FlsgenException {
        int i;
        if (this.avalaibleCells[classId].size() < size) {
            return false;
        }
        int[] cells = new int[size];
        int width = (int)Math.sqrt(size);
        if ((double)width * 1.0 != Math.sqrt(size)) {
            throw new FlsgenException("The patch " + classId + " of size " + size + " has not square dimensions.");
        }
        ISet accessibleCells = SetFactory.makeBipartiteSet(0);
        ISetIterator iSetIterator = this.avalaibleCells[classId].iterator();
        while (iSetIterator.hasNext()) {
            int i2 = (Integer)iSetIterator.next();
            int[] c = this.grid.getCoordinatesFromIndex(i2);
            if (c[0] >= this.grid.getNbRows() - width || c[1] >= this.grid.getNbCols() - width) continue;
            accessibleCells.add(i2);
        }
        if (accessibleCells.size() == 0) {
            return false;
        }
        cells[0] = this.getRandomCell(accessibleCells);
        int current = cells[0];
        int n = 1;
        this.rasterGrid[current] = classId;
        --this.nbAvailableCells;
        boolean success = true;
        int[] p1 = this.grid.getCoordinatesFromIndex(cells[0]);
        for (i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                if (i == 0 && j == 0) continue;
                int c = this.grid.getIndexFromCoordinates(p1[0] + i, p1[1] + j);
                if (this.rasterGrid[c] == -1 && !this.bufferGrid[classId][c]) {
                    cells[n] = c;
                    this.rasterGrid[c] = classId;
                    --this.nbAvailableCells;
                    ++n;
                    continue;
                }
                success = false;
                break;
            }
            if (!success) break;
        }
        if (success) {
            for (int i3 : cells) {
                for (int k = 0; k < this.avalaibleCells.length; ++k) {
                    this.avalaibleCells[k].remove(i3);
                }
                boolean border = false;
                for (int j : this.neighbors[i3]) {
                    if (this.rasterGrid[j] != -1) continue;
                    border = true;
                    break;
                }
                if (!border) continue;
                for (int j : this.bufferNeighborhood.getNeighbors(this.grid, i3)) {
                    if (this.rasterGrid[j] != -1 || this.bufferGrid[classId][j]) continue;
                    this.bufferGrid[classId][j] = true;
                    this.avalaibleCells[classId].remove(j);
                }
            }
        } else {
            for (i = 0; i < n; ++i) {
                this.rasterGrid[cells[i]] = -1;
                ++this.nbAvailableCells;
            }
        }
        return success;
    }

    public boolean generatePatch(int classId, int size, double terrainDependency, boolean noHole) {
        int n;
        if (this.avalaibleCells[classId].size() < size) {
            return false;
        }
        int[] cells = new int[size];
        cells[0] = this.getRandomCell(this.avalaibleCells[classId]);
        int current = cells[0];
        this.rasterGrid[current] = classId;
        --this.nbAvailableCells;
        boolean success = true;
        NeighborhoodSelectionStrategy strategy = NeighborhoodSelectionStrategy.FROM_ALL;
        IndexedTreeSet<Integer> neigh = this.grid instanceof PartialRegularSquareGrid ? new IndexedTreeSet<Integer>((t1, t2) -> {
            int tt2;
            int tt1 = ((PartialRegularSquareGrid)this.grid).getCompleteIndex((int)t1);
            if (this.terrain.dem[tt1] == this.terrain.dem[tt2 = ((PartialRegularSquareGrid)this.grid).getCompleteIndex((int)t2)]) {
                return tt1 - tt2;
            }
            if (this.terrain.dem[tt1] <= this.terrain.dem[tt2]) {
                return -1;
            }
            return 1;
        }) : new IndexedTreeSet((t1, t2) -> {
            if (this.terrain.dem[t1] == this.terrain.dem[t2]) {
                return t1 - t2;
            }
            if (this.terrain.dem[t1] <= this.terrain.dem[t2]) {
                return -1;
            }
            return 1;
        });
        for (n = 1; n < size; ++n) {
            int next = this.findNext(classId, n, cells, terrainDependency, noHole, strategy, neigh);
            if (next != -1) continue;
            success = false;
            break;
        }
        if (success) {
            for (int i : cells) {
                for (int k = 0; k < this.avalaibleCells.length; ++k) {
                    this.avalaibleCells[k].remove(i);
                }
                boolean border = false;
                for (int j : this.neighbors[i]) {
                    if (this.rasterGrid[j] != -1) continue;
                    border = true;
                    break;
                }
                if (!border) continue;
                for (int j : this.bufferNeighborhood.getNeighbors(this.grid, i)) {
                    if (this.rasterGrid[j] != -1 || this.bufferGrid[classId][j]) continue;
                    this.bufferGrid[classId][j] = true;
                    this.avalaibleCells[classId].remove(j);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.rasterGrid[cells[i]] = -1;
                ++this.nbAvailableCells;
            }
        }
        return success;
    }

    public void filterHoles(int classId, List<Integer> neigh) {
        ISet toRemove = SetFactory.makeBipartiteSet(0);
        for (int i = 0; i < neigh.size(); ++i) {
            this.rasterGrid[neigh.get((int)i).intValue()] = classId;
            --this.nbAvailableCells;
            if (!this.assertNoHole()) {
                toRemove.add(neigh.get(i));
            }
            this.rasterGrid[neigh.get((int)i).intValue()] = -1;
            ++this.nbAvailableCells;
        }
        ISetIterator iSetIterator = toRemove.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            neigh.remove(new Integer(i));
        }
    }

    public int findNext(int classId, int n, int[] cells, double terrainDependency, boolean noHole, NeighborhoodSelectionStrategy strategy, IndexedTreeSet<Integer> neigh) {
        switch (strategy) {
            case FROM_ALL: {
                return this.findNextFromAll(classId, n, cells, terrainDependency, noHole, neigh);
            }
            case FROM_LAST_POSSIBLE: {
                return this.findNextFromLastPossibleCell(classId, n, cells, noHole);
            }
            case RANDOM: {
                int strat = ThreadLocalRandom.current().nextInt(0, this.STRATEGIES.length);
                return this.findNext(classId, n, cells, terrainDependency, noHole, this.STRATEGIES[strat], neigh);
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean assertNoHole() {
        if (this.nbAvailableCells == 0) {
            return true;
        }
        int nbCells = this.grid.getNbCells();
        boolean[] visited = new boolean[nbCells];
        int[] queue = new int[nbCells];
        int front = 0;
        int rear = 0;
        int nbVisited = 0;
        int current = -1;
        for (int i = 0; i < nbCells; ++i) {
            if (this.rasterGrid[i] != -1) continue;
            current = i;
            break;
        }
        int nbOut = this.nbAvailableCells;
        visited[current] = true;
        queue[front] = current;
        ++rear;
        ++nbVisited;
        while (front != rear) {
            current = queue[front++];
            for (int i : this.neighbors[current]) {
                if (this.rasterGrid[i] != -1 || visited[i]) continue;
                queue[rear++] = i;
                visited[i] = true;
                ++nbVisited;
            }
        }
        return nbVisited == nbOut;
    }

    public int findNextFromAll(int classId, int n, int[] cells, double terrainDependency, boolean noHole, IndexedTreeSet<Integer> neigh) {
        for (int j : this.neighbors[cells[n - 1]]) {
            if (this.rasterGrid[j] != -1 || this.bufferGrid[classId][j]) continue;
            neigh.add(j);
        }
        if (neigh.size() == 0) {
            return -1;
        }
        int next = -1;
        if (noHole) {
            boolean ok = false;
            while (!ok && neigh.size() > 0) {
                int minIdx = 0;
                int maxIdx = (int)Math.round((double)neigh.size() * (1.0 - terrainDependency));
                maxIdx = maxIdx > 0 ? maxIdx : 1;
                int idx = this.randomInt(minIdx, maxIdx);
                next = neigh.exact(idx);
                this.rasterGrid[next] = classId;
                --this.nbAvailableCells;
                if (this.assertNoHole()) {
                    cells[n] = next;
                    ok = true;
                    continue;
                }
                this.rasterGrid[next] = -1;
                ++this.nbAvailableCells;
                neigh.remove(idx);
                next = -1;
            }
        } else {
            int minIdx = 0;
            int maxIdx = (int)Math.round((double)neigh.size() * (1.0 - terrainDependency));
            maxIdx = maxIdx > 0 ? maxIdx : 1;
            int idx = minIdx == maxIdx ? minIdx : this.randomInt(minIdx, maxIdx);
            cells[n] = next = neigh.exact(idx).intValue();
            this.rasterGrid[next] = classId;
            --this.nbAvailableCells;
        }
        neigh.remove(next);
        return next;
    }

    public int findNextFromLastPossibleCell(int classId, int n, int[] cells, boolean noHole) {
        ArrayList<Integer> neigh = new ArrayList<Integer>();
        for (int i = n - 1; i >= 0; --i) {
            int next;
            for (int j : this.neighbors[cells[i]]) {
                if (this.rasterGrid[j] != -1 || this.bufferGrid[classId][j]) continue;
                neigh.add(j);
            }
            if (noHole) {
                this.filterHoles(classId, neigh);
            }
            if (neigh.size() <= 0) continue;
            neigh.sort((t1, t2) -> {
                if (this.terrain.dem[t1] == this.terrain.dem[t2]) {
                    return 0;
                }
                if (this.terrain.dem[t1] > this.terrain.dem[t2]) {
                    return -1;
                }
                return 1;
            });
            cells[n] = next = ((Integer)neigh.get(neigh.size() - 1)).intValue();
            this.rasterGrid[next] = classId;
            --this.nbAvailableCells;
            return next;
        }
        return -1;
    }

    public int randomInt(int min, int max) {
        return new Random().nextInt(max - min) + min;
    }

    public int getRandomCell(ISet cells) {
        return ((Set_Swap)cells).getNth(new Random().nextInt(cells.size()));
    }

    public int[] getRasterData(int noDataValue) {
        int[] data;
        if (this.grid instanceof PartialRegularSquareGrid) {
            data = new int[this.grid.getNbCols() * this.grid.getNbRows()];
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = !((PartialRegularSquareGrid)this.grid).getDiscardSet().contains(i2) ? this.rasterGrid[((PartialRegularSquareGrid)this.grid).getPartialIndex(i2)] : noDataValue;
            }
        } else {
            data = IntStream.range(0, this.grid.getNbCells()).map(i -> this.rasterGrid[i]).toArray();
        }
        return data;
    }

    public boolean generate(double terrainDependency, int maxTry, int maxTryPatch) throws FlsgenException {
        return this.generate(terrainDependency, maxTry, maxTryPatch, true);
    }

    public boolean generate(double terrainDependency, int maxTry, int maxTryPatch, boolean verbose) throws FlsgenException {
        this.nbTry = 0;
        boolean b = false;
        block0: while (!b && this.nbTry < maxTry) {
            ++this.nbTry;
            b = true;
            for (int i = 0; i < this.structure.names.length; ++i) {
                if (verbose) {
                    System.out.println("---------------------  Generating patches for class " + this.structure.names[i] + "  ---------------------");
                }
                int nbPatches = this.structure.nbPatches[i];
                int[] sizes = this.structure.patchSizes[i];
                if (verbose) {
                    System.out.println("Number of patches = " + nbPatches);
                    System.out.println("Patch sizes = " + Arrays.toString(sizes));
                }
                for (int j = sizes.length - 1; j >= 0; --j) {
                    int k = sizes[j];
                    if (verbose) {
                        System.out.println("Generating patch of size " + k);
                    }
                    boolean patchGenerated = false;
                    for (int p = 0; p < maxTryPatch && !(patchGenerated = this.structure.isSquare[i] ? this.generateSquarePatch(i, k) : this.generatePatch(i, k, terrainDependency, false)); ++p) {
                    }
                    if (!(b &= patchGenerated)) break;
                }
                if (b) continue;
                this.init();
                continue block0;
            }
        }
        return b;
    }

    public boolean generateAlt(double terrainDependency, int maxTry, int maxTryPatch) {
        this.nbTry = 0;
        boolean b = false;
        block0: while (!b && this.nbTry < maxTry) {
            ++this.nbTry;
            b = true;
            HashMap patches = new HashMap();
            for (int i = 0; i < this.structure.names.length; ++i) {
                ArrayList<Integer> cls = new ArrayList<Integer>();
                for (int j : this.structure.patchSizes[i]) {
                    cls.add(j);
                }
                Collections.shuffle(cls);
                patches.put(i, cls);
            }
            int c = 0;
            while (!patches.isEmpty()) {
                Random rand = new Random(System.currentTimeMillis());
                int i = patches.keySet().stream().mapToInt(v -> v).toArray()[c];
                boolean patchGenerated = false;
                int k = (Integer)((List)patches.get(i)).remove(((List)patches.get(i)).size() - 1);
                System.out.println("Generate patch of class " + i + " of size " + k);
                for (int p = 0; p < maxTryPatch && !(patchGenerated = this.generatePatch(i, k, terrainDependency, false)); ++p) {
                }
                if (!(b &= patchGenerated)) {
                    this.init();
                    continue block0;
                }
                if (((List)patches.get(i)).size() == 0) {
                    patches.remove(i);
                }
                if (c >= patches.size() - 1) {
                    c = 0;
                    continue;
                }
                ++c;
            }
        }
        return b;
    }

    public static enum NeighborhoodSelectionStrategy {
        FROM_ALL,
        FROM_LAST_POSSIBLE,
        RANDOM;

    }
}

