/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph.undirected;

import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.delta.GraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.UndirectedGraphView;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class EdgeInducedSubgraphView
extends UndirectedGraphView<UndirectedGraphVar> {
    protected UndirectedGraph lb;
    protected UndirectedGraph ub;
    protected UndirectedGraphVar graphVar;
    protected boolean exclude;
    protected ISet enforceNodes;
    protected ISet LBnodes;
    protected ISet[] edges;

    public EdgeInducedSubgraphView(String name, UndirectedGraphVar graphVar, int[][] edges, boolean exclude) {
        super(name, (Variable[])new UndirectedGraphVar[]{graphVar});
        this.exclude = exclude;
        this.graphVar = graphVar;
        this.edges = UndirectedGraph.edgesArrayToEdgesSets(this.getNbMaxNodes(), edges);
        this.enforceNodes = SetFactory.makeStoredSet(SetType.BITSET, 0, this.getModel());
        this.lb = GraphFactory.makeEdgeInducedSubgraph(this.getModel(), (UndirectedGraph)graphVar.getLB(), (UndirectedGraph)graphVar.getUB(), edges, exclude);
        this.ub = GraphFactory.makeEdgeInducedSubgraph(this.getModel(), (UndirectedGraph)graphVar.getUB(), (UndirectedGraph)graphVar.getUB(), edges, exclude);
        this.LBnodes = new SetUnion(this.getModel(), this.lb.getNodes(), this.enforceNodes);
    }

    @Override
    public ISet getMandatoryNodes() {
        return this.LBnodes;
    }

    @Override
    public UndirectedGraph getLB() {
        return this.lb;
    }

    @Override
    public UndirectedGraph getUB() {
        return this.ub;
    }

    @Override
    public int getNbMaxNodes() {
        return this.graphVar.getNbMaxNodes();
    }

    @Override
    public boolean isDirected() {
        return this.graphVar.isDirected();
    }

    @Override
    protected boolean doRemoveNode(int node) throws ContradictionException {
        ISetIterator iSetIterator = this.getPotentialNeighborsOf(node).iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.doRemoveEdge(node, i);
        }
        return !this.getPotentialNodes().contains(node);
    }

    @Override
    protected boolean doEnforceNode(int node) throws ContradictionException {
        boolean b = this.graphVar.enforceNode(node, this);
        if (!this.getLB().getNodes().contains(node)) {
            ISet potNeigh = this.getPotentialNeighborsOf(node);
            if (potNeigh.size() == 1) {
                b = this.graphVar.enforceEdge(node, potNeigh.newIterator().nextInt(), this) || b;
            } else {
                this.enforceNodes.add(node);
            }
        }
        return b;
    }

    @Override
    protected boolean doRemoveEdge(int from, int to) throws ContradictionException {
        return this.graphVar.removeEdge(from, to, this);
    }

    @Override
    protected boolean doEnforceEdge(int from, int to) throws ContradictionException {
        return this.graphVar.enforceEdge(from, to, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if ((event.getMask() & GraphEventType.ADD_EDGE.getMask()) > 0) {
            this.notifyPropagators(GraphEventType.ADD_NODE, this);
        }
        if ((event.getMask() & GraphEventType.REMOVE_EDGE.getMask()) > 0) {
            ISetIterator iSetIterator = this.enforceNodes.iterator();
            while (iSetIterator.hasNext()) {
                int node = (Integer)iSetIterator.next();
                ISet potNeigh = this.getPotentialNeighborsOf(node);
                if (potNeigh.size() != 1) continue;
                this.graphVar.enforceEdge(node, potNeigh.newIterator().nextInt(), this);
                this.enforceNodes.remove(node);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, this);
        }
        this.notifyPropagators(event, this);
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        return new EdgeInducedSubgraphMonitor(this, this.graphVar.monitorDelta(propagator));
    }

    class EdgeInducedSubgraphMonitor
    extends GraphViewDeltaMonitor {
        TIntIntHashMap nodes;
        EdgeInducedSubgraphView g;
        PairProcedure filter;

        EdgeInducedSubgraphMonitor(EdgeInducedSubgraphView g, IGraphDeltaMonitor ... deltaMonitors) {
            super(deltaMonitors);
            this.g = g;
            this.nodes = new TIntIntHashMap(8);
            this.filter = (from, to) -> {
                if (g.exclude && !g.edges[from].contains(to) || !g.exclude && g.edges[from].contains(to)) {
                    if (!this.nodes.containsKey(from)) {
                        this.nodes.put(from, 1);
                    } else {
                        this.nodes.put(from, this.nodes.get(from) + 1);
                    }
                    if (!this.nodes.containsKey(to)) {
                        this.nodes.put(to, 1);
                    } else {
                        this.nodes.put(to, this.nodes.get(to) + 1);
                    }
                }
            };
        }

        @Override
        public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
            block3: {
                block2: {
                    this.nodes.clear();
                    this.deltaMonitors[0].forEachEdge(this.filter, evt == GraphEventType.ADD_NODE ? GraphEventType.ADD_EDGE : GraphEventType.REMOVE_EDGE);
                    if (evt != GraphEventType.ADD_NODE) break block2;
                    for (int node : this.nodes.keys()) {
                        if (this.nodes.get(node) != this.g.getMandatoryNeighborsOf(node).size()) continue;
                        proc.execute(node);
                    }
                    break block3;
                }
                if (evt != GraphEventType.REMOVE_NODE) break block3;
                for (int node : this.nodes.keys()) {
                    if (this.g.getPotentialNodes().contains(node)) continue;
                    proc.execute(node);
                }
            }
        }

        @Override
        public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
            this.deltaMonitors[0].forEachEdge((from, to) -> {
                if (this.g.exclude && !this.g.edges[from].contains(to) || !this.g.exclude && this.g.edges[from].contains(to)) {
                    proc.execute(from, to);
                }
            }, evt);
        }
    }
}

