/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.GraphDelta;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.scheduler.GraphEvtScheduler;
import org.chocosolver.solver.variables.view.AbstractView;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public abstract class GraphView<V extends Variable, E extends IGraph>
extends AbstractView<V>
implements GraphVar<E> {
    protected GraphView(String name, V ... variables) {
        super(name, variables);
    }

    protected abstract boolean doRemoveNode(int var1) throws ContradictionException;

    protected abstract boolean doEnforceNode(int var1) throws ContradictionException;

    protected abstract boolean doRemoveEdge(int var1, int var2) throws ContradictionException;

    protected abstract boolean doEnforceEdge(int var1, int var2) throws ContradictionException;

    @Override
    public boolean enforceNode(int node, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (node >= 0 && node < this.getNbMaxNodes());
        if (!this.getPotentialNodes().contains(node)) {
            this.contradiction(cause, "enforce node which is not in the domain");
            return false;
        }
        if (!this.getMandatoryNodes().contains(node) && this.doEnforceNode(node)) {
            this.notifyPropagators(GraphEventType.ADD_NODE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNode(int node, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (node >= 0 && node < this.getNbMaxNodes());
        if (this.getMandatoryNodes().contains(node)) {
            this.contradiction(cause, "remove mandatory node");
            return false;
        }
        if (!this.getPotentialNodes().contains(node)) {
            return false;
        }
        int succSize = this.getPotentialSuccessorsOf(node).size();
        int predSize = this.getPotentialPredecessorOf(node).size();
        if (this.doRemoveNode(node)) {
            if (succSize + predSize > 0) {
                this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean enforceEdge(int x, int y, ICause cause) throws ContradictionException {
        boolean addY;
        assert (cause != null);
        boolean addX = !this.getMandatoryNodes().contains(x);
        boolean bl = addY = !this.getMandatoryNodes().contains(y);
        if (!this.getPotentialSuccessorsOf(x).contains(y)) {
            this.contradiction(cause, "enforce edge which is not in the domain");
            return false;
        }
        if (this.doEnforceEdge(x, y)) {
            if (addX || addY) {
                this.notifyPropagators(GraphEventType.ADD_NODE, cause);
            }
            this.notifyPropagators(GraphEventType.ADD_EDGE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEdge(int x, int y, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.getMandatorySuccessorsOf(x).contains(y)) {
            this.contradiction(cause, "remove mandatory edge");
            return false;
        }
        if (this.doRemoveEdge(x, y)) {
            this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            return true;
        }
        return false;
    }

    @Override
    public void instantiateTo(IGraph value, ICause cause) throws ContradictionException {
        int i;
        for (i = 0; i < this.getNbMaxNodes(); ++i) {
            if (value.getNodes().contains(i)) {
                this.enforceNode(i, cause);
                continue;
            }
            if (!this.getUB().containsNode(i)) continue;
            this.removeNode(i, cause);
        }
        for (i = 0; i < this.getNbMaxNodes(); ++i) {
            for (int j = 0; j < this.getNbMaxNodes(); ++j) {
                if (!value.getNodes().contains(i) || !value.getNodes().contains(j)) continue;
                if (value.getSuccessorsOf(i).contains(j)) {
                    this.enforceEdge(i, j, cause);
                    continue;
                }
                if (!this.getUB().containsEdge(i, j)) continue;
                this.removeEdge(i, j, cause);
            }
        }
    }

    @Override
    public GraphDelta getDelta() {
        throw new UnsupportedOperationException("GraphView does not support getDelta()");
    }

    @Override
    public void createDelta() {
        for (Variable v : this.getVariables()) {
            v.createDelta();
        }
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public int getTypeAndKind() {
        return 132;
    }

    protected EvtScheduler createScheduler() {
        return new GraphEvtScheduler();
    }

    @Override
    public boolean isInstantiated() {
        if (this.getPotentialNodes().size() != this.getMandatoryNodes().size()) {
            return false;
        }
        ISetIterator iSetIterator = this.getUB().getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet suc = this.getPotentialSuccessorsOf(i);
            if (suc.size() == this.getLB().getSuccessorsOf(i).size()) continue;
            return false;
        }
        return true;
    }
}

