/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

@Explained
public class PropXinSHalfReif
extends Propagator<IntVar> {
    final IntVar var;
    final IntIterableRangeSet set;
    final BoolVar b;

    public PropXinSHalfReif(IntVar x, IntIterableRangeSet set, BoolVar b) {
        super((Variable[])new IntVar[]{x, b}, (Priority)PropagatorPriority.BINARY, false, true);
        this.set = set.duplicate();
        this.var = x;
        this.b = b;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return IntEventType.all();
        }
        return IntEventType.INCLOW.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.b.isInstantiatedTo(0)) {
            this.setPassive();
            return;
        }
        if (this.var.getLB() > this.set.max()) {
            this.b.setToFalse(this, this.lcg() ? Reason.r(this.var.getMinLit()) : Reason.undef());
            this.setPassive();
            return;
        }
        if (this.var.getUB() < this.set.min()) {
            this.b.setToFalse(this, this.lcg() ? Reason.r(this.var.getMaxLit()) : Reason.undef());
            this.setPassive();
            return;
        }
        if (!this.set.intersect(this.var)) {
            this.b.setToFalse(this, this.explainFalse());
            this.setPassive();
            return;
        }
        if (this.b.isInstantiatedTo(1)) {
            int vub = this.var.getUB();
            int i = this.var.getLB();
            while (i <= vub) {
                if (!this.set.contains(i)) {
                    this.var.removeValue(i, this, this.lcg() ? Reason.r(this.b.getValLit()) : Reason.undef());
                }
                i = this.var.nextValue(i);
            }
            this.setPassive();
        }
    }

    private Reason explainFalse() {
        if (this.lcg()) {
            int[] ps = new int[this.set.cardinality() + 1];
            int m = 1;
            ISetIterator iSetIterator = this.set.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                ps[m++] = this.var.getLit(i, 1);
            }
            return Reason.r(ps);
        }
        return Reason.undef();
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.b.isInstantiatedTo(1)) {
                return ESat.eval(this.set.intersect(this.var));
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

