/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleScalarValueChecker
implements RealConvergenceChecker {
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleScalarValueChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleScalarValueChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double size;
        double c;
        double p = previous.getValue();
        double difference = FastMath.abs(p - (c = current.getValue()));
        return difference <= (size = FastMath.max(FastMath.abs(p), FastMath.abs(c))) * this.relativeThreshold || difference <= this.absoluteThreshold;
    }
}

