/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondAcceptorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondDonorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.RotatableBondsCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.WeightDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.XLogPDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class RuleOfFiveDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] NAMES = new String[]{"LipinskiFailures"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#lipinskifailures", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("RuleOfFiveDescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtomContainer mol) {
        mol = RuleOfFiveDescriptor.clone((IAtomContainer)mol);
        int lipinskifailures = 0;
        XLogPDescriptor xlogP = new XLogPDescriptor();
        Object[] xlogPparams = new Object[]{this.checkAromaticity, Boolean.TRUE};
        try {
            xlogP.setParameters(xlogPparams);
            double xlogPvalue = ((DoubleResult)xlogP.calculate(mol).getValue()).doubleValue();
            HBondAcceptorCountDescriptor acc = new HBondAcceptorCountDescriptor();
            Object[] hBondparams = new Object[]{this.checkAromaticity};
            acc.setParameters(hBondparams);
            int acceptors = ((IntegerResult)acc.calculate(mol).getValue()).intValue();
            HBondDonorCountDescriptor don = new HBondDonorCountDescriptor();
            don.setParameters(hBondparams);
            int donors = ((IntegerResult)don.calculate(mol).getValue()).intValue();
            WeightDescriptor mw = new WeightDescriptor();
            Object[] mwparams = new Object[]{"*"};
            mw.setParameters(mwparams);
            double mwvalue = ((DoubleResult)mw.calculate(mol).getValue()).doubleValue();
            RotatableBondsCountDescriptor rotata = new RotatableBondsCountDescriptor();
            Object[] rotatableBondsParams = new Object[]{false, true};
            rotata.setParameters(rotatableBondsParams);
            int rotatablebonds = ((IntegerResult)rotata.calculate(mol).getValue()).intValue();
            if (xlogPvalue > 5.0) {
                ++lipinskifailures;
            }
            if (acceptors > 10) {
                ++lipinskifailures;
            }
            if (donors > 5) {
                ++lipinskifailures;
            }
            if (mwvalue > 500.0) {
                ++lipinskifailures;
            }
            if ((double)rotatablebonds > 10.0) {
                ++lipinskifailures;
            }
        }
        catch (CDKException e) {
            new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), (Exception)((Object)e));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(lipinskifailures), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    public Object getParameterType(String name) {
        return true;
    }
}

