/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.table;

import com.qarks.util.ui.swing.table.SingleObjectSortedTable;
import com.qarks.util.ui.swing.table.SingleObjectTableSorterModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;

public class SingleObjectSortedTablePanel
extends JPanel {
    protected JScrollPane mScrollPane;
    protected SingleObjectSortedTable table;
    protected SingleObjectTableSorterModel model;

    public SingleObjectSortedTablePanel() {
        this(false);
    }

    public SingleObjectSortedTablePanel(boolean bl) {
        this.table = new SingleObjectSortedTable(bl);
        this.table.setShowGrid(false);
        this.model = (SingleObjectTableSorterModel)this.table.getModel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.mScrollPane = new JScrollPane(jPanel);
        jPanel.add((Component)this.table, "Center");
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.mScrollPane.setColumnHeaderView(jTableHeader);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.mScrollPane.getVerticalScrollBar().setUnitIncrement(fontMetrics.getHeight());
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.mScrollPane, "Center");
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void setMutlipleSelection(boolean bl) {
        this.table.getSelectionModel().setSelectionMode(bl ? 1 : 0);
    }

    public JTable getTable() {
        return this.table;
    }

    public void removeSelectedRow() {
        int n = this.table.getSelectedRow();
        this.table.removeRow(n);
    }

    public void DeleteAllItems() {
        this.table.removeAllRows();
    }

    public void DeleteItem(int n) {
        this.table.removeRow(n);
    }

    public int GetItemCount() {
        return this.table.getRowCount();
    }

    public void ensureVisible(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        this.table.scrollRectToVisible(rectangle);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.table.removeMouseListener(mouseListener);
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    public void setSelectedIndex(int n) {
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }
}

