// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_ESRI_HPP
#define BOOST_GEOMETRY_PROJECTIONS_ESRI_HPP


#include <b/geometry/srs/projections/code.hpp>


namespace boost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline srs::dpar::parameters<> esri_to_parameters(int code)
    {
        using namespace srs::dpar;

        static const code_element arr[] = {
            {37001, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            {37002, srs::dpar::parameters<>(proj_longlat)(a,6378166)(b,6356784.283607107)(no_defs)},
            {37003, srs::dpar::parameters<>(proj_longlat)(a,6378150)(b,6356768.337244385)(no_defs)},
            {37004, srs::dpar::parameters<>(proj_longlat)(ellps_fschr60m)(no_defs)},
            {37005, srs::dpar::parameters<>(proj_longlat)(a,6378270)(b,6356794.343434343)(no_defs)},
            {37006, srs::dpar::parameters<>(proj_longlat)(a,6377295.664)(b,6356094.667915204)(no_defs)},
            {37007, srs::dpar::parameters<>(proj_longlat)(a,6376896)(b,6355834.846687363)(no_defs)},
            {37008, srs::dpar::parameters<>(proj_longlat)(r,6370997)(no_defs)},
            {37201, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37202, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {37203, srs::dpar::parameters<>(proj_longlat)(a,6377301.243)(b,6356100.230165384)(no_defs)},
            {37204, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37205, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37206, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37207, srs::dpar::parameters<>(proj_longlat)(ellps_fschr60m)(no_defs)},
            {37208, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37211, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37212, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37213, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37214, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37215, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37216, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37217, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37218, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37219, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37220, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {37221, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37222, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37223, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356514.999904194)(no_defs)},
            {37224, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37226, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37227, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37228, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37229, srs::dpar::parameters<>(proj_longlat)(a,6378270)(b,6356794.343434343)(no_defs)},
            {37230, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37231, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            {37232, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37233, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37234, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37235, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37237, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37238, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37239, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {37240, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37241, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37242, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37243, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {37245, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37246, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37247, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37249, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37250, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37251, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37252, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {37253, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37254, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {37255, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {37257, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {37259, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {37260, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            //{53001},
            {53002, srs::dpar::parameters<>(proj_eqc)(lat_ts,60)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53003, srs::dpar::parameters<>(proj_mill)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r_au)(r,6371000)(units_m)(no_defs)},
            {53004, srs::dpar::parameters<>(proj_merc)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53008, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53009, srs::dpar::parameters<>(proj_moll)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53010, srs::dpar::parameters<>(proj_eck6)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            //{53011},
            {53012, srs::dpar::parameters<>(proj_eck4)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            //{53013},
            //{53014},
            //{53015},
            {53016, srs::dpar::parameters<>(proj_gall)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            //{53017},
            //{53018},
            //{53019},
            {53021, srs::dpar::parameters<>(proj_poly)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            //{53022},
            //{53023},
            {53024, srs::dpar::parameters<>(proj_bonne)(lon_0,0)(lat_1,60)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53025, srs::dpar::parameters<>(proj_omerc)(lat_0,40)(lon_1,0)(lat_1,0)(lon_2,0)(lat_2,0)(k,1)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53026, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53027, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,60)(lat_2,60)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53028, srs::dpar::parameters<>(proj_cass)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53029, srs::dpar::parameters<>(proj_vandg)(lon_0,0)(x_0,0)(y_0,0)(r_au)(r,6371000)(units_m)(no_defs)},
            {53030, srs::dpar::parameters<>(proj_robin)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53031, srs::dpar::parameters<>(proj_tpeqd)(lat_1,0)(lon_1,0)(lat_2,60)(lon_2,60)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            {53032, srs::dpar::parameters<>(proj_aeqd)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r,6371000)(units_m)(no_defs)},
            //{54001},
            {54002, srs::dpar::parameters<>(proj_eqc)(lat_ts,60)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54003, srs::dpar::parameters<>(proj_mill)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r_au)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54004, srs::dpar::parameters<>(proj_merc)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54008, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54009, srs::dpar::parameters<>(proj_moll)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54010, srs::dpar::parameters<>(proj_eck6)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{54011},
            {54012, srs::dpar::parameters<>(proj_eck4)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{54013},
            //{54014},
            //{54015},
            {54016, srs::dpar::parameters<>(proj_gall)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{54017},
            //{54018},
            //{54019},
            {54021, srs::dpar::parameters<>(proj_poly)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{54022},
            //{54023},
            {54024, srs::dpar::parameters<>(proj_bonne)(lon_0,0)(lat_1,60)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54025, srs::dpar::parameters<>(proj_omerc)(lat_0,40)(lon_1,0)(lat_1,0)(lon_2,0)(lat_2,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54026, srs::dpar::parameters<>(proj_stere)(lat_0,0)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54027, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,60)(lat_2,60)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54028, srs::dpar::parameters<>(proj_cass)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54029, srs::dpar::parameters<>(proj_vandg)(lon_0,0)(x_0,0)(y_0,0)(r_au)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54030, srs::dpar::parameters<>(proj_robin)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54031, srs::dpar::parameters<>(proj_tpeqd)(lat_1,0)(lon_1,0)(lat_2,60)(lon_2,60)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {54032, srs::dpar::parameters<>(proj_aeqd)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {65061, srs::dpar::parameters<>(proj_poly)(lat_0,13.47246635277778)(lon_0,-144.7487507055556)(x_0,50000.00000000001)(y_0,50000.00000000001)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {65161, srs::dpar::parameters<>(proj_poly)(lat_0,13.47246635277778)(lon_0,-144.7487507055556)(x_0,50000)(y_0,50000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102001, srs::dpar::parameters<>(proj_aea)(lat_1,50)(lat_2,70)(lat_0,40)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102002, srs::dpar::parameters<>(proj_lcc)(lat_1,50)(lat_2,70)(lat_0,40)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102003, srs::dpar::parameters<>(proj_aea)(lat_1,29.5)(lat_2,45.5)(lat_0,37.5)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102004, srs::dpar::parameters<>(proj_lcc)(lat_1,33)(lat_2,45)(lat_0,39)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102005, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,33)(lat_2,45)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102006, srs::dpar::parameters<>(proj_aea)(lat_1,55)(lat_2,65)(lat_0,50)(lon_0,-154)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102007, srs::dpar::parameters<>(proj_aea)(lat_1,8)(lat_2,18)(lat_0,13)(lon_0,-157)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102008, srs::dpar::parameters<>(proj_aea)(lat_1,20)(lat_2,60)(lat_0,40)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102009, srs::dpar::parameters<>(proj_lcc)(lat_1,20)(lat_2,60)(lat_0,40)(lon_0,-96)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102010, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,20)(lat_2,60)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102011, srs::dpar::parameters<>(proj_sinu)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102012, srs::dpar::parameters<>(proj_lcc)(lat_1,30)(lat_2,62)(lat_0,0)(lon_0,105)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102013, srs::dpar::parameters<>(proj_aea)(lat_1,43)(lat_2,62)(lat_0,30)(lon_0,10)(x_0,0)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102014, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,62)(lat_0,30)(lon_0,10)(x_0,0)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102015, srs::dpar::parameters<>(proj_lcc)(lat_1,-5)(lat_2,-42)(lat_0,-32)(lon_0,-60)(x_0,0)(y_0,0)(ellps_aust_sa)(units_m)(no_defs)},
            {102016, srs::dpar::parameters<>(proj_aeqd)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102017, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102018, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102019, srs::dpar::parameters<>(proj_aeqd)(lat_0,-90)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102020, srs::dpar::parameters<>(proj_laea)(lat_0,-90)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102021, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102022, srs::dpar::parameters<>(proj_aea)(lat_1,20)(lat_2,-23)(lat_0,0)(lon_0,25)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102023, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,20)(lat_2,-23)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102024, srs::dpar::parameters<>(proj_lcc)(lat_1,20)(lat_2,-23)(lat_0,0)(lon_0,25)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102025, srs::dpar::parameters<>(proj_aea)(lat_1,15)(lat_2,65)(lat_0,30)(lon_0,95)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102026, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,15)(lat_2,65)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102027, srs::dpar::parameters<>(proj_lcc)(lat_1,15)(lat_2,65)(lat_0,30)(lon_0,95)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102028, srs::dpar::parameters<>(proj_aea)(lat_1,7)(lat_2,-32)(lat_0,-15)(lon_0,125)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102029, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,7)(lat_2,-32)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102030, srs::dpar::parameters<>(proj_lcc)(lat_1,7)(lat_2,-32)(lat_0,-15)(lon_0,125)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {102031, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,43)(lat_2,62)(x_0,0)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102032, srs::dpar::parameters<>(proj_eqdc)(lat_0,0)(lon_0,0)(lat_1,-5)(lat_2,-42)(x_0,0)(y_0,0)(ellps_aust_sa)(units_m)(no_defs)},
            {102033, srs::dpar::parameters<>(proj_aea)(lat_1,-5)(lat_2,-42)(lat_0,-32)(lon_0,-60)(x_0,0)(y_0,0)(ellps_aust_sa)(units_m)(no_defs)},
            {102065, srs::dpar::parameters<>(proj_krovak)(lat_0,49.5)(lon_0,24.83333333333333)(alpha,30.28813975277778)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {102066, srs::dpar::parameters<>(proj_krovak)(lat_0,49.5)(lon_0,42.5)(alpha,30.28813975277778)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(pm,-17.66666666666667)(units_m)(no_defs)},
            {102067, srs::dpar::parameters<>(proj_krovak)(lat_0,49.5)(lon_0,24.83333333333333)(alpha,30.28813975277778)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {102091, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,0.9996)(x_0,1500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102092, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9996)(x_0,2520000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102101, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,6.05625)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102102, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,8.389583333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102103, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,10.72291666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102104, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,13.22291666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102105, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,16.88958333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102106, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,20.88958333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102107, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,24.88958333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102108, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,29.05625)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102110, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,49)(lat_0,46.5)(lon_0,3)(x_0,700000)(y_0,6600000)(ellps_grs80)(units_m)(no_defs)},
            {102114, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_clrk66)(units_m)(no_defs)},
            {102115, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_clrk66)(units_m)(no_defs)},
            {102120, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.255555555556)(k,0.9996)(x_0,2546731.495961392)(y_0,-4354009.816002033)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {102121, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.255555555556)(k,0.9996)(x_0,2546731.495961392)(y_0,-4354009.816002033)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102122, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.255555555556)(k,0.9996)(x_0,2546731.496)(y_0,-4354009.816)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {102123, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.255555555556)(k,0.9996)(x_0,2546731.496)(y_0,-4354009.816)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {102132, srs::dpar::parameters<>(proj_utm)(zone,32)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102133, srs::dpar::parameters<>(proj_utm)(zone,33)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102134, srs::dpar::parameters<>(proj_utm)(zone,34)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102135, srs::dpar::parameters<>(proj_utm)(zone,35)(a,6377492.018)(b,6356173.508712696)(units_m)(no_defs)},
            {102140, srs::dpar::parameters<>(proj_tmerc)(lat_0,22.31213333333334)(lon_0,114.1785555555556)(k,1)(x_0,836694.05)(y_0,819069.8)(ellps_intl)(units_m)(no_defs)},
            {102141, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_intl)(units_m)(no_defs)},
            {102142, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_intl)(units_m)(no_defs)},
            {102151, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_bessel)(units_m)(no_defs)},
            {102152, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_bessel)(units_m)(no_defs)},
            {102153, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_bessel)(units_m)(no_defs)},
            {102154, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_bessel)(units_m)(no_defs)},
            {102155, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_bessel)(units_m)(no_defs)},
            {102156, srs::dpar::parameters<>(proj_utm)(zone,56)(ellps_bessel)(units_m)(no_defs)},
            {102160, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,200180.598)(y_0,299913.01)(ellps_intl)(units_m)(no_defs)},
            {102161, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,180.598)(y_0,-86.98999999999999)(ellps_intl)(units_m)(no_defs)},
            {102162, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(units_m)(no_defs)},
            {102163, srs::dpar::parameters<>(proj_bonne)(lon_0,-8.131906111111112)(lat_1,39.66666666666666)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {102164, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,200000)(y_0,300000)(ellps_intl)(units_m)(no_defs)},
            {102165, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,0)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {102166, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_intl)(units_m)(no_defs)},
            {102167, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {102168, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(units_m)(no_defs)},
            {102169, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {102191, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,-5.4)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102192, srs::dpar::parameters<>(proj_lcc)(lat_1,29.7)(lat_0,29.7)(lon_0,-5.4)(k_0,0.9996155960000001)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102193, srs::dpar::parameters<>(proj_lcc)(lat_1,26.1)(lat_0,26.1)(lon_0,-5.4)(k_0,0.9996)(x_0,1200000)(y_0,400000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102229, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102230, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.9999333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102241, srs::dpar::parameters<>(proj_lcc)(lat_1,40)(lat_2,41.66666666666666)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102242, srs::dpar::parameters<>(proj_lcc)(lat_1,38.33333333333334)(lat_2,39.83333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102243, srs::dpar::parameters<>(proj_lcc)(lat_1,37.06666666666667)(lat_2,38.43333333333333)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102244, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_2,37.25)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102245, srs::dpar::parameters<>(proj_lcc)(lat_1,34.03333333333333)(lat_2,35.46666666666667)(lat_0,33.5)(lon_0,-118)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102246, srs::dpar::parameters<>(proj_lcc)(lat_1,32.78333333333333)(lat_2,33.88333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102248, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102249, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102250, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.9999333333333333)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102251, srs::dpar::parameters<>(proj_lcc)(lat_1,34.93333333333333)(lat_2,36.23333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102252, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_2,34.76666666666667)(lat_0,32.66666666666666)(lon_0,-92)(x_0,400000)(y_0,400000)(ellps_grs80)(units_m)(no_defs)},
            {102253, srs::dpar::parameters<>(proj_lcc)(lat_1,39.71666666666667)(lat_2,40.78333333333333)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {102254, srs::dpar::parameters<>(proj_lcc)(lat_1,38.45)(lat_2,39.75)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {102255, srs::dpar::parameters<>(proj_lcc)(lat_1,37.23333333333333)(lat_2,38.43333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {102256, srs::dpar::parameters<>(proj_lcc)(lat_1,41.2)(lat_2,41.86666666666667)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096)(y_0,152400.3048)(ellps_grs80)(units_m)(no_defs)},
            {102257, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102258, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.9999411764705882)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102259, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.9999411764705882)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102260, srs::dpar::parameters<>(proj_lcc)(lat_1,29.58333333333333)(lat_2,30.75)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102261, srs::dpar::parameters<>(proj_tmerc)(lat_0,18.83333333333333)(lon_0,-155.5)(k,0.9999666666666667)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102262, srs::dpar::parameters<>(proj_tmerc)(lat_0,20.33333333333333)(lon_0,-156.6666666666667)(k,0.9999666666666667)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102263, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102264, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.83333333333333)(lon_0,-159.5)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102265, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.66666666666667)(lon_0,-160.1666666666667)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102266, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102267, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102268, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473684210526)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102269, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473684210526)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102270, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.9999333333333333)(x_0,800000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102271, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102272, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.9999411764705882)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102273, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.9999666666666667)(x_0,100000)(y_0,250000)(ellps_grs80)(units_m)(no_defs)},
            {102274, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.9999666666666667)(x_0,900000)(y_0,250000)(ellps_grs80)(units_m)(no_defs)},
            {102277, srs::dpar::parameters<>(proj_lcc)(lat_1,38.71666666666667)(lat_2,39.78333333333333)(lat_0,38.33333333333334)(lon_0,-98)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102278, srs::dpar::parameters<>(proj_lcc)(lat_1,37.26666666666667)(lat_2,38.56666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,400000)(y_0,400000)(ellps_grs80)(units_m)(no_defs)},
            {102279, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102280, srs::dpar::parameters<>(proj_lcc)(lat_1,36.73333333333333)(lat_2,37.93333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {102281, srs::dpar::parameters<>(proj_lcc)(lat_1,31.16666666666667)(lat_2,32.66666666666666)(lat_0,30.5)(lon_0,-92.5)(x_0,1000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102282, srs::dpar::parameters<>(proj_lcc)(lat_1,29.3)(lat_2,30.7)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102283, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102284, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.9999666666666667)(x_0,900000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102285, srs::dpar::parameters<>(proj_lcc)(lat_1,38.3)(lat_2,39.45)(lat_0,37.66666666666666)(lon_0,-77)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102286, srs::dpar::parameters<>(proj_lcc)(lat_1,41.71666666666667)(lat_2,42.68333333333333)(lat_0,41)(lon_0,-71.5)(x_0,200000)(y_0,750000)(ellps_grs80)(units_m)(no_defs)},
            {102287, srs::dpar::parameters<>(proj_lcc)(lat_1,41.28333333333333)(lat_2,41.48333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102288, srs::dpar::parameters<>(proj_lcc)(lat_1,45.48333333333333)(lat_2,47.08333333333334)(lat_0,44.78333333333333)(lon_0,-87)(x_0,8000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102289, srs::dpar::parameters<>(proj_lcc)(lat_1,44.18333333333333)(lat_2,45.7)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,6000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102290, srs::dpar::parameters<>(proj_lcc)(lat_1,42.1)(lat_2,43.66666666666666)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,4000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102291, srs::dpar::parameters<>(proj_lcc)(lat_1,47.03333333333333)(lat_2,48.63333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {102292, srs::dpar::parameters<>(proj_lcc)(lat_1,45.61666666666667)(lat_2,47.05)(lat_0,45)(lon_0,-94.25)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {102293, srs::dpar::parameters<>(proj_lcc)(lat_1,43.78333333333333)(lat_2,45.21666666666667)(lat_0,43)(lon_0,-94)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {102294, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102295, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102296, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.9999333333333333)(x_0,250000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102297, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.9999333333333333)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102298, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.9999411764705882)(x_0,850000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102300, srs::dpar::parameters<>(proj_lcc)(lat_1,45)(lat_2,49)(lat_0,44.25)(lon_0,-109.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102304, srs::dpar::parameters<>(proj_lcc)(lat_1,40)(lat_2,43)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102307, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000)(y_0,8000000)(ellps_grs80)(units_m)(no_defs)},
            {102308, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000)(y_0,6000000)(ellps_grs80)(units_m)(no_defs)},
            {102309, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000)(y_0,4000000)(ellps_grs80)(units_m)(no_defs)},
            {102310, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.9999666666666667)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102311, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102312, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.9999090909090909)(x_0,165000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102313, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102314, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.9999166666666667)(x_0,830000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102315, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102316, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,250000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102317, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102318, srs::dpar::parameters<>(proj_lcc)(lat_1,40.66666666666666)(lat_2,41.03333333333333)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102320, srs::dpar::parameters<>(proj_lcc)(lat_1,47.43333333333333)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102321, srs::dpar::parameters<>(proj_lcc)(lat_1,46.18333333333333)(lat_2,47.48333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102322, srs::dpar::parameters<>(proj_lcc)(lat_1,40.43333333333333)(lat_2,41.7)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102323, srs::dpar::parameters<>(proj_lcc)(lat_1,38.73333333333333)(lat_2,40.03333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102324, srs::dpar::parameters<>(proj_lcc)(lat_1,35.56666666666667)(lat_2,36.76666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102325, srs::dpar::parameters<>(proj_lcc)(lat_1,33.93333333333333)(lat_2,35.23333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102326, srs::dpar::parameters<>(proj_lcc)(lat_1,44.33333333333334)(lat_2,46)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102327, srs::dpar::parameters<>(proj_lcc)(lat_1,42.33333333333334)(lat_2,44)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102330, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,100000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102334, srs::dpar::parameters<>(proj_lcc)(lat_1,44.41666666666666)(lat_2,45.68333333333333)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102335, srs::dpar::parameters<>(proj_lcc)(lat_1,42.83333333333334)(lat_2,44.4)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102336, srs::dpar::parameters<>(proj_lcc)(lat_1,35.25)(lat_2,36.41666666666666)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102337, srs::dpar::parameters<>(proj_lcc)(lat_1,34.65)(lat_2,36.18333333333333)(lat_0,34)(lon_0,-101.5)(x_0,200000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {102338, srs::dpar::parameters<>(proj_lcc)(lat_1,32.13333333333333)(lat_2,33.96666666666667)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {102339, srs::dpar::parameters<>(proj_lcc)(lat_1,30.11666666666667)(lat_2,31.88333333333333)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,700000)(y_0,3000000)(ellps_grs80)(units_m)(no_defs)},
            {102340, srs::dpar::parameters<>(proj_lcc)(lat_1,28.38333333333333)(lat_2,30.28333333333334)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,4000000)(ellps_grs80)(units_m)(no_defs)},
            {102341, srs::dpar::parameters<>(proj_lcc)(lat_1,26.16666666666667)(lat_2,27.83333333333333)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000)(y_0,5000000)(ellps_grs80)(units_m)(no_defs)},
            {102342, srs::dpar::parameters<>(proj_lcc)(lat_1,40.71666666666667)(lat_2,41.78333333333333)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {102343, srs::dpar::parameters<>(proj_lcc)(lat_1,39.01666666666667)(lat_2,40.65)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {102344, srs::dpar::parameters<>(proj_lcc)(lat_1,37.21666666666667)(lat_2,38.35)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000)(y_0,3000000)(ellps_grs80)(units_m)(no_defs)},
            {102345, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.9999642857142857)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102346, srs::dpar::parameters<>(proj_lcc)(lat_1,38.03333333333333)(lat_2,39.2)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {102347, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,37.96666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {102348, srs::dpar::parameters<>(proj_lcc)(lat_1,47.5)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102349, srs::dpar::parameters<>(proj_lcc)(lat_1,45.83333333333334)(lat_2,47.33333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102350, srs::dpar::parameters<>(proj_lcc)(lat_1,39)(lat_2,40.25)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102351, srs::dpar::parameters<>(proj_lcc)(lat_1,37.48333333333333)(lat_2,38.88333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102352, srs::dpar::parameters<>(proj_lcc)(lat_1,45.56666666666667)(lat_2,46.76666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102353, srs::dpar::parameters<>(proj_lcc)(lat_1,44.25)(lat_2,45.5)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102354, srs::dpar::parameters<>(proj_lcc)(lat_1,42.73333333333333)(lat_2,44.06666666666667)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102355, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102356, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,400000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {102357, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {102358, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {102361, srs::dpar::parameters<>(proj_lcc)(lat_1,18.03333333333334)(lat_2,18.43333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,200000)(y_0,200000)(ellps_grs80)(units_m)(no_defs)},
            {102491, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,2.7)(k_0,0.999625544)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102492, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,2.7)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102581, srs::dpar::parameters<>(proj_lcc)(lat_1,49.5)(lat_0,49.5)(lon_0,2.337229166666667)(k_0,0.999877341)(x_0,600000)(y_0,1200000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102582, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,2.337229166666667)(k_0,0.99987742)(x_0,600000)(y_0,2200000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102583, srs::dpar::parameters<>(proj_lcc)(lat_1,44.1)(lat_0,44.1)(lon_0,2.337229166666667)(k_0,0.999877499)(x_0,600000)(y_0,3200000)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102584, srs::dpar::parameters<>(proj_lcc)(lat_1,42.165)(lat_0,42.165)(lon_0,2.337229166666667)(k_0,0.99994471)(x_0,234.358)(y_0,4185861.369)(a,6378249.2)(b,6356514.999904194)(units_m)(no_defs)},
            {102591, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,2.7)(k_0,0.999625544)(x_0,500135)(y_0,300090)(ellps_clrk80)(units_m)(no_defs)},
            {102592, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,2.7)(k_0,0.999625769)(x_0,500135)(y_0,300090)(ellps_clrk80)(units_m)(no_defs)},
            {102629, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102630, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.9999333333333333)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102631, srs::dpar::parameters<>(proj_omerc)(lat_0,57)(lonc,-133.6666666666667)(alpha,-36.86989764583333)(k,0.9999)(x_0,4999999.999999999)(y_0,-4999999.999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102632, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-142)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102633, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-146)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102634, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-150)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102635, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-154)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102636, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-158)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102637, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-162)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102638, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-166)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102639, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-170)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102640, srs::dpar::parameters<>(proj_lcc)(lat_1,51.83333333333334)(lat_2,53.83333333333334)(lat_0,51)(lon_0,-176)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102641, srs::dpar::parameters<>(proj_lcc)(lat_1,40)(lat_2,41.66666666666666)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102642, srs::dpar::parameters<>(proj_lcc)(lat_1,38.33333333333334)(lat_2,39.83333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102643, srs::dpar::parameters<>(proj_lcc)(lat_1,37.06666666666667)(lat_2,38.43333333333333)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102644, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_2,37.25)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102645, srs::dpar::parameters<>(proj_lcc)(lat_1,34.03333333333333)(lat_2,35.46666666666667)(lat_0,33.5)(lon_0,-118)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102646, srs::dpar::parameters<>(proj_lcc)(lat_1,32.78333333333333)(lat_2,33.88333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102648, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102649, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102650, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.9999333333333333)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102651, srs::dpar::parameters<>(proj_lcc)(lat_1,34.93333333333333)(lat_2,36.23333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,399999.9999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102652, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_2,34.76666666666667)(lat_0,32.66666666666666)(lon_0,-92)(x_0,399999.9999999999)(y_0,399999.9999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102653, srs::dpar::parameters<>(proj_lcc)(lat_1,39.71666666666667)(lat_2,40.78333333333333)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102654, srs::dpar::parameters<>(proj_lcc)(lat_1,38.45)(lat_2,39.75)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102655, srs::dpar::parameters<>(proj_lcc)(lat_1,37.23333333333333)(lat_2,38.43333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102656, srs::dpar::parameters<>(proj_lcc)(lat_1,41.2)(lat_2,41.86666666666667)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096)(y_0,152400.3048)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102657, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102658, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.9999411764705882)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102659, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.9999411764705882)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102660, srs::dpar::parameters<>(proj_lcc)(lat_1,29.58333333333333)(lat_2,30.75)(lat_0,29)(lon_0,-84.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102661, srs::dpar::parameters<>(proj_tmerc)(lat_0,18.83333333333333)(lon_0,-155.5)(k,0.9999666666666667)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102662, srs::dpar::parameters<>(proj_tmerc)(lat_0,20.33333333333333)(lon_0,-156.6666666666667)(k,0.9999666666666667)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102663, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102664, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.83333333333333)(lon_0,-159.5)(k,0.99999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102665, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.66666666666667)(lon_0,-160.1666666666667)(k,1)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102666, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102667, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102668, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473684210526)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102669, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473684210526)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102670, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.9999333333333333)(x_0,799999.9999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102671, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102672, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.9999411764705882)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102673, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.9999666666666667)(x_0,100000)(y_0,250000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102674, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.9999666666666667)(x_0,900000.0000000001)(y_0,250000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102675, srs::dpar::parameters<>(proj_lcc)(lat_1,42.06666666666667)(lat_2,43.26666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102676, srs::dpar::parameters<>(proj_lcc)(lat_1,40.61666666666667)(lat_2,41.78333333333333)(lat_0,40)(lon_0,-93.5)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102677, srs::dpar::parameters<>(proj_lcc)(lat_1,38.71666666666667)(lat_2,39.78333333333333)(lat_0,38.33333333333334)(lon_0,-98)(x_0,399999.9999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102678, srs::dpar::parameters<>(proj_lcc)(lat_1,37.26666666666667)(lat_2,38.56666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,399999.9999999999)(y_0,399999.9999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102679, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102680, srs::dpar::parameters<>(proj_lcc)(lat_1,36.73333333333333)(lat_2,37.93333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000.0000000002)(y_0,500000.0000000002)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102681, srs::dpar::parameters<>(proj_lcc)(lat_1,31.16666666666667)(lat_2,32.66666666666666)(lat_0,30.5)(lon_0,-92.5)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102682, srs::dpar::parameters<>(proj_lcc)(lat_1,29.3)(lat_2,30.7)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102683, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102684, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.9999666666666667)(x_0,900000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102685, srs::dpar::parameters<>(proj_lcc)(lat_1,38.3)(lat_2,39.45)(lat_0,37.66666666666666)(lon_0,-77)(x_0,399999.9999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102686, srs::dpar::parameters<>(proj_lcc)(lat_1,41.71666666666667)(lat_2,42.68333333333333)(lat_0,41)(lon_0,-71.5)(x_0,200000)(y_0,750000.0000000001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102687, srs::dpar::parameters<>(proj_lcc)(lat_1,41.28333333333333)(lat_2,41.48333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102688, srs::dpar::parameters<>(proj_lcc)(lat_1,45.48333333333333)(lat_2,47.08333333333334)(lat_0,44.78333333333333)(lon_0,-87)(x_0,7999999.999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102689, srs::dpar::parameters<>(proj_lcc)(lat_1,44.18333333333333)(lat_2,45.7)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,6000000.000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102690, srs::dpar::parameters<>(proj_lcc)(lat_1,42.1)(lat_2,43.66666666666666)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,4000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102691, srs::dpar::parameters<>(proj_lcc)(lat_1,47.03333333333333)(lat_2,48.63333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,799999.9999999999)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102692, srs::dpar::parameters<>(proj_lcc)(lat_1,45.61666666666667)(lat_2,47.05)(lat_0,45)(lon_0,-94.25)(x_0,799999.9999999999)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102693, srs::dpar::parameters<>(proj_lcc)(lat_1,43.78333333333333)(lat_2,45.21666666666667)(lat_0,43)(lon_0,-94)(x_0,799999.9999999999)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102694, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102695, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102696, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.9999333333333333)(x_0,250000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102697, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.9999333333333333)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102698, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.9999411764705882)(x_0,850000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102700, srs::dpar::parameters<>(proj_lcc)(lat_1,45)(lat_2,49)(lat_0,44.25)(lon_0,-109.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102704, srs::dpar::parameters<>(proj_lcc)(lat_1,40)(lat_2,43)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102707, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000)(y_0,7999999.999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102708, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000.0000000002)(y_0,6000000.000000001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102709, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,799999.9999999999)(y_0,4000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102710, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.9999666666666667)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102711, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102712, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.9999090909090909)(x_0,165000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102713, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102714, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.9999166666666667)(x_0,829999.9999999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102715, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102716, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,250000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102717, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102718, srs::dpar::parameters<>(proj_lcc)(lat_1,40.66666666666666)(lat_2,41.03333333333333)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102719, srs::dpar::parameters<>(proj_lcc)(lat_1,34.33333333333334)(lat_2,36.16666666666666)(lat_0,33.75)(lon_0,-79)(x_0,609601.2199999999)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102720, srs::dpar::parameters<>(proj_lcc)(lat_1,47.43333333333333)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-100.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102721, srs::dpar::parameters<>(proj_lcc)(lat_1,46.18333333333333)(lat_2,47.48333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102722, srs::dpar::parameters<>(proj_lcc)(lat_1,40.43333333333333)(lat_2,41.7)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102723, srs::dpar::parameters<>(proj_lcc)(lat_1,38.73333333333333)(lat_2,40.03333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102724, srs::dpar::parameters<>(proj_lcc)(lat_1,35.56666666666667)(lat_2,36.76666666666667)(lat_0,35)(lon_0,-98)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102725, srs::dpar::parameters<>(proj_lcc)(lat_1,33.93333333333333)(lat_2,35.23333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102726, srs::dpar::parameters<>(proj_lcc)(lat_1,44.33333333333334)(lat_2,46)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102727, srs::dpar::parameters<>(proj_lcc)(lat_1,42.33333333333334)(lat_2,44)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102728, srs::dpar::parameters<>(proj_lcc)(lat_1,40.88333333333333)(lat_2,41.95)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102729, srs::dpar::parameters<>(proj_lcc)(lat_1,39.93333333333333)(lat_2,40.96666666666667)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102730, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,100000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102733, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_2,34.83333333333334)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102734, srs::dpar::parameters<>(proj_lcc)(lat_1,44.41666666666666)(lat_2,45.68333333333333)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102735, srs::dpar::parameters<>(proj_lcc)(lat_1,42.83333333333334)(lat_2,44.4)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102736, srs::dpar::parameters<>(proj_lcc)(lat_1,35.25)(lat_2,36.41666666666666)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102737, srs::dpar::parameters<>(proj_lcc)(lat_1,34.65)(lat_2,36.18333333333333)(lat_0,34)(lon_0,-101.5)(x_0,200000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102738, srs::dpar::parameters<>(proj_lcc)(lat_1,32.13333333333333)(lat_2,33.96666666666667)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000.0000000001)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102739, srs::dpar::parameters<>(proj_lcc)(lat_1,30.11666666666667)(lat_2,31.88333333333333)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,700000)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102740, srs::dpar::parameters<>(proj_lcc)(lat_1,28.38333333333333)(lat_2,30.28333333333334)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000.0000000001)(y_0,4000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102741, srs::dpar::parameters<>(proj_lcc)(lat_1,26.16666666666667)(lat_2,27.83333333333333)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000)(y_0,4999999.999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102742, srs::dpar::parameters<>(proj_lcc)(lat_1,40.71666666666667)(lat_2,41.78333333333333)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.0000000002)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102743, srs::dpar::parameters<>(proj_lcc)(lat_1,39.01666666666667)(lat_2,40.65)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.0000000002)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102744, srs::dpar::parameters<>(proj_lcc)(lat_1,37.21666666666667)(lat_2,38.35)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.0000000002)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102745, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.9999642857142857)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102746, srs::dpar::parameters<>(proj_lcc)(lat_1,38.03333333333333)(lat_2,39.2)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3499999.999999999)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102747, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,37.96666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3499999.999999999)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102748, srs::dpar::parameters<>(proj_lcc)(lat_1,47.5)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102749, srs::dpar::parameters<>(proj_lcc)(lat_1,45.83333333333334)(lat_2,47.33333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000.0000000002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102750, srs::dpar::parameters<>(proj_lcc)(lat_1,39)(lat_2,40.25)(lat_0,38.5)(lon_0,-79.5)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102751, srs::dpar::parameters<>(proj_lcc)(lat_1,37.48333333333333)(lat_2,38.88333333333333)(lat_0,37)(lon_0,-81)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102752, srs::dpar::parameters<>(proj_lcc)(lat_1,45.56666666666667)(lat_2,46.76666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102753, srs::dpar::parameters<>(proj_lcc)(lat_1,44.25)(lat_2,45.5)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102754, srs::dpar::parameters<>(proj_lcc)(lat_1,42.73333333333333)(lat_2,44.06666666666667)(lat_0,42)(lon_0,-90)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102755, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102756, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,399999.9999999999)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102757, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102758, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,799999.9999999999)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102761, srs::dpar::parameters<>(proj_lcc)(lat_1,18.03333333333334)(lat_2,18.43333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,200000)(y_0,200000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {102766, srs::dpar::parameters<>(proj_poly)(lat_0,13.47246635277778)(lon_0,-144.7487507055556)(x_0,49999.99999999999)(y_0,49999.99999999999)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {103300, srs::dpar::parameters<>(proj_lcc)(lat_1,49.8333339)(lat_2,51.16666733333333)(lat_0,90)(lon_0,4.367486666666666)(x_0,150000.01256)(y_0,5400088.4378)(ellps_intl)(units_m)(no_defs)},
            {104000, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(srs::dpar::datum_nad27)(no_defs)},
            {104101, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {104102, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {104103, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {104104, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {104105, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {104106, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {104107, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {104108, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {104261, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356514.999904194)(no_defs)},
            {104304, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356514.999904194)(no_defs)},
            {104305, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)}
        };

        const code_element * first = arr;
        const code_element * last = arr + sizeof(arr) / sizeof(code_element);
        const code_element * el = binary_find_code_element(first, last, code);

        return el != last ? el->parameters : srs::dpar::parameters<>();
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace boost::geometry::projections

#endif
