## ----setup--------------------------------------------------------------------
library(chess2plyrs)

## -----------------------------------------------------------------------------
g1 <- newgame()
g1

## -----------------------------------------------------------------------------
chess_move(game = g1,
            piece = "p",
            initialposition = "e2",
            finalposition = "e4")


## -----------------------------------------------------------------------------
g2 <- newgame() |>
  chess_move("p", "e2", "e4")  |>
  chess_move("p", "e7", "e5")  |>
  chess_move("N", "g1", "f3")  |>
  chess_move("N", "b8", "c6")  |>
  chess_move("B", "f1", "b5")  |>
  chess_move("N", "g8", "f6")  |>
  chess_move("K", "e1", "0-0") |>
  chess_move("N", "f6", "e4") 

## -----------------------------------------------------------------------------
x <- newgame() |>
  chess_move("p", "e2", "d5") # illegal move

## ----fig.width=5, fig.height=5, fig.retina=3, fig.align='center'--------------
chessplot(g2, style = 2)

## -----------------------------------------------------------------------------
moves_scoresheet(g2)

## -----------------------------------------------------------------------------
game_result(g2)

## -----------------------------------------------------------------------------
legalmoves(g2)

## -----------------------------------------------------------------------------
takeback(g2)

## ----fig.width=5, fig.height=5, fig.retina=3, fig.align='center'--------------
ck4 <- newgame() |>

  chess_move("N", "b1", "a3") |>
  chess_move("p", "e7", "e6") |>

  chess_move("p", "f2", "f4") |>
  chess_move("p", "a7", "a6") |>
  chess_move("p", "h2", "h3") |>
  chess_move("p", "h7", "h6") |>
  chess_move("N", "a3", "b5")

chessplot(ck4, style = 2)

## -----------------------------------------------------------------------------
#engine2(ck4, 1) # "pa6b5" is the chosen move (5 seconds needed)
#engine2(ck4, 2) # "pa6b5" is the chosen move (2/3 minutes needed)
#engine2(ck4, 3) # "Qd8h4" is the chosen move (it takes some minutes to find it)

