/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.ht.ActiveHNode;
import weka.classifiers.trees.ht.LearningNode;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class NBNode
extends ActiveHNode
implements LearningNode,
Serializable {
    private static final long serialVersionUID = -1872415764817690961L;
    protected NaiveBayesUpdateable m_bayes;
    protected double m_nbWeightThreshold;

    public NBNode(Instances header, double nbWeightThreshold) throws Exception {
        this.m_nbWeightThreshold = nbWeightThreshold;
        this.m_bayes = new NaiveBayesUpdateable();
        this.m_bayes.buildClassifier(header);
    }

    @Override
    public void updateNode(Instance inst) throws Exception {
        super.updateNode(inst);
        try {
            this.m_bayes.updateClassifier(inst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected double[] bypassNB(Instance inst, Attribute classAtt) throws Exception {
        return super.getDistribution(inst, classAtt);
    }

    @Override
    public double[] getDistribution(Instance inst, Attribute classAtt) throws Exception {
        boolean doNB;
        boolean bl = this.m_nbWeightThreshold == 0.0 ? true : (doNB = this.totalWeight() - this.m_weightSeenAtLastSplitEval > this.m_nbWeightThreshold);
        if (doNB) {
            return this.m_bayes.distributionForInstance(inst);
        }
        return super.getDistribution(inst, classAtt);
    }

    @Override
    protected int dumpTree(int depth, int leafCount, StringBuffer buff) {
        leafCount = super.dumpTree(depth, leafCount, buff);
        buff.append(" NB" + this.m_leafNum);
        return leafCount;
    }

    @Override
    protected void printLeafModels(StringBuffer buff) {
        buff.append("NB" + this.m_leafNum).append("\n").append(this.m_bayes.toString());
    }
}

