/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Gene;
import org.core.Randomize;

public class Chromosome
implements Comparable {
    private Gene[] genes;
    private double fitness;
    private double ruleSupport;
    private double antecedentSupport;
    private double consequentSupport;
    private double ruleConfidence;
    private double ruleLift;
    private double ruleConv;
    private double ruleCF;
    private double ruleNetconf;
    private double ruleYulesQ;
    private ArrayList<Integer> coveredTIDs;
    public int nAnts;

    public Chromosome(Gene[] genes) {
        int i;
        this.genes = new Gene[genes.length];
        for (i = 0; i < genes.length; ++i) {
            this.genes[i] = genes[i].copy();
        }
        this.coveredTIDs = new ArrayList();
        this.nAnts = 0;
        for (i = 0; i < genes.length; ++i) {
            this.genes[i] = genes[i].copy();
            if (this.genes[i].getActAs() != 0) continue;
            ++this.nAnts;
        }
    }

    public Chromosome copy() {
        Chromosome chromo = new Chromosome(this.genes);
        for (int i = 0; i < this.coveredTIDs.size(); ++i) {
            chromo.addCoveredTID(this.coveredTIDs.get(i));
        }
        chromo.fitness = this.fitness;
        chromo.ruleSupport = this.ruleSupport;
        chromo.antecedentSupport = this.antecedentSupport;
        chromo.consequentSupport = this.consequentSupport;
        chromo.ruleConfidence = this.ruleConfidence;
        chromo.ruleLift = this.ruleLift;
        chromo.ruleCF = this.ruleCF;
        chromo.ruleConv = this.ruleConv;
        chromo.ruleNetconf = this.ruleNetconf;
        return chromo;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setRuleSupport(double ruleSupport) {
        this.ruleSupport = ruleSupport;
    }

    public double getRuleSupport() {
        return this.ruleSupport;
    }

    public void setRuleConfidence(double ruleConfidence) {
        this.ruleConfidence = ruleConfidence;
    }

    public double getRuleConfidence() {
        return this.ruleConfidence;
    }

    public Gene[] getGenes() {
        return this.genes;
    }

    public Gene getGene(int i) {
        return this.genes[i];
    }

    public ArrayList<Integer> getIndexOfInvolvedGenes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() == -1) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public ArrayList<Integer> getIndexOfNotInvolvedGenes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != -1) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public ArrayList<Integer> getIndexOfAntecedentGenes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != 0) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public ArrayList<Integer> getIndexOfConsequentGenes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != 1) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public void addCoveredTID(int tid) {
        this.coveredTIDs.add(tid);
    }

    public ArrayList<Integer> getCoveredTIDs() {
        return this.coveredTIDs;
    }

    public void forceConsistency() {
        ArrayList<Integer> not_involved_attrs = this.getIndexOfNotInvolvedGenes();
        int n_not_involved = not_involved_attrs.size();
        int n_ant = this.getIndexOfAntecedentGenes().size();
        int n_cons = this.getIndexOfConsequentGenes().size();
        if (n_ant == 0) {
            if (n_cons > 0) {
                if (n_not_involved == 0) {
                    int g_ant = Randomize.Randint(0, this.genes.length);
                    this.genes[g_ant].setActAs(0);
                } else {
                    int g_ant = not_involved_attrs.get(Randomize.Randint(0, n_not_involved));
                    this.genes[g_ant].setActAs(0);
                }
            } else {
                int g_cons;
                int g_ant = Randomize.Randint(0, this.genes.length);
                while ((g_cons = Randomize.Randint(0, this.genes.length)) == g_ant) {
                }
                this.genes[g_ant].setActAs(0);
                this.genes[g_cons].setActAs(1);
            }
        } else if (n_cons == 0) {
            if (n_not_involved == 0) {
                int g_cons = Randomize.Randint(0, this.genes.length);
                this.genes[g_cons].setActAs(1);
            } else {
                int g_cons = not_involved_attrs.get(Randomize.Randint(0, n_not_involved));
                this.genes[g_cons].setActAs(1);
            }
        }
    }

    public int compareTo(Object chr) {
        if (((Chromosome)chr).fitness < this.fitness) {
            return -1;
        }
        if (((Chromosome)chr).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Chromosome chr) {
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != -1 && chr.genes[i].getActAs() == -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 && chr.genes[i].getActAs() != -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 || chr.genes[i].getActAs() == -1 || chr.genes[i].equals(this.genes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String str = "Fitness: " + this.fitness + "; Rule Support: " + this.ruleSupport + "; Rule Confidence: " + this.ruleConfidence + "\n";
        for (int i = 0; i < this.genes.length; ++i) {
            str = str + this.genes[i] + "\n";
        }
        str = str + "Covered TIDs: " + this.coveredTIDs;
        return str;
    }

    public double getRuleLift() {
        return this.ruleLift;
    }

    public void setRuleLift(double ruleLift) {
        this.ruleLift = ruleLift;
    }

    public double getRuleCF() {
        return this.ruleCF;
    }

    public void setRuleCF(double ruleCF) {
        this.ruleCF = ruleCF;
    }

    public double getRuleConv() {
        return this.ruleConv;
    }

    public void setRuleConv(double ruleConv) {
        this.ruleConv = ruleConv;
    }

    public double getRuleNetconf() {
        return this.ruleNetconf;
    }

    public void setRuleNetconf(double ruleNetconf) {
        this.ruleNetconf = ruleNetconf;
    }

    public double getAntecedentSupport() {
        return this.antecedentSupport;
    }

    public void setAntecedentSupport(double antecedentSupport) {
        this.antecedentSupport = antecedentSupport;
    }

    public double getConsequentSupport() {
        return this.consequentSupport;
    }

    public void setConsequentSupport(double consequentSupport) {
        this.consequentSupport = consequentSupport;
    }

    public double getRuleYulesQ() {
        return this.ruleYulesQ;
    }

    public void setRuleYulesQ(double ruleYulesQ) {
        this.ruleYulesQ = ruleYulesQ;
    }

    public int getnAnts() {
        return this.nAnts;
    }

    public void setnAnts(int ants) {
        this.nAnts = ants;
    }

    public boolean isSubChromo(Chromosome chromo2) {
        if (this.getRuleSupport() < chromo2.getRuleSupport()) {
            return false;
        }
        for (int i = 0; i < this.genes.length; ++i) {
            Gene gen = chromo2.getGene(i);
            if (this.genes[i].getActAs() != -1 && gen.getActAs() == -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 && gen.getActAs() != -1) {
                return false;
            }
            if (this.genes[i].getActAs() == -1 || gen.getActAs() == -1 || this.genes[i].isSubGen(gen)) continue;
            return false;
        }
        return true;
    }
}

