/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.exprtree.AbstractExprTreeSpecies;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.IPrimitive;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprTreeIndividualSpecies
extends AbstractExprTreeSpecies<ExprTreeIndividual>
implements IConfigure {
    private static final long serialVersionUID = -5304951511814536309L;

    public void setNumberOfExprTrees(int numberOfExpressionTrees) {
        this.genotypeSchema = new AbstractExprTreeSpecies.ExprTreeSchema[numberOfExpressionTrees];
        int i = 0;
        while (i < numberOfExpressionTrees) {
            this.genotypeSchema[i] = new AbstractExprTreeSpecies.ExprTreeSchema();
            ++i;
        }
    }

    public void setMinTreeSize(int exprTreeIndex, int minimumTreeSize) {
        this.genotypeSchema[exprTreeIndex].minTreeSize = minimumTreeSize;
    }

    public void setMaxTreeSize(int exprTreeIndex, int maximumTreeSize) {
        this.genotypeSchema[exprTreeIndex].maxTreeSize = maximumTreeSize;
    }

    public void setRootType(int exprTreeIndex, Class<?> rootType) {
        this.genotypeSchema[exprTreeIndex].rootType = rootType;
    }

    public void setTerminals(int exprTreeIndex, IPrimitive[] terminals) {
        this.genotypeSchema[exprTreeIndex].terminals = terminals;
        if (this.genotypeSchema[exprTreeIndex].functions != null) {
            this.genotypeSchema[exprTreeIndex].generateBlockMaps();
        }
    }

    public void setFunctions(int exprTreeIndex, IPrimitive[] functions) {
        this.genotypeSchema[exprTreeIndex].functions = functions;
        if (this.genotypeSchema[exprTreeIndex].terminals != null) {
            this.genotypeSchema[exprTreeIndex].generateBlockMaps();
        }
    }

    @Override
    public ExprTreeIndividual createIndividual() {
        return new ExprTreeIndividual();
    }

    @Override
    public ExprTreeIndividual createIndividual(ExprTree[] genotype) {
        return new ExprTreeIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfPrefixExpressions = settings.getInt("[@number-of-trees]", 1);
        this.setNumberOfExprTrees(numberOfPrefixExpressions);
        int i = 0;
        while (i < numberOfPrefixExpressions) {
            String header = "expression-tree(" + i + ")";
            int minTreeSize = settings.getInt(String.valueOf(header) + ".min-tree-size");
            this.setMinTreeSize(i, minTreeSize);
            int maxTreeSize = settings.getInt(String.valueOf(header) + ".max-tree-size");
            this.setMaxTreeSize(i, maxTreeSize);
            String rootTypeName = settings.getString(String.valueOf(header) + ".root-type");
            try {
                Class<?> rootType = Class.forName(rootTypeName);
                this.setRootType(i, rootType);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("");
            }
            int numberOfTerminals = settings.getList(String.valueOf(header) + ".terminals.terminal[@class]").size();
            IPrimitive[] terminals = new IPrimitive[numberOfTerminals];
            int j = 0;
            while (j < numberOfTerminals) {
                try {
                    String terminalClassname = settings.getString(String.valueOf(header) + ".terminals.terminal(" + j + ")[@class]");
                    Class<?> terminalClass = Class.forName(terminalClassname);
                    terminals[j] = (IPrimitive)terminalClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (InstantiationException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationRuntimeException();
                }
                ++j;
            }
            this.setTerminals(i, terminals);
            int numberOfFunctions = settings.getList(String.valueOf(header) + ".functions.function[@class]").size();
            IPrimitive[] functions = new IPrimitive[numberOfFunctions];
            int j2 = 0;
            while (j2 < numberOfFunctions) {
                try {
                    String functionClassname = settings.getString(String.valueOf(header) + ".functions.function(" + j2 + ")[@class]");
                    Class<?> functionClass = Class.forName(functionClassname);
                    functions[j2] = (IPrimitive)functionClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (InstantiationException e) {
                    throw new ConfigurationRuntimeException();
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationRuntimeException();
                }
                ++j2;
            }
            this.setFunctions(i, functions);
            ++i;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTreeIndividualSpecies) {
            ExprTreeIndividualSpecies cother = (ExprTreeIndividualSpecies)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.genotypeSchema, cother.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

