/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Instance_Selection.PSRCG;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import org.core.Fichero;

public class PSRCG
extends Metodo {
    public PSRCG(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        double RCG1;
        double dist;
        double minDist;
        int j;
        int i;
        int nSel = 0;
        int loc = 0;
        int loc2 = 0;
        int pos = 0;
        long tiempo = System.currentTimeMillis();
        int[] nClases = new int[this.clasesTrain.length];
        Arrays.fill(nClases, Integer.MIN_VALUE);
        int nc = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            boolean parar = false;
            for (j = 0; j < nClases.length && nClases[j] != Integer.MIN_VALUE; ++j) {
                if (nClases[j] != this.clasesTrain[i]) continue;
                parar = true;
            }
            if (parar) continue;
            nClases[nc] = this.clasesTrain[i];
            ++nc;
        }
        int[] nombreClases = new int[nc];
        for (i = 0; i < nc; ++i) {
            nombreClases[i] = nClases[i];
        }
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
        }
        nSel = this.datosTrain.length;
        boolean[][] grafo = new boolean[this.datosTrain.length][this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            Arrays.fill(grafo[i], false);
            grafo[i][i] = true;
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            minDist = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.datosTrain.length; ++j) {
                if (i == j || !((dist = KNN.distancia(this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], this.datosTrain[j], this.realTrain[j], this.nominalTrain[j], this.nulosTrain[j], this.distanceEu)) < minDist)) continue;
                minDist = dist;
                loc = j;
            }
            grafo[i][loc] = true;
            grafo[loc][i] = true;
        }
        double[] uncer = new double[this.datosTrain.length];
        double RCG2 = this.computeRCG(this.clasesTrain, grafo, marcas, nombreClases, nSel);
        do {
            RCG1 = RCG2;
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (!marcas[i]) continue;
                uncer[i] = this.Uloc(this.clasesTrain, marcas, nombreClases, grafo, i);
            }
            double maxUnc = Double.NEGATIVE_INFINITY;
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (!marcas[i]) continue;
                if (uncer[i] > maxUnc) {
                    maxUnc = uncer[i];
                    pos = i;
                    continue;
                }
                if (uncer[i] != maxUnc) continue;
                int cont2 = 0;
                int cont1 = 0;
                for (j = 0; j < grafo[i].length; ++j) {
                    if (!grafo[i][j] || !marcas[j]) continue;
                    ++cont1;
                }
                for (j = 0; j < grafo[pos].length; ++j) {
                    if (!grafo[pos][j] || !marcas[j]) continue;
                    ++cont2;
                }
                if (cont1 >= cont2) continue;
                pos = i;
            }
            marcas[pos] = false;
        } while ((RCG2 = this.computeRCG(this.clasesTrain, grafo, marcas, nombreClases, --nSel)) < RCG1 || !(RCG2 > 0.0));
        grafo = new boolean[this.datosTrain.length][this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            Arrays.fill(grafo[i], false);
            grafo[i][i] = true;
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            minDist = Double.POSITIVE_INFINITY;
            for (j = 0; j < this.datosTrain.length; ++j) {
                if (i == j) continue;
                dist = KNN.distancia(this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], this.datosTrain[j], this.realTrain[j], this.nominalTrain[j], this.nulosTrain[j], this.distanceEu);
                if (dist < minDist && minDist == Double.POSITIVE_INFINITY) {
                    minDist = dist;
                    loc = j;
                    continue;
                }
                if (!(dist < minDist)) continue;
                minDist = dist;
                loc2 = loc;
                loc = j;
            }
            grafo[i][loc] = true;
            grafo[i][loc2] = true;
            grafo[loc][i] = true;
            grafo[loc2][i] = true;
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            uncer[i] = this.Uloc(this.clasesTrain, marcas, nombreClases, grafo, i);
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i] || uncer[i] != 0.0) continue;
            marcas[i] = false;
            --nSel;
        }
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("PSRCG " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
        OutputIS.escribeSalida(this.ficheroSalida[1], this.test, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    private double computeRCG(int[] clases, boolean[][] grafo, boolean[] marcas, int[] nombreClases, int nSel) {
        return (this.U0(clases, marcas, nombreClases, nSel) - this.Utot(clases, marcas, nombreClases, grafo, nSel)) / this.U0(clases, marcas, nombreClases, nSel);
    }

    private double U0(int[] clases, boolean[] marcas, int[] nombreClases, int nSel) {
        double sumaT = 0.0;
        for (int i = 0; i < nombreClases.length; ++i) {
            int sumaC = 0;
            for (int j = 0; j < clases.length; ++j) {
                if (!marcas[j] || clases[j] != nombreClases[i]) continue;
                ++sumaC;
            }
            sumaT += (double)sumaC / (double)nSel * (1.0 - (double)sumaC / (double)nSel);
        }
        return sumaT;
    }

    private double Uloc(int[] clases, boolean[] marcas, int[] nombreClases, boolean[][] grafo, int instance) {
        int i;
        double sumaT = 0.0;
        int ni = 0;
        for (i = 0; i < grafo[instance].length; ++i) {
            if (!grafo[instance][i] || !marcas[i]) continue;
            ++ni;
        }
        for (i = 0; i < nombreClases.length; ++i) {
            int sumaC = 0;
            for (int j = 0; j < grafo[instance].length; ++j) {
                if (!grafo[instance][j] || !marcas[j] || clases[j] != nombreClases[i]) continue;
                ++sumaC;
            }
            sumaT += (double)sumaC / (double)ni * (1.0 - (double)sumaC / (double)ni);
        }
        return sumaT;
    }

    private double Utot(int[] clases, boolean[] marcas, int[] nombreClases, boolean[][] grafo, int nSel) {
        int j;
        int i;
        double sumaT = 0.0;
        int cardE = 0;
        for (i = 0; i < grafo.length; ++i) {
            if (!marcas[i]) continue;
            for (j = 0; j < grafo[i].length; ++j) {
                if (!marcas[j] || !grafo[i][j]) continue;
                ++cardE;
            }
        }
        for (i = 0; i < grafo.length; ++i) {
            if (!marcas[i]) continue;
            int ni = 0;
            for (j = 0; j < grafo[i].length; ++j) {
                if (!grafo[i][j] || !marcas[j]) continue;
                ++ni;
            }
            sumaT += (double)ni / (double)cardE * this.Uloc(clases, marcas, nombreClases, grafo, i);
        }
        return sumaT;
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

