/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.util.Vector;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.FUN;
import keel.Algorithms.Preprocess.NoiseFilters.ANR.OPV;
import org.core.Randomize;

public class LinearSearchBrent {
    double[][][] dSearch;
    double[][][] xSearch;
    FUN f;
    private final double INIT_STEP = 0.01f;
    private final double TOL_BLIN = 1.0E-4f;
    private final double TOL_CERO = 1.0E-9f;
    private final double MIN_DELTABLIN = 1.0E-6f;
    private final int MAX_ITERBLIN = 100;
    private final int MAX_ITERINI = 50;
    final int lower_y = 0;
    final int lower_x = 1;

    public LinearSearchBrent(FUN vf, double[][][] vdbus, double[][][] vxbus) {
        this.f = vf;
        this.dSearch = vdbus;
        this.xSearch = vxbus;
    }

    public double g(double alpha) {
        double result = 0.0;
        result = this.f.evaluate(OPV.sum(this.xSearch, OPV.multiply(alpha, this.dSearch)));
        return result;
    }

    private void sort(pair[] a, int size, int criterium) {
        for (int i = 1; i < size; ++i) {
            pair x = new pair(a[i].first, a[i].second);
            for (int j = i - 1; !(j < 0 || criterium == 0 && a[j].second <= x.second || criterium == 1 && a[j].first <= x.first); --j) {
                a[j + 1].first = a[j].first;
                a[j + 1].second = a[j].second;
            }
            a[j + 1].first = x.first;
            a[j + 1].second = x.second;
        }
    }

    private double q(double x, double x1, double x2, double x3, double f1, double f2, double f3) {
        return f1 * (x - x2) * (x - x3) / (x1 - x2) / (x1 - x3) + f2 * (x - x1) * (x - x3) / (x2 - x1) / (x2 - x3) + f3 * (x - x1) * (x - x2) / (x3 - x1) / (x3 - x2);
    }

    public double minimumSearch(Randomize r) {
        boolean debug = false;
        if (debug) {
            System.out.println("BL ...0");
        }
        int iteracion = 0;
        double x = -1.0;
        double yl = -1.0;
        double yr = -1.0;
        double y = -1.0;
        double xl = -1.0;
        double xr = -1.0;
        Vector<pair> tresp = new Vector<pair>();
        tresp.add(new pair(0.0, this.g(0.0)));
        double DOUBLESTEP = 0.02f;
        double AVESTEP = 0.005f;
        if (debug) {
            System.out.println("BL ...1/2");
        }
        for (int i = 0; i < 50; ++i) {
            if (debug) {
                System.out.println("BL ...1");
            }
            tresp.add(new pair(DOUBLESTEP, this.g(DOUBLESTEP)));
            tresp.add(new pair(AVESTEP, this.g(AVESTEP)));
            DOUBLESTEP *= 2.0;
            AVESTEP /= 2.0;
            if (tresp.size() < 3) continue;
            int minj = 0;
            for (int j = 0; j < tresp.size(); ++j) {
                pair ptmp = (pair)tresp.get(j);
                if (!(ptmp.second < y) && j != 0) continue;
                y = ptmp.second;
                x = ptmp.first;
                minj = j;
            }
            xl = -1.0;
            xr = -1.0;
            boolean first1 = true;
            boolean first2 = true;
            for (int j = 0; j < tresp.size(); ++j) {
                if (j == minj) continue;
                pair ptmp = (pair)tresp.get(j);
                if (!(ptmp.second > y)) continue;
                if (ptmp.first < x) {
                    if (ptmp.first > xl || first1) {
                        xl = ptmp.first;
                        yl = ptmp.second;
                    }
                    first1 = false;
                }
                if (!(ptmp.first > x)) continue;
                if (ptmp.first < xr || first2) {
                    xr = ptmp.first;
                    yr = ptmp.second;
                }
                first2 = false;
            }
            if (xl != -1.0 && xr != -1.0) break;
        }
        if (xl == -1.0 || yr == -1.0) {
            return x;
        }
        if (debug) {
            System.out.println("BL ...2");
        }
        double fmin = y;
        while (xr - xl > (double)1.0E-4f && iteracion < 100) {
            ++iteracion;
            if (debug) {
                System.out.println("BL ...3 " + iteracion);
            }
            double b12 = xl * xl - x * x;
            double b23 = x * x - xr * xr;
            double b31 = xr * xr - xl * xl;
            double a23 = x - xr;
            double a31 = xr - xl;
            double a12 = xl - x;
            double denominador = a23 * yl + a31 * y + a12 * yr;
            if (Math.abs(denominador) < (double)1.0E-9f) {
                System.out.println("Funcion no convexa en Brent " + this.g(x));
                return x;
            }
            double x4 = 0.5 * (b23 * yl + b31 * y + b12 * yr) / denominador;
            double y4 = this.g(x4);
            if (debug) {
                System.out.println("BL ...4 " + iteracion);
            }
            if (!(xl <= x4) || !(x4 <= xr)) {
                System.out.println("Error while finding x4, check tolerance");
                System.out.println("xl=" + xl + " yl=" + yl);
                System.out.println("x=" + x + " y=" + y);
                System.out.println("xr=" + xr + " yr=" + yr);
                System.out.println("x4=" + x4 + " y4=" + y4);
                System.out.println("ql=" + this.q(xl, xl, x, xr, yl, y, yr));
                System.out.println("q0=" + this.q(x, xl, x, xr, yl, y, yr));
                System.out.println("qr=" + this.q(xr, xl, x, xr, yl, y, yr));
                System.out.println("q4=" + this.q(x4, xl, x, xr, yl, y, yr));
                return x;
            }
            pair[] brent = new pair[]{new pair(xl, yl), new pair(x, y), new pair(xr, yr), new pair(x4, y4)};
            this.sort(brent, 4, 1);
            double minvy = brent[0].second;
            int iminvy = 0;
            for (int i = 0; i < 4; ++i) {
                if (!(minvy > brent[i].second)) continue;
                minvy = brent[i].second;
                iminvy = i;
            }
            if (debug) {
                System.out.println("BL ...5 " + iteracion);
            }
            if (iminvy == 1) {
                xl = brent[0].first;
                yl = brent[0].second;
                x = brent[1].first;
                y = brent[1].second;
                xr = brent[2].first;
                yr = brent[2].second;
            } else if (iminvy == 2) {
                xl = brent[1].first;
                yl = brent[1].second;
                x = brent[2].first;
                y = brent[2].second;
                xr = brent[3].first;
                yr = brent[3].second;
            } else {
                System.out.println("Puntos no estan en la configuracion correcta");
                return x;
            }
            if (Math.abs(minvy - fmin) < (double)1.0E-6f) {
                return x;
            }
            fmin = minvy;
        }
        if (iteracion >= 100) {
            System.out.println("Too many iterations in Brent");
            return x;
        }
        return x;
    }

    class pair {
        double first;
        double second;

        pair() {
            this.first = 0.0;
            this.second = 0.0;
        }

        pair(double x, double y) {
            this.first = x;
            this.second = y;
        }
    }
}

