/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Individual;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Selected;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;
import org.core.Randomize;

public class Population {
    ArrayList<Individual> Population;
    ArrayList<Individual> offspring;
    double crossProb;
    double mutProb;
    double wCAR;
    double wV;
    double n1;
    double n2;
    int n_variables;
    int pop_size;
    int lengthSC;
    int Jmax;
    double best_fitness;
    double best_accuracy;
    int[] selected;
    myDataset train;
    DataBase dataBase;
    Apriori apriori;

    public boolean BETTER(double a, double b) {
        return a > b;
    }

    public Population() {
    }

    public Population(myDataset train, DataBase dataBase, int size, double crossProb, double mutProb, int lengthSC, double wCAR, double wV, double n1, double n2, int Jmax, Apriori apriori) {
        this.dataBase = dataBase;
        this.train = train;
        this.apriori = apriori;
        this.n_variables = dataBase.numVariables();
        this.pop_size = size;
        this.mutProb = mutProb;
        this.crossProb = crossProb;
        this.lengthSC = lengthSC;
        this.wCAR = wCAR;
        this.wV = wV;
        this.n1 = n1;
        this.n2 = n2;
        this.Jmax = Jmax;
        this.selected = new int[this.pop_size];
        this.Population = new ArrayList();
        this.offspring = new ArrayList();
    }

    private void init() {
        for (int i = 0; i < this.pop_size; ++i) {
            Individual ind = new Individual(this.wCAR, this.wV, this.lengthSC);
            ind.randomValues();
            this.Population.add(ind);
        }
        this.best_fitness = 0.0;
    }

    public void Generation(int n_Generations) {
        this.init();
        this.evaluate(this.Population);
        for (int i = 0; i < n_Generations; ++i) {
            this.selection();
            this.crossover();
            this.mutation();
            this.evaluate(this.offspring);
            this.elitist(i);
        }
    }

    private void selection() {
        int i;
        double[] probabilities = new double[this.Population.size()];
        ArrayList<Selected> vector = new ArrayList<Selected>();
        this.offspring.clear();
        Collections.sort(this.Population);
        double f_min = this.Population.get((int)(this.Population.size() - 1)).fitness;
        double sum = 0.0;
        for (i = 0; i < this.Population.size(); ++i) {
            probabilities[i] = this.Population.get((int)i).fitness - f_min;
            sum += probabilities[i] - f_min;
        }
        for (i = 0; i < this.Population.size(); ++i) {
            int n = i;
            probabilities[n] = probabilities[n] / sum;
            Selected s = new Selected(probabilities[i], i);
            vector.add(s);
        }
        Collections.sort(vector);
        for (i = 0; i < this.Population.size(); ++i) {
            double random = Randomize.Rand();
            int j = 0;
            while (random < ((Selected)vector.get((int)j)).probability) {
                ++j;
            }
            this.selected[i] = ((Selected)vector.get((int)j)).post;
        }
    }

    private void crossover() {
        for (int i = 0; i < this.Population.size(); i += 2) {
            Individual dad = this.Population.get(this.selected[i]).clone();
            Individual mom = this.Population.get(this.selected[i + 1]).clone();
            double random = Randomize.Rand();
            if (random < this.crossProb) {
                int pointCross1 = Randomize.Randint(0, this.lengthSC);
                int pointCross2 = Randomize.Randint(this.lengthSC, this.lengthSC * 2);
                dad.interchangeValues(mom, pointCross1, pointCross2);
            }
            this.offspring.add(dad);
            this.offspring.add(mom);
        }
    }

    private void mutation() {
        for (int i = 0; i < this.offspring.size(); ++i) {
            this.offspring.get(i).mutation(this.mutProb);
        }
    }

    private void elitist(int generation) {
        Collections.sort(this.Population);
        Individual best = this.Population.get(0).clone();
        this.Population.clear();
        this.Population.add(best);
        Collections.sort(this.offspring);
        this.offspring.remove(this.offspring.size() - 1);
        for (int i = 0; i < this.offspring.size(); ++i) {
            Individual indiv = this.offspring.get(i).clone();
            this.Population.add(indiv);
        }
        if (this.BETTER(best.getFitness(), this.best_fitness)) {
            this.best_fitness = best.getFitness();
            this.best_accuracy = best.getAccuracy();
        }
        System.out.println("Best Fitness obtained in generation[" + generation + "]: " + this.best_fitness + "  Accuracy: " + this.best_accuracy);
    }

    private void evaluate(ArrayList<Individual> Individuals) {
        this.best_fitness = Double.NEGATIVE_INFINITY;
        this.best_accuracy = 0.0;
        for (int i = 0; i < Individuals.size(); ++i) {
            double fit;
            if (Individuals.get(i).isNew()) {
                Individuals.get(i).evaluate(this.apriori, this.n1, this.n2, this.Jmax);
            }
            if (!this.BETTER(fit = Individuals.get(i).getFitness(), this.best_fitness)) continue;
            this.best_fitness = fit;
            this.best_accuracy = Individuals.get(i).getAccuracy();
        }
    }

    public RuleBase getBestRB() {
        Collections.sort(this.Population);
        RuleBase ruleBase = this.Population.get(0).generateRB(this.apriori, this.n1, this.n2, this.Jmax);
        return ruleBase;
    }

    public double getBestMinFS() {
        Collections.sort(this.Population);
        return this.Population.get(0).getMinFS();
    }

    public double getBestMinFC() {
        Collections.sort(this.Population);
        return this.Population.get(0).getMinFC();
    }
}

