/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin1D;
import hep.aida.tfloat.bin.StaticFloatBin1D;

public class MightyStaticFloatBin1D
extends StaticFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected boolean hasSumOfLogarithms = false;
    protected float sumOfLogarithms = 0.0f;
    protected boolean hasSumOfInversions = false;
    protected float sumOfInversions = 0.0f;
    protected float[] sumOfPowers = null;

    public MightyStaticFloatBin1D() {
        this(false, false, 4);
    }

    public MightyStaticFloatBin1D(boolean bl, boolean bl2, int n) {
        this.setMaxOrderForSumOfPowers(n);
        this.hasSumOfLogarithms = bl;
        this.hasSumOfInversions = bl2;
        this.clear();
    }

    public synchronized void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        super.addAllOfFromTo(floatArrayList, n, n2);
        if (this.sumOfPowers != null) {
            FloatDescriptive.incrementalUpdateSumsOfPowers(floatArrayList, n, n2, 3, this.getMaxOrderForSumOfPowers(), this.sumOfPowers);
        }
        if (this.hasSumOfInversions) {
            this.sumOfInversions += FloatDescriptive.sumOfInversions(floatArrayList, n, n2);
        }
        if (this.hasSumOfLogarithms) {
            this.sumOfLogarithms += FloatDescriptive.sumOfLogarithms(floatArrayList, n, n2);
        }
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
        this.sumOfLogarithms = 0.0f;
        this.sumOfInversions = 0.0f;
        if (this.sumOfPowers != null) {
            int n = this.sumOfPowers.length;
            while (--n >= 0) {
                this.sumOfPowers[n] = 0.0f;
            }
        }
    }

    public synchronized Object clone() {
        MightyStaticFloatBin1D mightyStaticFloatBin1D = (MightyStaticFloatBin1D)super.clone();
        if (this.sumOfPowers != null) {
            mightyStaticFloatBin1D.sumOfPowers = (float[])mightyStaticFloatBin1D.sumOfPowers.clone();
        }
        return mightyStaticFloatBin1D;
    }

    public String compareWith(AbstractFloatBin1D abstractFloatBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractFloatBin1D));
        if (abstractFloatBin1D instanceof MightyStaticFloatBin1D) {
            MightyStaticFloatBin1D mightyStaticFloatBin1D = (MightyStaticFloatBin1D)abstractFloatBin1D;
            if (this.hasSumOfLogarithms() && mightyStaticFloatBin1D.hasSumOfLogarithms()) {
                stringBuffer.append("geometric mean: " + this.relError(this.geometricMean(), mightyStaticFloatBin1D.geometricMean()) + " %\n");
            }
            if (this.hasSumOfInversions() && mightyStaticFloatBin1D.hasSumOfInversions()) {
                stringBuffer.append("harmonic mean: " + this.relError(this.harmonicMean(), mightyStaticFloatBin1D.harmonicMean()) + " %\n");
            }
            if (this.hasSumOfPowers(3) && mightyStaticFloatBin1D.hasSumOfPowers(3)) {
                stringBuffer.append("skew: " + this.relError(this.skew(), mightyStaticFloatBin1D.skew()) + " %\n");
            }
            if (this.hasSumOfPowers(4) && mightyStaticFloatBin1D.hasSumOfPowers(4)) {
                stringBuffer.append("kurtosis: " + this.relError(this.kurtosis(), mightyStaticFloatBin1D.kurtosis()) + " %\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public synchronized float geometricMean() {
        return FloatDescriptive.geometricMean(this.size(), this.sumOfLogarithms());
    }

    public synchronized int getMaxOrderForSumOfPowers() {
        if (this.sumOfPowers == null) {
            return 2;
        }
        return 2 + this.sumOfPowers.length;
    }

    public synchronized int getMinOrderForSumOfPowers() {
        int n = 0;
        if (this.hasSumOfInversions()) {
            n = -1;
        }
        return n;
    }

    public synchronized float harmonicMean() {
        return FloatDescriptive.harmonicMean(this.size(), this.sumOfInversions());
    }

    public boolean hasSumOfInversions() {
        return this.hasSumOfInversions;
    }

    public boolean hasSumOfLogarithms() {
        return this.hasSumOfLogarithms;
    }

    public boolean hasSumOfPowers(int n) {
        return this.getMinOrderForSumOfPowers() <= n && n <= this.getMaxOrderForSumOfPowers();
    }

    public synchronized float kurtosis() {
        return FloatDescriptive.kurtosis(this.moment(4, this.mean()), this.standardDeviation());
    }

    public synchronized float moment(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("k must be >= 0");
        }
        if (!this.hasSumOfPowers(n)) {
            return Float.NaN;
        }
        int n2 = Math.min(n, this.getMaxOrderForSumOfPowers());
        FloatArrayList floatArrayList = new FloatArrayList(n2 + 1);
        floatArrayList.add(this.size());
        floatArrayList.add(this.sum());
        floatArrayList.add(this.sumOfSquares());
        for (int i = 3; i <= n2; ++i) {
            floatArrayList.add(this.sumOfPowers(i));
        }
        return FloatDescriptive.moment(n, f, this.size(), floatArrayList.elements());
    }

    public float product() {
        return FloatDescriptive.product(this.size(), this.sumOfLogarithms());
    }

    protected void setMaxOrderForSumOfPowers(int n) {
        this.sumOfPowers = (float[])(n <= 2 ? null : new float[n - 2]);
    }

    public synchronized float skew() {
        return FloatDescriptive.skew(this.moment(3, this.mean()), this.standardDeviation());
    }

    public float sumOfInversions() {
        if (!this.hasSumOfInversions) {
            return Float.NaN;
        }
        return this.sumOfInversions;
    }

    public synchronized float sumOfLogarithms() {
        if (!this.hasSumOfLogarithms) {
            return Float.NaN;
        }
        return this.sumOfLogarithms;
    }

    public synchronized float sumOfPowers(int n) {
        if (!this.hasSumOfPowers(n)) {
            return Float.NaN;
        }
        if (n == -1) {
            return this.sumOfInversions();
        }
        if (n == 0) {
            return this.size();
        }
        if (n == 1) {
            return this.sum();
        }
        if (n == 2) {
            return this.sumOfSquares();
        }
        return this.sumOfPowers[n - 3];
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.hasSumOfLogarithms()) {
            stringBuffer.append("Geometric mean: " + this.geometricMean());
            stringBuffer.append("\nProduct: " + this.product() + "\n");
        }
        if (this.hasSumOfInversions()) {
            stringBuffer.append("Harmonic mean: " + this.harmonicMean());
            stringBuffer.append("\nSum of inversions: " + this.sumOfInversions() + "\n");
        }
        int n = this.getMaxOrderForSumOfPowers();
        int n2 = Math.min(6, n);
        if (n > 2) {
            int n3;
            if (n >= 3) {
                stringBuffer.append("Skew: " + this.skew() + "\n");
            }
            if (n >= 4) {
                stringBuffer.append("Kurtosis: " + this.kurtosis() + "\n");
            }
            for (n3 = 3; n3 <= n2; ++n3) {
                stringBuffer.append("Sum of powers(" + n3 + "): " + this.sumOfPowers(n3) + "\n");
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                stringBuffer.append("Moment(" + n3 + ",0): " + this.moment(n3, 0.0f) + "\n");
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                stringBuffer.append("Moment(" + n3 + ",mean()): " + this.moment(n3, this.mean()) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected void xcheckOrder(int n) {
    }

    protected boolean xequals(Object object) {
        if (!(object instanceof MightyStaticFloatBin1D)) {
            return false;
        }
        MightyStaticFloatBin1D mightyStaticFloatBin1D = (MightyStaticFloatBin1D)object;
        return super.equals(mightyStaticFloatBin1D) && this.sumOfInversions() == mightyStaticFloatBin1D.sumOfInversions() && this.sumOfLogarithms() == mightyStaticFloatBin1D.sumOfLogarithms();
    }

    protected boolean xhasSumOfPowers(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("fromK must be less or equal to toK");
        }
        return this.getMinOrderForSumOfPowers() <= n && n2 <= this.getMaxOrderForSumOfPowers();
    }

    protected synchronized boolean xisLegalOrder(int n) {
        return this.getMinOrderForSumOfPowers() <= n && n <= this.getMaxOrderForSumOfPowers();
    }
}

