/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseColumnLongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix1D;

class SelectedDenseColumnLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseColumnLongMatrix2D(long[] lArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, lArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseColumnLongMatrix2D(int n, int n2, long[] lArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = lArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public long[] elements() {
        return this.elements;
    }

    public long getQuick(int n, int n2) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]];
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public LongMatrix2D like(int n, int n2) {
        return new DenseColumnLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new DenseLongMatrix1D(n);
    }

    public void setQuick(int n, int n2, long l) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]] = l;
    }

    public LongMatrix1D vectorize() {
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseLongMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseLongMatrix1D;
    }

    public LongMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseLongMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public LongMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseLongMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        if (longMatrix2D instanceof SelectedDenseColumnLongMatrix2D) {
            SelectedDenseColumnLongMatrix2D selectedDenseColumnLongMatrix2D = (SelectedDenseColumnLongMatrix2D)longMatrix2D;
            return this.elements == selectedDenseColumnLongMatrix2D.elements;
        }
        if (longMatrix2D instanceof DenseColumnLongMatrix2D) {
            DenseColumnLongMatrix2D denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D;
            return this.elements == denseColumnLongMatrix2D.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnLongMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

