/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.Transpose;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedDenseColumnFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netlib.blas.BLAS;

public class DenseColumnFloatMatrix2D
extends FloatMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    protected float[] elements;

    public DenseColumnFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public DenseColumnFloatMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 1, n);
        this.elements = new float[n * n2];
    }

    public DenseColumnFloatMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.isNoView = !bl;
    }

    public DenseColumnFloatMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            float[] fArray;
            int[] nArray;
            int[] nArray2;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new float[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray2 = new int[n2];
                nArray = new int[n2];
                fArray = new float[n2];
                matrixVectorReader.readCoordinate(nArray, nArray2, fArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray[n], nArray2[n], fArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.setQuick(nArray2[n], nArray[n], fArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] == nArray2[n]) continue;
                this.setQuick(nArray2[n], nArray[n], -fArray[n]);
            }
        }
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnFloatMatrix2D.this.columnStride;
                            int n42 = DenseColumnFloatMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                f = floatFloatFunction.apply(f, floatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n42 * DenseColumnFloatMatrix2D.this.rowStride + n3]));
                            }
                            n6 = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    f = floatFloatFunction.apply(f, floatFunction.apply(this.elements[n9 * this.rowStride + n8]));
                }
                n6 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatProcedure floatProcedure) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = DenseColumnFloatMatrix2D.this.elements[n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        float f2 = 0.0f;
                        if (floatProcedure.apply(f)) {
                            f2 = floatFunction.apply(f);
                        }
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnFloatMatrix2D.this.columnStride;
                            int n42 = DenseColumnFloatMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                f = DenseColumnFloatMatrix2D.this.elements[n42 * DenseColumnFloatMatrix2D.this.rowStride + n3];
                                if (!floatProcedure.apply(f)) continue;
                                f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                            }
                            n6 = 0;
                        }
                        return Float.valueOf(f2);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            float f2 = this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (floatProcedure.apply(f2)) {
                f = floatFunction.apply(f2);
            }
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    f2 = this.elements[n9 * this.rowStride + n8];
                    if (!floatProcedure.apply(f2)) continue;
                    f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                }
                n6 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = n2 - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n + nArray[n5 - 1] * DenseColumnFloatMatrix2D.this.rowStride + nArray2[n5 - 1] * DenseColumnFloatMatrix2D.this.columnStride]);
                        int n2 = n5 - 1;
                        while (--n2 >= n6) {
                            f = floatFloatFunction.apply(f, floatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n + nArray[n2] * DenseColumnFloatMatrix2D.this.rowStride + nArray2[n2] * DenseColumnFloatMatrix2D.this.columnStride]));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n + nArray[n2 - 1] * this.rowStride + nArray2[n2 - 1] * this.columnStride]);
            int n7 = n2 - 1;
            while (--n7 >= 0) {
                f = floatFloatFunction.apply(f, floatFunction.apply(this.elements[n + nArray[n7] * this.rowStride + nArray2[n7] * this.columnStride]));
            }
        }
        return f;
    }

    public float aggregate(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        if (!(floatMatrix2D instanceof DenseColumnFloatMatrix2D)) {
            return super.aggregate(floatMatrix2D, floatFloatFunction, floatFloatFunction2);
        }
        this.checkShape(floatMatrix2D);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)floatMatrix2D.index(0, 0);
        final int n3 = floatMatrix2D.rowStride();
        final int n4 = floatMatrix2D.columnStride();
        final float[] fArray = (float[])floatMatrix2D.elements();
        float f = 0.0f;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFloatFunction2.apply(DenseColumnFloatMatrix2D.this.elements[n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride], fArray[n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * n3 + (n7 - 1) * n4]);
                        int n6 = 1;
                        int n22 = n7;
                        while (--n22 >= n8) {
                            int n32 = n + n22 * DenseColumnFloatMatrix2D.this.columnStride;
                            int n42 = n2 + n22 * n4;
                            int n5 = DenseColumnFloatMatrix2D.this.rows - n6;
                            while (--n5 >= 0) {
                                f = floatFloatFunction.apply(f, floatFloatFunction2.apply(DenseColumnFloatMatrix2D.this.elements[n5 * DenseColumnFloatMatrix2D.this.rowStride + n32], fArray[n5 * n3 + n42]));
                            }
                            n6 = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            int n9 = 1;
            f = floatFloatFunction2.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], fArray[n2 + (this.rows - 1) * n3 + (this.columns - 1) * n4]);
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n + n10 * this.columnStride;
                int n12 = n2 + n10 * n4;
                int n13 = this.rows - n9;
                while (--n13 >= 0) {
                    f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.elements[n13 * this.rowStride + n11], fArray[n13 * n3 + n12]));
                }
                n9 = 0;
            }
        }
        return f;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        if (floatFunction instanceof FloatMult) {
                            float f = ((FloatMult)floatFunction).multiplicator;
                            int n2 = n4;
                            while (--n2 >= n5) {
                                int n3 = n9;
                                int n42 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n42 >= 0) {
                                    int n52 = n3;
                                    DenseColumnFloatMatrix2D.this.elements[n52] = DenseColumnFloatMatrix2D.this.elements[n52] * f;
                                    n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        } else {
                            int n6 = n4;
                            while (--n6 >= n5) {
                                int n7 = n9;
                                int n8 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n8 >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[n7] = floatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n7]);
                                    n7 -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (floatFunction instanceof FloatMult) {
                float f = ((FloatMult)floatFunction).multiplicator;
                int n7 = this.columns;
                while (--n7 >= 0) {
                    int n8 = n6;
                    int n9 = this.rows;
                    while (--n9 >= 0) {
                        int n10 = n8;
                        this.elements[n10] = this.elements[n10] * f;
                        n8 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            } else {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n6;
                    int n13 = this.rows;
                    while (--n13 >= 0) {
                        this.elements[n12] = floatFunction.apply(this.elements[n12]);
                        n12 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                float f = DenseColumnFloatMatrix2D.this.elements[n3];
                                if (floatProcedure.apply(f)) {
                                    DenseColumnFloatMatrix2D.this.elements[n3] = floatFunction.apply(f);
                                }
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    float f = this.elements[n8];
                    if (floatProcedure.apply(f)) {
                        this.elements[n8] = floatFunction.apply(f);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final float f) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                float f2 = DenseColumnFloatMatrix2D.this.elements[n3];
                                if (floatProcedure.apply(f2)) {
                                    DenseColumnFloatMatrix2D.this.elements[n3] = f;
                                }
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    float f2 = this.elements[n8];
                    if (floatProcedure.apply(f2)) {
                        this.elements[n8] = f;
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float f) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[n3] = f;
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    this.elements[n8] = f;
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[] fArray) {
        if ((long)fArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = this.columns - i * n3;
                    final int n5 = i == n - 1 ? 0 : n4 - n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                            int n22 = DenseColumnFloatMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnFloatMatrix2D.this.rows;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n;
                                int n52 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[n42] = fArray[n22--];
                                    n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                n -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n7 = fArray.length - 1;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        this.elements[n9] = fArray[n7--];
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[][] fArray) {
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "columns()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (n4 - 1) * DenseColumnFloatMatrix2D.this.rowStride + (DenseColumnFloatMatrix2D.this.columns - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            float[] fArray2 = fArray[n22];
                            if (fArray2.length != DenseColumnFloatMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + fArray2.length + "columns()=" + DenseColumnFloatMatrix2D.this.columns());
                            }
                            int n3 = n;
                            int n42 = DenseColumnFloatMatrix2D.this.columns;
                            while (--n42 >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[n3] = fArray2[n42];
                                n3 -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                            n -= DenseColumnFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.rows;
            while (--n7 >= 0) {
                float[] fArray2 = fArray[n7];
                if (fArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + fArray2.length + "columns()=" + this.columns());
                }
                int n8 = n6;
                int n9 = this.columns;
                while (--n9 >= 0) {
                    this.elements[n8] = fArray2[n9];
                    n8 -= this.columnStride;
                }
                n6 -= this.rowStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (!(floatMatrix2D instanceof DenseColumnFloatMatrix2D)) {
            super.assign(floatMatrix2D);
            return this;
        }
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = (DenseColumnFloatMatrix2D)floatMatrix2D;
        if (denseColumnFloatMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnFloatMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnFloatMatrix2D.isNoView) {
            System.arraycopy(denseColumnFloatMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnFloatMatrix2D)) {
            FloatMatrix2D floatMatrix2D2 = denseColumnFloatMatrix2D.copy();
            if (!(floatMatrix2D2 instanceof DenseColumnFloatMatrix2D)) {
                super.assign(denseColumnFloatMatrix2D);
                return this;
            }
            denseColumnFloatMatrix2D = (DenseColumnFloatMatrix2D)floatMatrix2D2;
        }
        final int n2 = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnFloatMatrix2D.columnStride;
        final int n5 = denseColumnFloatMatrix2D.rowStride;
        final float[] fArray = denseColumnFloatMatrix2D.elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * n5 + (n7 - 1) * n4;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n52 = n22;
                            int n6 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[n42] = fArray[n52];
                                n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                n52 -= n5;
                            }
                            n -= DenseColumnFloatMatrix2D.this.columnStride;
                            n22 -= n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = fArray[n13];
                    n12 -= this.rowStride;
                    n13 -= n5;
                }
                n9 -= this.columnStride;
                n10 -= n4;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction) {
        float f;
        if (floatFloatFunction instanceof FloatPlusMultSecond && (f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator) == 0.0f) {
            return this;
        }
        if (floatFloatFunction instanceof FloatPlusMultFirst && (f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator) == 0.0f) {
            return this.assign(floatMatrix2D);
        }
        if (!(floatMatrix2D instanceof DenseColumnFloatMatrix2D)) {
            super.assign(floatMatrix2D, floatFloatFunction);
            return this;
        }
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = (DenseColumnFloatMatrix2D)floatMatrix2D;
        this.checkShape(floatMatrix2D);
        final float[] fArray = denseColumnFloatMatrix2D.elements;
        final int n = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseColumnFloatMatrix2D.columnStride;
        final int n4 = denseColumnFloatMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n45 = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n210 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * n4 + (n7 - 1) * n3;
                        if (floatFloatFunction == FloatFunctions.mult) {
                            int n310 = n7;
                            while (--n310 >= n8) {
                                int n46 = n45;
                                int n5 = n210;
                                int n6 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n6 >= 0) {
                                    int n72 = n46;
                                    DenseColumnFloatMatrix2D.this.elements[n72] = DenseColumnFloatMatrix2D.this.elements[n72] * fArray[n5];
                                    n46 -= DenseColumnFloatMatrix2D.this.rowStride;
                                    n5 -= n4;
                                }
                                n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (floatFloatFunction == FloatFunctions.div) {
                            int n82 = n7;
                            while (--n82 >= n8) {
                                int n9 = n45;
                                int n10 = n210;
                                int n11 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n11 >= 0) {
                                    int n12 = n9;
                                    DenseColumnFloatMatrix2D.this.elements[n12] = DenseColumnFloatMatrix2D.this.elements[n12] / fArray[n10];
                                    n9 -= DenseColumnFloatMatrix2D.this.rowStride;
                                    n10 -= n4;
                                }
                                n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                            float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                            if (f == 1.0f) {
                                int n13 = n7;
                                while (--n13 >= n8) {
                                    int n14 = n45;
                                    int n15 = n210;
                                    int n16 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n16 >= 0) {
                                        int n17 = n14;
                                        DenseColumnFloatMatrix2D.this.elements[n17] = DenseColumnFloatMatrix2D.this.elements[n17] + fArray[n15];
                                        n14 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n15 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (f == -1.0f) {
                                int n18 = n7;
                                while (--n18 >= n8) {
                                    int n19 = n45;
                                    int n20 = n210;
                                    int n21 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n21 >= 0) {
                                        int n22 = n19;
                                        DenseColumnFloatMatrix2D.this.elements[n22] = DenseColumnFloatMatrix2D.this.elements[n22] - fArray[n20];
                                        n19 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n20 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n23 = n7;
                                while (--n23 >= n8) {
                                    int n24 = n45;
                                    int n25 = n210;
                                    int n26 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n26 >= 0) {
                                        int n27 = n24;
                                        DenseColumnFloatMatrix2D.this.elements[n27] = DenseColumnFloatMatrix2D.this.elements[n27] + f * fArray[n25];
                                        n24 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n25 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else if (floatFloatFunction instanceof FloatPlusMultFirst) {
                            float f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
                            if (f == 1.0f) {
                                int n28 = n7;
                                while (--n28 >= n8) {
                                    int n29 = n45;
                                    int n30 = n210;
                                    int n31 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n31 >= 0) {
                                        int n32 = n29;
                                        DenseColumnFloatMatrix2D.this.elements[n32] = DenseColumnFloatMatrix2D.this.elements[n32] + fArray[n30];
                                        n29 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n30 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (f == -1.0f) {
                                int n33 = n7;
                                while (--n33 >= n8) {
                                    int n34 = n45;
                                    int n35 = n210;
                                    int n36 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n36 >= 0) {
                                        DenseColumnFloatMatrix2D.this.elements[n34] = fArray[n35] - DenseColumnFloatMatrix2D.this.elements[n34];
                                        n34 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n35 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n37 = n7;
                                while (--n37 >= n8) {
                                    int n38 = n45;
                                    int n39 = n210;
                                    int n40 = DenseColumnFloatMatrix2D.this.rows;
                                    while (--n40 >= 0) {
                                        DenseColumnFloatMatrix2D.this.elements[n38] = f * DenseColumnFloatMatrix2D.this.elements[n38] + fArray[n39];
                                        n38 -= DenseColumnFloatMatrix2D.this.rowStride;
                                        n39 -= n4;
                                    }
                                    n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else {
                            int n41 = n7;
                            while (--n41 >= n8) {
                                int n42 = n45;
                                int n43 = n210;
                                int n44 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n44 >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[n42] = floatFloatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n42], fArray[n43]);
                                    n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                    n43 -= n4;
                                }
                                n45 -= DenseColumnFloatMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n4 + (this.columns - 1) * n3;
            if (floatFloatFunction == FloatFunctions.mult) {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n9;
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        int n15 = n12;
                        this.elements[n15] = this.elements[n15] * fArray[n13];
                        n12 -= this.rowStride;
                        n13 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (floatFloatFunction == FloatFunctions.div) {
                int n16 = this.columns;
                while (--n16 >= 0) {
                    int n17 = n9;
                    int n18 = n10;
                    int n19 = this.rows;
                    while (--n19 >= 0) {
                        int n20 = n17;
                        this.elements[n20] = this.elements[n20] / fArray[n18];
                        n17 -= this.rowStride;
                        n18 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                float f2 = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                if (f2 == 1.0f) {
                    int n21 = this.columns;
                    while (--n21 >= 0) {
                        int n22 = n9;
                        int n23 = n10;
                        int n24 = this.rows;
                        while (--n24 >= 0) {
                            int n25 = n22;
                            this.elements[n25] = this.elements[n25] + fArray[n23];
                            n22 -= this.rowStride;
                            n23 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (f2 == -1.0f) {
                    int n26 = this.columns;
                    while (--n26 >= 0) {
                        int n27 = n9;
                        int n28 = n10;
                        int n29 = this.rows;
                        while (--n29 >= 0) {
                            int n30 = n27;
                            this.elements[n30] = this.elements[n30] - fArray[n28];
                            n27 -= this.rowStride;
                            n28 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n31 = this.columns;
                    while (--n31 >= 0) {
                        int n32 = n9;
                        int n33 = n10;
                        int n34 = this.rows;
                        while (--n34 >= 0) {
                            int n35 = n32;
                            this.elements[n35] = this.elements[n35] + f2 * fArray[n33];
                            n32 -= this.rowStride;
                            n33 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else if (floatFloatFunction instanceof FloatPlusMultFirst) {
                float f3 = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
                if (f3 == 1.0f) {
                    int n36 = this.columns;
                    while (--n36 >= 0) {
                        int n37 = n9;
                        int n38 = n10;
                        int n39 = this.rows;
                        while (--n39 >= 0) {
                            int n40 = n37;
                            this.elements[n40] = this.elements[n40] + fArray[n38];
                            n37 -= this.rowStride;
                            n38 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (f3 == -1.0f) {
                    int n41 = this.columns;
                    while (--n41 >= 0) {
                        int n42 = n9;
                        int n43 = n10;
                        int n44 = this.rows;
                        while (--n44 >= 0) {
                            this.elements[n42] = fArray[n43] - this.elements[n42];
                            n42 -= this.rowStride;
                            n43 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n45 = this.columns;
                    while (--n45 >= 0) {
                        int n46 = n9;
                        int n47 = n10;
                        int n48 = this.rows;
                        while (--n48 >= 0) {
                            this.elements[n46] = f3 * this.elements[n46] + fArray[n47];
                            n46 -= this.rowStride;
                            n47 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else {
                int n49 = this.columns;
                while (--n49 >= 0) {
                    int n50 = n9;
                    int n51 = n10;
                    int n52 = this.rows;
                    while (--n52 >= 0) {
                        this.elements[n50] = floatFloatFunction.apply(this.elements[n50], fArray[n51]);
                        n50 -= this.rowStride;
                        n51 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(floatMatrix2D);
        if (!(floatMatrix2D instanceof DenseColumnFloatMatrix2D)) {
            super.assign(floatMatrix2D, floatFloatFunction);
            return this;
        }
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = (DenseColumnFloatMatrix2D)floatMatrix2D;
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final float[] fArray = denseColumnFloatMatrix2D.elements();
        final int n2 = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnFloatMatrix2D.columnStride();
        final int n5 = denseColumnFloatMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = n - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n8;
                        while (--n >= n9) {
                            int n22 = n3 + nArray[n] * DenseColumnFloatMatrix2D.this.rowStride + nArray2[n] * DenseColumnFloatMatrix2D.this.columnStride;
                            int n32 = n2 + nArray[n] * n5 + nArray2[n] * n4;
                            DenseColumnFloatMatrix2D.this.elements[n22] = floatFloatFunction.apply(DenseColumnFloatMatrix2D.this.elements[n22], fArray[n32]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            while (--n10 >= 0) {
                int n11 = n3 + nArray[n10] * this.rowStride + nArray2[n10] * this.columnStride;
                int n12 = n2 + nArray[n10] * n5 + nArray2[n10] * n4;
                this.elements[n11] = floatFloatFunction.apply(this.elements[n11], fArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n2 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n6 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n32 = n6;
                        while (--n32 >= n7) {
                            int n4 = n2;
                            int n5 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                if (DenseColumnFloatMatrix2D.this.elements[n4] != 0.0f) {
                                    ++n;
                                }
                                n4 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n2 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    if (this.elements[n10] != 0.0f) {
                        ++n;
                    }
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    public void dct2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n5)).dct(bl);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2() {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward((float[])floatMatrix2D.elements());
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n6)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.forward((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n5)).dst(bl);
            }
        }
    }

    public void dstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft2() {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward((float[])floatMatrix2D.elements());
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                float f = DenseColumnFloatMatrix2D.this.elements[n3];
                                if (f != 0.0f) {
                                    DenseColumnFloatMatrix2D.this.elements[n3] = intIntFloatFunction.apply(n42, n2, f);
                                }
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    float f = this.elements[n8];
                    if (f != 0.0f) {
                        this.elements[n8] = intIntFloatFunction.apply(n9, n7, f);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DenseFloatMatrix2D getRowMajor() {
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        final int n = (int)denseFloatMatrix2D.index(0, 0);
        final int n2 = denseFloatMatrix2D.rowStride();
        final int n3 = denseFloatMatrix2D.columnStride();
        final float[] fArray = denseFloatMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n4 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * n2 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                fArray[n5] = DenseColumnFloatMatrix2D.this.elements[n42];
                                n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                n5 -= n2;
                            }
                            n9 -= DenseColumnFloatMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n2 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    fArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n2;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return denseFloatMatrix2D;
    }

    public DenseFComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] fArray = denseFComplexMatrix2D.elements();
        final int n2 = (int)this.index(0, 0);
        final int n3 = (int)denseFComplexMatrix2D.index(0, 0);
        final int n4 = denseFComplexMatrix2D.rowStride() / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * n4 + (n7 - 1) * 1;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n5 = n22;
                            int n6 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                fArray[n5] = DenseColumnFloatMatrix2D.this.elements[n42];
                                n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                n5 -= n4;
                            }
                            n -= DenseColumnFloatMatrix2D.this.columnStride;
                            --n22;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n3 + (this.rows - 1) * n4 + (this.columns - 1) * 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    fArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n4;
                }
                n9 -= this.columnStride;
                --n10;
            }
        }
        this.fft2.realForwardFull(fArray);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getFftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseFComplexMatrix2D.viewColumn(n).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                denseFComplexMatrix2D.viewColumn(n6).assign(((DenseFloatMatrix1D)this.viewColumn(n6)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getFftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseFComplexMatrix2D.viewRow(n).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.rows;
            while (--n6 >= 0) {
                denseFComplexMatrix2D.viewRow(n6).assign(((DenseFloatMatrix1D)this.viewRow(n6)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public FComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] fArray = denseFComplexMatrix2D.elements();
        final int n2 = (int)this.index(0, 0);
        final int n3 = (int)denseFComplexMatrix2D.index(0, 0);
        final int n4 = denseFComplexMatrix2D.rowStride() / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * n4 + (n7 - 1) * 1;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n5 = n22;
                            int n6 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                fArray[n5] = DenseColumnFloatMatrix2D.this.elements[n42];
                                n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                n5 -= n4;
                            }
                            n -= DenseColumnFloatMatrix2D.this.columnStride;
                            --n22;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n3 + (this.rows - 1) * n4 + (this.columns - 1) * 1;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    fArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n4;
                }
                n9 -= this.columnStride;
                --n10;
            }
        }
        this.fft2.realInverseFull(fArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public FComplexMatrix2D getIfftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseFComplexMatrix2D.viewColumn(n).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                denseFComplexMatrix2D.viewColumn(n6).assign(((DenseFloatMatrix1D)this.viewColumn(n6)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public FComplexMatrix2D getIfftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            denseFComplexMatrix2D.viewRow(n).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.rows;
            while (--n6 >= 0) {
                denseFComplexMatrix2D.viewRow(n6).assign(((DenseFloatMatrix1D)this.viewRow(n6)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                float f = this.elements[n2];
                if (f < 0.0f) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    floatArrayList.add(f);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                float f = this.elements[n2];
                if (f != 0.0f) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    floatArrayList.add(f);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                float f = this.elements[n2];
                if (f > 0.0f) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    floatArrayList.add(f);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public float getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public void idct2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n5)).idct(bl);
            }
        }
    }

    public void idctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n6 = this.columns;
            while (--n6 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n6)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.columns - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3;
                        while (--n >= n4) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(n)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int n5 = this.columns;
            while (--n5 >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(n5)).idst(bl);
            }
        }
    }

    public void idstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(n)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft2(boolean bl) {
        FloatMatrix2D floatMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse((float[])floatMatrix2D.elements(), bl);
        this.assign(floatMatrix2D.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new DenseColumnFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new DenseFloatMatrix1D(n);
    }

    public float[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float f = DenseColumnFloatMatrix2D.this.elements[n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        int n = DenseColumnFloatMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnFloatMatrix2D.this.columnStride;
                            int n6 = DenseColumnFloatMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                float f2 = DenseColumnFloatMatrix2D.this.elements[n6 * DenseColumnFloatMatrix2D.this.rowStride + n5];
                                if (!(f < f2)) continue;
                                f = f2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f < fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    float f2 = this.elements[n12 * this.rowStride + n11];
                    if (!(f < f2)) continue;
                    f = f2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public float[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float f = DenseColumnFloatMatrix2D.this.elements[n3 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        int n = DenseColumnFloatMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnFloatMatrix2D.this.columnStride;
                            int n6 = DenseColumnFloatMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                float f2 = DenseColumnFloatMatrix2D.this.elements[n6 * DenseColumnFloatMatrix2D.this.rowStride + n5];
                                if (!(f > f2)) continue;
                                f = f2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f > fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    float f2 = this.elements[n12 * this.rowStride + n11];
                    if (!(f > f2)) continue;
                    f = f2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public void setQuick(int n, int n2, float f) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = f;
    }

    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n4 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int n3 = n;
                            int n42 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                fArray[n42][n22] = DenseColumnFloatMatrix2D.this.elements[n3];
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    fArray[n9][n7] = this.elements[n8];
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return fArray;
    }

    public FloatMatrix1D vectorize() {
        int n = (int)this.size();
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(n);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((FloatMatrix1D)denseFloatMatrix1D).elements(), 0, n);
        } else {
            final int n2 = (int)this.index(0, 0);
            final int n3 = (int)((AbstractMatrix1D)denseFloatMatrix1D).index(0);
            final int n4 = denseFloatMatrix1D.stride();
            final float[] fArray = (float[])((FloatMatrix1D)denseFloatMatrix1D).elements();
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n5 = Math.min(n5, this.columns);
                Future[] futureArray = new Future[n5];
                int n6 = this.columns / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = this.columns - i * n6;
                    final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                    final int n9 = n - i * n6 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n7 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                            int n22 = n3 + (n9 - 1) * n4;
                            int n32 = n7;
                            while (--n32 >= n8) {
                                int n42 = n;
                                int n5 = DenseColumnFloatMatrix2D.this.rows;
                                while (--n5 >= 0) {
                                    fArray[n22] = DenseColumnFloatMatrix2D.this.elements[n42];
                                    n42 -= DenseColumnFloatMatrix2D.this.rowStride;
                                    n22 -= n4;
                                }
                                n -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n11 = n3 + n - 1;
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        fArray[n11] = this.elements[n13];
                        n13 -= this.rowStride;
                        --n11;
                    }
                    n10 -= this.columnStride;
                }
            }
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, float f, float f2, boolean bl) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(bl ? this.columns : this.rows);
        }
        if ((long)(bl ? this.rows : this.columns) != floatMatrix1D.size() || (long)(bl ? this.columns : this.rows) > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D) || this.isView() || floatMatrix1D.isView() || floatMatrix1D2.isView()) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        float[] fArray = (float[])floatMatrix1D.elements();
        float[] fArray2 = (float[])floatMatrix1D2.elements();
        Transpose transpose = bl ? Transpose.Transpose : Transpose.NoTranspose;
        BLAS.getInstance().sgemv(transpose.netlib(), this.rows, this.columns, f, this.elements, Math.max(this.rows, 1), fArray, 1, f2, fArray2, 1);
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        int n3 = bl2 ? floatMatrix2D.columns() : floatMatrix2D.rows();
        int n4 = bl2 ? floatMatrix2D.rows() : floatMatrix2D.columns();
        int n5 = n;
        int n6 = n4;
        if (n2 != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + floatMatrix2D.toStringShort());
        }
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseColumnFloatMatrix2D(n5, n6);
        } else if (n != floatMatrix2D2.rows() || n4 != floatMatrix2D2.columns()) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + floatMatrix2D.toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(floatMatrix2D instanceof DenseColumnFloatMatrix2D) || !(floatMatrix2D2 instanceof DenseColumnFloatMatrix2D) || this.isView() || floatMatrix2D.isView() || floatMatrix2D2.isView()) {
            return super.zMult(floatMatrix2D, floatMatrix2D2, f, f2, bl, bl2);
        }
        Transpose transpose = bl ? Transpose.Transpose : Transpose.NoTranspose;
        Transpose transpose2 = bl2 ? Transpose.Transpose : Transpose.NoTranspose;
        float[] fArray = this.elements;
        float[] fArray2 = (float[])floatMatrix2D.elements();
        float[] fArray3 = (float[])floatMatrix2D2.elements();
        int n7 = bl ? Math.max(1, n2) : Math.max(1, n);
        int n8 = bl2 ? Math.max(1, n4) : Math.max(1, n3);
        int n9 = Math.max(1, n);
        BLAS.getInstance().sgemm(transpose.netlib(), transpose2.netlib(), n, n4, n2, f, fArray, n7, fArray2, n8, f2, fArray3, n9);
        return floatMatrix2D2;
    }

    public float zSum() {
        float f = 0.0f;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n4 = this.columns / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = this.columns - n3 * n4;
                final int n6 = n3 == n2 - 1 ? 0 : n5 - n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        int n7 = n + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (n5 - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int n2 = n5;
                        while (--n2 >= n6) {
                            int n3 = n7;
                            int n4 = DenseColumnFloatMatrix2D.this.rows;
                            while (--n4 >= 0) {
                                f += DenseColumnFloatMatrix2D.this.elements[n3];
                                n3 -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            n7 -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    f += ((Float)futureArray[n3].get()).floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n7;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    f += this.elements[n9];
                    n9 -= this.rowStride;
                }
                n7 -= this.columnStride;
            }
        }
        return f;
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D instanceof SelectedDenseColumnFloatMatrix2D) {
            SelectedDenseColumnFloatMatrix2D selectedDenseColumnFloatMatrix2D = (SelectedDenseColumnFloatMatrix2D)floatMatrix2D;
            return this.elements == selectedDenseColumnFloatMatrix2D.elements;
        }
        if (floatMatrix2D instanceof DenseColumnFloatMatrix2D) {
            DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = (DenseColumnFloatMatrix2D)floatMatrix2D;
            return this.elements == denseColumnFloatMatrix2D.elements;
        }
        return false;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        return new DenseFloatMatrix1D(n, this.elements, n2, n3, true);
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnFloatMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

