/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.VariableDemographicModel;
import java.util.ArrayList;
import java.util.Arrays;

@Deprecated
public class VDdemographicFunction
extends DemographicFunction.Abstract {
    private double[] values;
    private double[] times;
    private double[] intervals;
    private double[][] ttimes;
    private double[] alltimes;
    private boolean[] dirtyTrees;
    boolean dirty;
    private final VariableDemographicModel.Type type;
    TreeIntervals[] ti;

    public VDdemographicFunction(Tree[] treeArray, VariableDemographicModel.Type type, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        super(treeArray[0].getUnits());
        this.type = type;
        this.ti = new TreeIntervals[treeArray.length];
        this.dirtyTrees = new boolean[treeArray.length];
        Arrays.fill(this.dirtyTrees, true);
        this.ttimes = new double[this.ti.length][];
        int n = 0;
        for (int i = 0; i < this.ti.length; ++i) {
            this.ttimes[i] = new double[treeArray[i].getTaxonCount() - 1];
            n += this.ttimes[i].length;
        }
        this.alltimes = new double[n];
        this.setDirty();
        assert (type != VariableDemographicModel.Type.EXPONENTIAL || bl);
        this.setup(treeArray, dArray, dArray2, bl, bl2);
    }

    public void freeze() {
        this.ttimes = null;
        this.alltimes = null;
        this.dirtyTrees = null;
        this.ti = null;
    }

    public VDdemographicFunction(VDdemographicFunction vDdemographicFunction) {
        super(vDdemographicFunction.getUnits());
        this.type = vDdemographicFunction.type;
        this.ti = (TreeIntervals[])vDdemographicFunction.ti.clone();
        this.values = (double[])vDdemographicFunction.values.clone();
        this.times = (double[])vDdemographicFunction.times.clone();
        this.intervals = (double[])vDdemographicFunction.intervals.clone();
        this.ttimes = (double[][])vDdemographicFunction.ttimes.clone();
        for (int i = 0; i < this.ttimes.length; ++i) {
            this.ttimes[i] = (double[])this.ttimes[i].clone();
        }
        this.alltimes = (double[])vDdemographicFunction.alltimes.clone();
        this.dirtyTrees = (boolean[])vDdemographicFunction.dirtyTrees.clone();
        this.dirty = vDdemographicFunction.dirty;
    }

    public VDdemographicFunction(double[] dArray, double[] dArray2, Units.Type type) {
        this(dArray, dArray2, type, VariableDemographicModel.Type.LINEAR);
    }

    public VDdemographicFunction(double[] dArray, double[] dArray2, Units.Type type, VariableDemographicModel.Type type2) {
        super(type);
        this.type = type2;
        int n = dArray2.length;
        this.times = new double[n + 1];
        this.values = dArray2;
        this.intervals = new double[n - 1];
        this.times[0] = 0.0;
        this.times[n] = Double.POSITIVE_INFINITY;
        System.arraycopy(dArray, 0, this.times, 1, dArray.length);
        for (int i = 0; i < this.intervals.length; ++i) {
            this.intervals[i] = this.times[i + 1] - this.times[i];
        }
        this.dirty = false;
    }

    public int numberOfChanges() {
        return this.values.length - 1;
    }

    public void treeChanged(int n) {
        this.dirtyTrees[n] = true;
        this.setDirty();
    }

    public void setDirty() {
        this.dirty = true;
    }

    private boolean setTreeTimes(int n, Tree[] treeArray) {
        if (this.dirtyTrees[n]) {
            this.ti[n] = new TreeIntervals(treeArray[n]);
            TreeIntervals treeIntervals = this.ti[n];
            treeIntervals.setMultifurcationLimit(0.0);
            int n2 = treeIntervals.getIntervalCount();
            assert (n2 >= this.ttimes[n].length) : n2 + " " + this.ttimes[n].length;
            int n3 = 0;
            for (int i = 0; i < this.ttimes[n].length; ++i) {
                int n4;
                double d = treeIntervals.getInterval(n3);
                while (treeIntervals.getIntervalType(n3) != IntervalType.COALESCENT) {
                    d += treeIntervals.getInterval(++n3);
                }
                int n5 = treeIntervals.getLineageCount(n3);
                assert (++n3 != n2 || n5 == 2);
                int n6 = n4 = n3 == n2 ? 1 : treeIntervals.getLineageCount(n3);
                while (n5 <= n4) {
                    d += treeIntervals.getInterval(++n3);
                    n5 = n4;
                    n4 = treeIntervals.getLineageCount(++n3);
                }
                this.ttimes[n][i] = d + (i == 0 ? 0.0 : this.ttimes[n][i - 1]);
            }
            this.dirtyTrees[n] = false;
            return true;
        }
        return false;
    }

    void setup(Tree[] treeArray, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        if (this.dirty) {
            int n;
            int n2;
            int n3;
            if (this.type == VariableDemographicModel.Type.EXPONENTIAL) {
                bl = false;
            }
            boolean bl3 = false;
            for (n3 = 0; n3 < this.ti.length; ++n3) {
                if (!this.setTreeTimes(n3, treeArray)) continue;
                bl3 = true;
            }
            n3 = dArray.length;
            assert (n3 == this.alltimes.length + (this.type == VariableDemographicModel.Type.STEPWISE ? -1 : 0)) : " nd=" + n3 + " alltimes.length=" + this.alltimes.length + " type=" + (Object)((Object)this.type);
            if (bl3) {
                int[] nArray = new int[this.ttimes.length];
                for (n2 = 0; n2 < this.alltimes.length; ++n2) {
                    int n4 = 0;
                    while (nArray[n4] == this.ttimes[n4].length) {
                        ++n4;
                    }
                    for (n = n4 + 1; n < nArray.length; ++n) {
                        if (nArray[n] >= this.ttimes[n].length || !(this.ttimes[n][nArray[n]] < this.ttimes[n4][nArray[n4]])) continue;
                        n4 = n;
                    }
                    this.alltimes[n2] = this.ttimes[n4][nArray[n4]];
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                }
            }
            int n6 = 1;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!(dArray[n2] > 0.0)) continue;
                ++n6;
            }
            this.times = new double[n6 + 1];
            this.values = new double[n6];
            this.intervals = new double[n6 - 1];
            this.times[0] = 0.0;
            this.times[n6] = Double.POSITIVE_INFINITY;
            if (this.type != VariableDemographicModel.Type.LINEAR || !bl) {
                // empty if block
            }
            if ((n2 = 0) != 0) {
                double[] dArray3 = this.alltimes;
                if (bl2) {
                    dArray3 = new double[this.alltimes.length];
                    for (n = 0; n < dArray3.length; ++n) {
                        dArray3[n] = (this.alltimes[n] + (n > 0 ? this.alltimes[n - 1] : 0.0)) / 2.0;
                    }
                }
                this.bestLinearFit(dArray3, dArray2, dArray, this.times, this.values);
                for (n = 0; n < this.intervals.length; ++n) {
                    this.intervals[n] = this.times[n + 1] - this.times[n];
                }
                for (n = 0; n < this.values.length; ++n) {
                    if (!(this.values[n] <= 0.0)) continue;
                    this.values[n] = 1.0E-30;
                }
            }
            if (n2 == 0) {
                this.values[0] = bl ? Math.exp(dArray2[0]) : dArray2[0];
                int n7 = 0;
                for (n = 0; n < n3 && n7 + 1 < n6; ++n) {
                    if (!(dArray[n] > 0.0)) continue;
                    this.times[n7 + 1] = bl2 ? (this.alltimes[n] + (n > 0 ? this.alltimes[n - 1] : 0.0)) / 2.0 : this.alltimes[n];
                    this.values[n7 + 1] = bl ? Math.exp(dArray2[n + 1]) : dArray2[n + 1];
                    this.intervals[n7] = this.times[n7 + 1] - this.times[n7];
                    ++n7;
                }
            }
            this.dirty = false;
        }
    }

    private int ti2f(int n, int n2) {
        return n == 0 ? n2 : 2 * n + n2 + 1;
    }

    private void bestLinearFit(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        int n;
        int n2;
        int n3;
        assert (dArray.length + 1 == dArray2.length);
        assert (dArray2.length == dArray3.length + 2 || dArray2.length == dArray3.length + 1);
        int n4 = dArray2.length;
        if (n4 == 2) {
            assert (dArray.length == dArray4.length);
            assert (dArray2.length == dArray5.length);
            System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray5, 0, dArray2.length);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(0);
        for (int i = 0; i < n4 - 1; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            arrayList.add(i + 1);
        }
        double[] dArray6 = new double[dArray.length + 1];
        dArray6[0] = 0.0;
        System.arraycopy(dArray, 0, dArray6, 1, dArray.length);
        int n5 = arrayList.size();
        double[] dArray7 = new double[3 * n5];
        double[] dArray8 = new double[n5];
        for (n3 = 0; n3 < n5 - 1; ++n3) {
            n2 = (Integer)arrayList.get(n3);
            n = (Integer)arrayList.get(n3 + 1);
            double d = dArray6[n2];
            double d2 = dArray6[n] - dArray6[n2];
            int n6 = this.ti2f(n3, n3);
            int n7 = this.ti2f(n3 + 1, n3);
            for (int i = n2; i < n; ++i) {
                double d3 = dArray6[i];
                double d4 = dArray2[i];
                double d5 = (d3 - d) / d2;
                int n8 = n3;
                dArray8[n8] = dArray8[n8] + d4 * (1.0 - d5);
                int n9 = n6;
                dArray7[n9] = dArray7[n9] + (1.0 - d5) * (1.0 - d5);
                int n10 = n6 + 1;
                dArray7[n10] = dArray7[n10] + d5 * (1.0 - d5);
                int n11 = n7;
                dArray7[n11] = dArray7[n11] + d5 * (1.0 - d5);
                int n12 = n7 + 1;
                dArray7[n12] = dArray7[n12] + d5 * d5;
                int n13 = n3 + 1;
                dArray8[n13] = dArray8[n13] + d4 * d5;
            }
        }
        n3 = n5 - 1;
        n2 = (Integer)arrayList.get(n3);
        n = dArray2.length;
        int n14 = this.ti2f(n3, n3);
        for (int i = n2; i < n; ++i) {
            int n15 = n14;
            dArray7[n15] = dArray7[n15] + 1.0;
            int n16 = n3;
            dArray8[n16] = dArray8[n16] + dArray2[i];
        }
        for (n3 = 0; n3 < n5 - 1; ++n3) {
            double d = dArray7[this.ti2f(n3 + 1, n3)] / dArray7[this.ti2f(n3, n3)];
            for (n14 = n3; n14 < n3 + 3; ++n14) {
                int n17 = this.ti2f(n3 + 1, n14);
                dArray7[n17] = dArray7[n17] - dArray7[this.ti2f(n3, n14)] * d;
            }
            int n18 = n3 + 1;
            dArray8[n18] = dArray8[n18] - dArray8[n3] * d;
        }
        if (dArray5.length != n5) {
            n5 = 3;
        }
        assert (dArray5.length == n5);
        for (n3 = n5 - 1; n3 > 0; --n3) {
            dArray5[n3] = dArray8[n3] / dArray7[this.ti2f(n3, n3)];
            int n19 = n3 - 1;
            dArray8[n19] = dArray8[n19] - dArray7[this.ti2f(n3 - 1, n3)] * dArray5[n3];
        }
        dArray5[0] = dArray8[0] / dArray7[this.ti2f(0, 0)];
        assert (dArray4.length - 2 == arrayList.size() - 1);
        for (n3 = 1; n3 < dArray4.length - 1; ++n3) {
            dArray4[n3] = dArray6[(Integer)arrayList.get(n3)];
        }
    }

    private int getIntervalIndexStep(double d) {
        int n = 0;
        float f = (float)d;
        while (f > (float)this.times[n + 1]) {
            ++n;
        }
        return n;
    }

    private int getIntervalIndexLin(double d) {
        int n = 0;
        while (d > this.times[n + 1]) {
            ++n;
        }
        return n;
    }

    private double linPop(double d) {
        int n = this.getIntervalIndexLin(d);
        if (n == this.values.length - 1) {
            return this.values[n];
        }
        double d2 = (d - this.times[n]) / this.intervals[n];
        return d2 * this.values[n + 1] + (1.0 - d2) * this.values[n];
    }

    @Override
    public double getDemographic(double d) {
        double d2;
        switch (this.type) {
            case STEPWISE: {
                int n = this.getIntervalIndexStep(d);
                d2 = this.values[n];
                break;
            }
            case LINEAR: {
                d2 = this.linPop(d);
                break;
            }
            case EXPONENTIAL: {
                d2 = Math.exp(this.linPop(d));
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return d2;
    }

    @Override
    public double getIntensity(double d) {
        return this.getIntegral(0.0, d);
    }

    @Override
    public double getInverseIntensity(double d) {
        assert (false);
        return 0.0;
    }

    private double intensityLinInterval(double d, double d2, int n) {
        double d3;
        double d4 = d2 - d;
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = this.values[n];
        double d6 = d3 = n < this.values.length - 1 ? this.values[n + 1] - d5 : 0.0;
        if (d3 == 0.0) {
            return d4 / d5;
        }
        double d7 = this.times[n];
        double d8 = this.intervals[n];
        assert ((float)d <= (float)(d7 + d8) && d >= d7 && (float)d2 <= (float)(d7 + d8) && d2 >= d7);
        double d9 = (d2 - d) / d8 * d3;
        double d10 = d8 * (d5 / d3);
        double d11 = (d10 + (d2 - d7)) / (d10 + (d - d7));
        if (d9 == 0.0 || d11 <= 0.0) {
            double d12 = d5 + (d - d7) / d8 * d3;
            return d4 / d12;
        }
        return d4 * Math.log(d11) / d9;
    }

    private double intensityLinInterval(int n) {
        double d = this.intervals[n];
        double d2 = this.values[n];
        double d3 = this.values[n + 1];
        if (d2 == d3) {
            return d / d2;
        }
        return d * Math.log(d3 / d2) / (d3 - d2);
    }

    private double intensityExpInterval(double d, double d2, int n) {
        double d3 = this.values[n];
        if (n == this.intervals.length) {
            return (d2 - d) / Math.exp(d3);
        }
        double d4 = this.intervals[n];
        double d5 = this.values[n + 1];
        double d6 = this.times[n];
        assert (d >= d6 && (float)d <= (float)(d6 + d4) && (float)d2 <= (float)(d6 + d4) && d2 >= d6);
        double d7 = (d3 - d5) / d4;
        if (d7 == 0.0) {
            return (d2 - d) / Math.exp(d3);
        }
        return (Math.exp((d2 - d6) * d7 - d3) - Math.exp((d - d6) * d7 - d3)) / d7;
    }

    private double intensityExpInterval(int n) {
        double d = this.values[n];
        double d2 = this.values[n + 1];
        double d3 = this.intervals[n];
        double d4 = (d - d2) / d3;
        if (d4 == 0.0) {
            return d3 / Math.exp(d);
        }
        return Math.exp(-d) / d4 * (Math.exp(d3 * d4) - 1.0);
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = 0.0;
        switch (this.type) {
            case STEPWISE: {
                int n = this.getIntervalIndexStep(d);
                int n2 = this.getIntervalIndexStep(d2);
                double d4 = this.values[n];
                if (n == n2) {
                    d3 = (d2 - d) / d4;
                    break;
                }
                d3 = (this.times[n + 1] - d) / d4;
                for (int i = n + 1; i < n2; ++i) {
                    d3 += this.intervals[i] / this.values[i];
                }
                d3 += (d2 - this.times[n2]) / this.values[n2];
                break;
            }
            case LINEAR: {
                int n = this.getIntervalIndexLin(d);
                int n3 = this.getIntervalIndexLin(d2);
                if (n == n3) {
                    d3 += this.intensityLinInterval(d, d2, n);
                    break;
                }
                d3 += this.intensityLinInterval(d, this.times[n + 1], n);
                for (int i = n + 1; i < n3; ++i) {
                    d3 += this.intensityLinInterval(i);
                }
                d3 += this.intensityLinInterval(this.times[n3], d2, n3);
                break;
            }
            case EXPONENTIAL: {
                int n = this.getIntervalIndexLin(d);
                int n4 = this.getIntervalIndexLin(d2);
                if (n == n4) {
                    d3 += this.intensityExpInterval(d, d2, n);
                    break;
                }
                d3 += this.intensityExpInterval(d, this.times[n + 1], n);
                for (int i = n + 1; i < n4; ++i) {
                    d3 += this.intensityExpInterval(i);
                }
                d3 += this.intensityExpInterval(this.times[n4], d2, n4);
                break;
            }
        }
        return d3;
    }

    @Override
    public int getNumArguments() {
        assert (false);
        return 0;
    }

    @Override
    public String getArgumentName(int n) {
        assert (false);
        return null;
    }

    @Override
    public double getArgument(int n) {
        assert (false);
        return 0.0;
    }

    @Override
    public void setArgument(int n, double d) {
        assert (false);
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    public DemographicFunction getCopy() {
        return null;
    }

    @Override
    public double getThreshold() {
        return 1.0E-12;
    }

    @Override
    public double value(double d) {
        return 1.0 / this.getDemographic(d);
    }

    public TreeIntervals getTreeIntervals(int n) {
        return this.ti[n];
    }

    public double[] allTimePoints() {
        return this.alltimes;
    }

    public double[] times() {
        double[] dArray = new double[this.times.length - 2];
        System.arraycopy(this.times, 1, dArray, 0, this.times.length - 2);
        return dArray;
    }

    public double[] values() {
        double[] dArray = new double[this.values.length];
        if (this.type == VariableDemographicModel.Type.EXPONENTIAL) {
            for (int i = 0; i < this.values.length; ++i) {
                dArray[i] = Math.exp(this.values[i]);
            }
        } else {
            System.arraycopy(this.values, 0, dArray, 0, this.values.length);
        }
        return dArray;
    }

    public double naturalLimit() {
        return this.times[this.times.length - 2];
    }
}

